/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.entry.VirtualEntry;
import com.gigaspaces.internal.client.StorageTypeDeserialization;
import com.gigaspaces.internal.document.DocumentObjectConverterInternal;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.ITypeIntrospector;
import com.gigaspaces.internal.metadata.PropertyInfo;
import com.gigaspaces.internal.metadata.SpacePropertyInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfoRepository;
import com.gigaspaces.internal.metadata.converter.ConversionException;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.utils.ObjectUtils;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.gigaspaces.metadata.SpacePropertyDescriptor;
import com.j_spaces.core.IGSEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jini.space.InternalSpaceException;

public abstract class AbstractTypeIntrospector<T>
implements ITypeIntrospector<T> {
    private static final long serialVersionUID = 1L;
    protected static DocumentObjectConverterInternal _documentObjectConverter = DocumentObjectConverterInternal.instance();
    protected transient ITypeDesc _typeDesc;
    private final ConcurrentHashMap<String, Class<?>> _nestedPropertiesIndex = new ConcurrentHashMap();

    protected AbstractTypeIntrospector() {
    }

    protected AbstractTypeIntrospector(ITypeDesc typeDesc) {
        this._typeDesc = typeDesc;
    }

    @Override
    public void initialize(ITypeDesc typeDesc) {
        this._typeDesc = typeDesc;
    }

    @Override
    public ITypeDesc getTypeDesc() {
        return this._typeDesc;
    }

    @Override
    public String getUID(T target) {
        return this.getUID(target, false, true);
    }

    @Override
    public Object getRouting(T target) {
        String routingPropertyName = this._typeDesc.getRoutingPropertyName();
        if (routingPropertyName == null) {
            return null;
        }
        return this.getValue(target, routingPropertyName);
    }

    @Override
    public T toObject(IEntryPacket packet) {
        return this.toObject(packet, StorageTypeDeserialization.EAGER);
    }

    @Override
    public T toObject(IEntryPacket packet, StorageTypeDeserialization storageTypeDeserialization) {
        try {
            Object[] originalValues = packet.getFieldValues();
            Object[] values = storageTypeDeserialization == StorageTypeDeserialization.EAGER ? this.deserializeValues(originalValues) : originalValues;
            values = this.processDocumentObjectInterop(values, packet.getEntryType(), values == originalValues);
            return this.instantiateObject(values, packet.getDynamicProperties(), packet.getUID(), packet.getVersion(), packet.getTTL(), packet.isTransient());
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }

    protected T instantiateObject(Object[] values, Map<String, Object> dynamicProperties, String uid, int version, long timeToLive, boolean isTransient) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        T res = this.newInstance();
        if (values != null) {
            this.setValues(res, values);
        }
        this.setDynamicProperties(res, dynamicProperties);
        this.setEntryInfo(res, uid, version, timeToLive);
        this.setTransient(res, isTransient);
        this.setTimeToLive(res, timeToLive);
        return res;
    }

    protected abstract Object[] processDocumentObjectInterop(Object[] var1, EntryType var2, boolean var3);

    protected Object[] toDocumentIfNeeded(Object[] values, boolean cloneOnChange) {
        if (values == null || values.length == 0) {
            return values;
        }
        Object[] result = cloneOnChange ? new Object[values.length] : values;
        for (int i = 0; i < values.length; ++i) {
            PropertyInfo property = this._typeDesc.getFixedProperty(i);
            result[i] = _documentObjectConverter.toDocumentIfNeeded(values[i], property.getDocumentSupport());
        }
        return result;
    }

    protected Object[] fromDocumentIfNeeded(Object[] values, boolean cloneOnChange) {
        if (values == null || values.length == 0) {
            return values;
        }
        Object[] result = cloneOnChange ? new Object[values.length] : values;
        for (int i = 0; i < values.length; ++i) {
            PropertyInfo property = this._typeDesc.getFixedProperty(i);
            result[i] = _documentObjectConverter.fromDocumentIfNeeded(values[i], property.getDocumentSupport(), property.getType());
        }
        return result;
    }

    @Override
    public T toObject(IGSEntry entry, ITypeDesc typeDesc) {
        try {
            T result = this.newInstance();
            this.setValues(result, entry.getFieldsValues());
            this.setEntryInfo(result, entry.getUID(), entry.getVersion(), entry.getTimeToLive());
            this.setTransient(result, entry.isTransient());
            return result;
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }

    @Override
    public Object[] getSerializedValues(T target) {
        Object[] values = this.getValues(target);
        this.serializeValues(values);
        return values;
    }

    private void serializeValues(Object[] values) {
        if (values == null) {
            return;
        }
        if (this._typeDesc.isAllPropertiesObjectStorageType()) {
            return;
        }
        try {
            for (int i = 0; i < values.length; ++i) {
                values[i] = this._typeDesc.getFixedProperty(i).beforeSerialize(values[i]);
            }
        }
        catch (IOException e) {
            throw new ConversionException(e);
        }
    }

    private Object[] deserializeValues(Object[] values) {
        if (values == null) {
            return null;
        }
        if (this._typeDesc.isAllPropertiesObjectStorageType()) {
            return values;
        }
        try {
            Object[] clonedValues = new Object[values.length];
            System.arraycopy(values, 0, clonedValues, 0, values.length);
            for (int i = 0; i < values.length; ++i) {
                clonedValues[i] = this._typeDesc.getFixedProperty(i).afterDeserialize(values[i]);
            }
            return clonedValues;
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }

    protected abstract T newInstance() throws InstantiationException, IllegalAccessException, InvocationTargetException;

    @Override
    public Object getValue(T target, String name) {
        int pos = this._typeDesc.getFixedPropertyPosition(name);
        if (pos != -1) {
            return this.getValue(target, pos);
        }
        if (!this._typeDesc.supportsDynamicProperties()) {
            throw new IllegalArgumentException("Failed to get value of property '" + name + "' in type '" + this._typeDesc.getTypeName() + "' - it does not exist and the type does not support dynamic properties.");
        }
        return this.getDynamicProperty(target, name);
    }

    @Override
    public void setValue(T target, String name, Object value) {
        int pos = this._typeDesc.getFixedPropertyPosition(name);
        if (pos != -1) {
            this.setValue(target, value, pos);
        } else {
            if (!this._typeDesc.supportsDynamicProperties()) {
                throw new IllegalArgumentException("Failed to set value of property '" + name + "' in type '" + this._typeDesc.getTypeName() + "' - it does not exist and the type does not support dynamic properties.");
            }
            this.setDynamicProperty(target, name, value);
        }
    }

    protected abstract Object getDynamicProperty(T var1, String var2);

    @Override
    public boolean supportsNestedOperations() {
        return true;
    }

    @Override
    public Class<?> getPathType(String path) {
        Class<?> type = this._nestedPropertiesIndex.get(path);
        if (type == null && (type = this.getNestedPathType(path)) != null) {
            this._nestedPropertiesIndex.putIfAbsent(path, type);
        }
        return type;
    }

    private Class<?> getNestedPathType(String path) {
        String[] tokens = path.split("\\.");
        if (tokens == null || tokens.length == 0) {
            throw new InternalSpaceException("Error splitting property path [" + path + "].");
        }
        int i = 0;
        Class<?> type = null;
        do {
            SpacePropertyDescriptor property;
            String token = tokens[i++];
            SpacePropertyDescriptor spacePropertyDescriptor = property = type == null ? this._typeDesc.getFixedProperty(token) : SpaceTypeInfoRepository.getTypeInfo(type).getProperty(token);
            if (property == null) {
                if (this._typeDesc.supportsDynamicProperties()) {
                    return Void.TYPE;
                }
                String currentPath = StringUtils.join(tokens, ".", 0, i);
                throw new SpaceMetadataException("Unable to get nested property type for path [" + currentPath + "].");
            }
            if (ObjectUtils.equals(property.getType(), Object.class)) {
                if (property.getTypeName() != null) {
                    return Void.TYPE;
                }
                String ownerTypeName = type != null ? type.getName() : this._typeDesc.getTypeName();
                throw new SpaceMetadataException("Cannot get type of property " + property.getName() + " in class " + ownerTypeName);
            }
            type = property.getType();
            if (i != tokens.length) continue;
            return type;
        } while (!Map.class.isAssignableFrom(type) && !VirtualEntry.class.isAssignableFrom(type));
        return Void.TYPE;
    }

    @Override
    public Object getPathValue(IEntryPacket entryPacket, String path) {
        String[] tokens = path.split("\\.");
        if (tokens == null || tokens.length == 0) {
            throw new InternalSpaceException("Error splitting property path [" + path + "].");
        }
        Object object = entryPacket.getPropertyValue(tokens[0]);
        return AbstractTypeIntrospector.getPathValue(object, tokens, path);
    }

    public static Object getPathValue(Object object, String[] tokens, String path) {
        for (int i = 1; i < tokens.length; ++i) {
            if (object == null) {
                return null;
            }
            object = AbstractTypeIntrospector.getNestedValue(object, i, tokens, null, path);
        }
        return object;
    }

    public static Object getNestedValue(Object value, int position, String[] tokens, SpacePropertyInfo[] propertyInfoCache, String originalPath) {
        SpacePropertyInfo propertyInfo;
        if (position == tokens.length) {
            throw new IllegalArgumentException("[*] can only be used on Collection properties.");
        }
        if (value instanceof Map) {
            return ((Map)value).get(tokens[position]);
        }
        if (value instanceof VirtualEntry) {
            return ((VirtualEntry)value).getProperty(tokens[position]);
        }
        if (propertyInfoCache != null && propertyInfoCache[position] != null) {
            propertyInfo = propertyInfoCache[position];
        } else {
            Class<?> type = value.getClass();
            SpaceTypeInfo typeInfo = SpaceTypeInfoRepository.getTypeInfo(type);
            propertyInfo = typeInfo.getProperty(tokens[position]);
            if (propertyInfo == null) {
                throw new IllegalArgumentException("Property '" + tokens[position] + "' is not a member of " + type.getName() + " in '" + originalPath + "'");
            }
            if (propertyInfoCache != null) {
                propertyInfoCache[position] = propertyInfo;
            }
        }
        return propertyInfo.getValue(value);
    }

    @Override
    public boolean propertyHasNullValue(int position) {
        return false;
    }

    @Override
    public boolean hasConstructorProperties() {
        return false;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in, LRMIInvocationContext.getEndpointLogicalVersion());
    }

    @Override
    public void readExternal(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal(out, LRMIInvocationContext.getEndpointLogicalVersion());
    }

    @Override
    public void writeExternal(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
    }
}

