/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.ObjectUtils;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;

@InternalApi
public class ConstructorInstantiationDescriptor
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int NO_MATCH = -1;
    private transient Constructor<?> constructor;
    private Class<?>[] constructorParameterTypes;
    private String[] constructorParameterNames;
    private boolean[] excludedIndexes;
    private int[] spacePropertyToConstructorIndex;
    private int idPropertyConstructorIndex = -1;
    private int dynamicPropertiesConstructorIndex = -1;
    private int versionConstructorIndex = -1;
    private int persistConstructorIndex = -1;
    private int leaseConstructorIndex = -1;

    public Class<?>[] getConstructorParameterTypes() {
        return this.constructorParameterTypes;
    }

    public void setConstructorParameterTypes(Class<?>[] constructorParameterTypes) {
        this.constructorParameterTypes = constructorParameterTypes;
    }

    public String[] getConstructorParameterNames() {
        return this.constructorParameterNames;
    }

    public void setConstructorParameterNames(String[] constructorParameterNames) {
        this.constructorParameterNames = constructorParameterNames;
    }

    public boolean[] getExcludedIndexes() {
        return this.excludedIndexes;
    }

    public void setExcludedIndexes(boolean[] excludedIndexes) {
        this.excludedIndexes = excludedIndexes;
    }

    public int getSpacePropertyToConstructorIndex(int spacePropertyIndex) {
        if (this.spacePropertyToConstructorIndex == null || spacePropertyIndex < 0 || spacePropertyIndex >= this.spacePropertyToConstructorIndex.length) {
            return -1;
        }
        return this.spacePropertyToConstructorIndex[spacePropertyIndex];
    }

    public void setSpacePropertyToConstructorIndex(int[] spacePropertyToConstructorIndex) {
        this.spacePropertyToConstructorIndex = spacePropertyToConstructorIndex;
    }

    public int getIdPropertyConstructorIndex() {
        return this.idPropertyConstructorIndex;
    }

    public void setIdPropertyConstructorIndex(int idPropertyConstructorIndex) {
        this.idPropertyConstructorIndex = idPropertyConstructorIndex;
    }

    public int getDynamicPropertiesConstructorIndex() {
        return this.dynamicPropertiesConstructorIndex;
    }

    public void setDynamicPropertiesConstructorIndex(int dynamicPropertiesConstructorIndex) {
        this.dynamicPropertiesConstructorIndex = dynamicPropertiesConstructorIndex;
    }

    public int getVersionConstructorIndex() {
        return this.versionConstructorIndex;
    }

    public void setVersionConstructorIndex(int versionConstructorIndex) {
        this.versionConstructorIndex = versionConstructorIndex;
    }

    public int getPersistConstructorIndex() {
        return this.persistConstructorIndex;
    }

    public void setPersistConstructorIndex(int persistConstructorIndex) {
        this.persistConstructorIndex = persistConstructorIndex;
    }

    public int getLeaseConstructorIndex() {
        return this.leaseConstructorIndex;
    }

    public void setLeaseConstructorIndex(int leaseConstructorIndex) {
        this.leaseConstructorIndex = leaseConstructorIndex;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Constructor<?> constructor) {
        this.constructor = constructor;
    }

    public int getNumberOfParameters() {
        return this.constructorParameterNames == null ? 0 : this.constructorParameterNames.length;
    }

    public boolean isIndexExcluded(int index) {
        if (this.excludedIndexes == null || index < 0 || index >= this.excludedIndexes.length) {
            return false;
        }
        return this.excludedIndexes[index];
    }

    public int indexOfProperty(String propertyName) {
        if (propertyName == null) {
            return -1;
        }
        for (int i = 0; i < this.constructorParameterNames.length; ++i) {
            if (!propertyName.equals(this.constructorParameterNames[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeStringArray(out, this.constructorParameterNames);
        IOUtils.writeBooleanArray(out, this.excludedIndexes);
        IOUtils.writeIntegerArray(out, this.spacePropertyToConstructorIndex);
        for (Class<?> type : this.constructorParameterTypes) {
            IOUtils.writeString(out, type.getName());
        }
        out.writeInt(this.idPropertyConstructorIndex);
        out.writeInt(this.dynamicPropertiesConstructorIndex);
        out.writeInt(this.versionConstructorIndex);
        out.writeInt(this.persistConstructorIndex);
        out.writeInt(this.leaseConstructorIndex);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.constructorParameterNames = IOUtils.readStringArray(in);
        this.excludedIndexes = IOUtils.readBooleanArray(in);
        this.spacePropertyToConstructorIndex = IOUtils.readIntegerArray(in);
        this.constructorParameterTypes = new Class[this.constructorParameterNames.length];
        for (int i = 0; i < this.constructorParameterTypes.length; ++i) {
            Class type;
            String typeName = IOUtils.readString(in);
            this.constructorParameterTypes[i] = type = ObjectUtils.isPrimitive(typeName) ? ObjectUtils.getPrimitive(typeName) : ClassLoaderHelper.loadClass(typeName, false);
        }
        this.idPropertyConstructorIndex = in.readInt();
        this.dynamicPropertiesConstructorIndex = in.readInt();
        this.versionConstructorIndex = in.readInt();
        this.persistConstructorIndex = in.readInt();
        this.leaseConstructorIndex = in.readInt();
    }
}

