/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.ConstructorInstantiationDescriptor;
import com.gigaspaces.internal.metadata.SpacePropertyInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfo;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.gigaspaces.metadata.SpaceMetadataValidationException;
import java.lang.reflect.Constructor;

@InternalApi
public class ConstructorPropertiesHelper {
    public static String[] extractParameterNames(Constructor<?> constructor) {
        return ReflectionUtil.getConstructorParametersNames(constructor);
    }

    public static boolean possiblyGenericConstructorParameterName(String paramName) {
        if (paramName == null) {
            return true;
        }
        if (paramName.length() < 4) {
            return false;
        }
        return paramName.startsWith("arg") && Character.isDigit(paramName.charAt(4));
    }

    public static ConstructorInstantiationDescriptor buildConstructorInstantiationDescriptor(Constructor<?> constructor, String[] parameterNames, Class<?>[] parameterTypes, SpaceTypeInfo typeInfo) {
        ConstructorInstantiationDescriptor result = new ConstructorInstantiationDescriptor();
        result.setConstructor(constructor);
        int[] propertyToConstructorIndex = new int[typeInfo.getNumOfSpaceProperties()];
        for (int i = 0; i < propertyToConstructorIndex.length; ++i) {
            propertyToConstructorIndex[i] = -1;
        }
        boolean[] excludedConstructorIndexes = new boolean[parameterNames.length];
        for (int constructorIndex = 0; constructorIndex < parameterNames.length; ++constructorIndex) {
            String parameterName = parameterNames[constructorIndex];
            SpacePropertyInfo property = typeInfo.getProperty(parameterName);
            int indexOfProperty = typeInfo.indexOf(property);
            if (indexOfProperty >= 0) {
                propertyToConstructorIndex[indexOfProperty] = constructorIndex;
                if (property != typeInfo.getIdProperty()) continue;
                result.setIdPropertyConstructorIndex(constructorIndex);
                continue;
            }
            if (property != null) {
                boolean excluded = true;
                if (property == typeInfo.getVersionProperty()) {
                    result.setVersionConstructorIndex(constructorIndex);
                    excluded = false;
                }
                if (property == typeInfo.getPersistProperty()) {
                    result.setPersistConstructorIndex(constructorIndex);
                    excluded = false;
                }
                if (property == typeInfo.getLeaseExpirationProperty()) {
                    result.setLeaseConstructorIndex(constructorIndex);
                    excluded = false;
                }
                if (property == typeInfo.getDynamicPropertiesProperty()) {
                    result.setDynamicPropertiesConstructorIndex(constructorIndex);
                    excluded = false;
                }
                excludedConstructorIndexes[constructorIndex] = excluded;
                continue;
            }
            throw new SpaceMetadataValidationException(typeInfo.getType(), "Missing getter for constructor based property: " + parameterName + ". If this is not a space property, it needs to be explicitly excluded");
        }
        result.setConstructorParameterTypes(parameterTypes);
        result.setConstructorParameterNames(parameterNames);
        result.setSpacePropertyToConstructorIndex(propertyToConstructorIndex);
        result.setExcludedIndexes(excludedConstructorIndexes);
        return result;
    }
}

