/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.StorageType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class DotNetStorageType {
    private static final byte DEFAULT_CODE = 0;
    private static final byte OBJECT_CODE = 1;
    private static final byte BINARY_CODE = 2;
    private static final byte BINARY_CUSTOM_CODE = 3;
    private static final byte DOCUMENT_CODE = 4;
    public static final byte NULL = DotNetStorageType.toCode(null);

    public static void writeOld(ObjectOutput out, byte code) throws IOException {
        StorageType storageType = DotNetStorageType.fromCode(code);
        IOUtils.writeObject(out, (Object)storageType);
    }

    public static byte readOld(ObjectInput in) throws IOException, ClassNotFoundException {
        StorageType storageType = (StorageType)((Object)IOUtils.readObject(in));
        return DotNetStorageType.toCode(storageType);
    }

    private static byte toCode(StorageType storageType) {
        if (storageType == null) {
            return 1;
        }
        switch (storageType) {
            case DEFAULT: {
                return 0;
            }
            case OBJECT: {
                return 1;
            }
            case BINARY: {
                return 2;
            }
            case BINARY_CUSTOM: {
                return 3;
            }
            case DOCUMENT: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Unsupported storage type: " + (Object)((Object)storageType));
    }

    private static StorageType fromCode(byte code) {
        switch (code) {
            case 0: {
                return StorageType.DEFAULT;
            }
            case 1: {
                return StorageType.OBJECT;
            }
            case 2: {
                return StorageType.BINARY;
            }
            case 3: {
                return StorageType.BINARY_CUSTOM;
            }
            case 4: {
                return StorageType.DOCUMENT;
            }
        }
        throw new IllegalArgumentException("Unsupported storage type code: " + code);
    }
}

