/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.AbstractTypeIntrospector;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.converter.ConversionException;
import com.gigaspaces.internal.reflection.IConstructor;
import com.gigaspaces.internal.reflection.IField;
import com.gigaspaces.internal.reflection.IGetterMethod;
import com.gigaspaces.internal.reflection.IProperties;
import com.gigaspaces.internal.reflection.ISetterMethod;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.j_spaces.core.client.EntryInfo;
import com.j_spaces.core.client.version.space.SpaceVersionTable;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import net.jini.core.entry.Entry;
import net.jini.space.InternalSpaceException;

@InternalApi
public class EntryIntrospector<T extends Entry>
extends AbstractTypeIntrospector<T> {
    private static final long serialVersionUID = 1L;
    private static final byte OldVersionId = 2;
    private static final SpaceVersionTable _versionTable = SpaceVersionTable.getInstance();
    public static final byte EXTERNALIZABLE_CODE = 2;
    private boolean _isVersioned = false;
    private transient Class<T> _class;
    private transient IField<T, Object>[] _fields;
    private transient IGetterMethod<T> _uidGetter;
    private transient ISetterMethod<T> _uidSetter;
    private transient IGetterMethod<T> _infoGetter;
    private transient ISetterMethod<T> _infoSetter;
    private transient IConstructor<T> _ctor;
    private transient IProperties<T> _properties;

    public EntryIntrospector() {
    }

    public EntryIntrospector(ITypeDesc typeDesc) throws NoSuchMethodException {
        super(typeDesc);
        this._isVersioned = typeDesc.supportsOptimisticLocking();
        this.init(typeDesc.getObjectClass());
    }

    protected void init(Class<T> clz) throws NoSuchMethodException {
        this._class = clz;
        this._ctor = ReflectionUtil.createCtor(clz.getDeclaredConstructor(new Class[0]));
        List<IField> fieldsList = ReflectionUtil.getCanonicalSortedFields(clz);
        this._fields = fieldsList.toArray(new IField[fieldsList.size()]);
        Field[] fields = new Field[this._fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = (Field)this._fields[i].getMember();
        }
        this._properties = ReflectionUtil.createFieldProperties(clz, fields);
        this.initMethods(clz);
    }

    private void initMethods(Class<?> cls) {
        block11: {
            Method method;
            block10: {
                try {
                    method = cls.getMethod("__setEntryUID", String.class);
                    this._uidSetter = ReflectionUtil.createSetterMethod(method);
                }
                catch (NoSuchMethodException method2) {
                    // empty catch block
                }
                try {
                    method = cls.getMethod("__getEntryUID", new Class[0]);
                    this._uidGetter = ReflectionUtil.createGetterMethod(method);
                    if (this._uidSetter == null) {
                        throw new IllegalArgumentException("__getEntryUID was found but no __setEntryUID was found in: " + cls.getName());
                    }
                }
                catch (NoSuchMethodException ex) {
                    if (this._uidSetter == null) break block10;
                    throw new IllegalArgumentException("__setEntryUID was found but no __getEntryUID was found in: " + cls.getName(), ex);
                }
            }
            try {
                method = cls.getMethod("__setEntryInfo", EntryInfo.class);
                this._infoSetter = ReflectionUtil.createSetterMethod(method);
            }
            catch (NoSuchMethodException method3) {
                // empty catch block
            }
            try {
                method = cls.getMethod("__getEntryInfo", new Class[0]);
                this._infoGetter = ReflectionUtil.createGetterMethod(method);
                if (this._infoSetter == null) {
                    throw new IllegalArgumentException("__getEntryInfo was found but no __setEntryInfo was found in: " + cls.getName());
                }
            }
            catch (NoSuchMethodException ex) {
                if (this._infoSetter == null) break block11;
                throw new IllegalArgumentException("__setEntryInfo was found but no __getEntryInfo was found in: " + cls.getName(), ex);
            }
        }
    }

    @Override
    public Class<T> getType() {
        return this._class;
    }

    @Override
    public T newInstance() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return (T)((Entry)this._ctor.newInstance());
    }

    @Override
    protected Object[] processDocumentObjectInterop(Object[] values, EntryType entryType, boolean cloneOnChange) {
        return entryType.isVirtual() ? this.fromDocumentIfNeeded(values, cloneOnChange) : values;
    }

    @Override
    public String getUID(T target, boolean isTemplate, boolean ignoreAutoGenerateUid) {
        try {
            if (this._uidGetter != null) {
                return (String)this._uidGetter.get(target);
            }
            EntryInfo entryInfo = this.getEntryInfo(target);
            return entryInfo != null ? entryInfo.m_UID : null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean setUID(T target, String uid) {
        if (this._uidSetter != null) {
            try {
                this._uidSetter.set(target, uid);
                return true;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (this._infoGetter != null && this._infoSetter != null) {
            try {
                EntryInfo info = (EntryInfo)this._infoGetter.get(target);
                if (info != null) {
                    info.m_UID = uid;
                } else {
                    this._infoSetter.set(target, new EntryInfo(uid, 0));
                }
                return true;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (this._isVersioned) {
            _versionTable.setEntryVersion(target, new EntryInfo(uid, this.getVersion(target)));
        }
        return false;
    }

    @Override
    public int getVersion(T target) {
        try {
            EntryInfo entryInfo = this.getEntryInfo(target);
            return entryInfo != null ? entryInfo.m_VersionID : 0;
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }

    @Override
    public boolean setVersion(T target, int version) {
        if (this._infoGetter != null) {
            try {
                EntryInfo entryInfo = (EntryInfo)this._infoGetter.get(target);
                if (entryInfo == null) {
                    EntryInfo newEntryInfo = new EntryInfo(null, version);
                    this._infoSetter.set(target, newEntryInfo);
                } else {
                    entryInfo.m_VersionID = version;
                }
                return true;
            }
            catch (Exception e) {
                throw new ConversionException(e);
            }
        }
        if (this._isVersioned) {
            _versionTable.setEntryVersion(target, new EntryInfo(this.getUID(target), version));
        }
        return false;
    }

    @Override
    public boolean isTransient(T target) {
        return false;
    }

    @Override
    public boolean setTransient(T target, boolean isTransient) {
        return false;
    }

    @Override
    public boolean hasDynamicProperties() {
        return false;
    }

    @Override
    public Map<String, Object> getDynamicProperties(T target) {
        return null;
    }

    @Override
    public void setDynamicProperties(T target, Map<String, Object> dynamicProperties) {
    }

    @Override
    public Object[] getValues(T target) {
        try {
            return this._properties.getValues(target);
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }

    @Override
    public void setValues(T target, Object[] values) {
        try {
            this._properties.setValues(target, values);
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }

    @Override
    public Object getValue(T target, int index) {
        try {
            return this._fields[index].get(target);
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }

    @Override
    public void setValue(T target, Object value, int index) {
        try {
            this._fields[index].set(target, value);
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }

    @Override
    protected Object getDynamicProperty(T target, String name) {
        throw new UnsupportedOperationException("This operation is not supported for " + Entry.class + " types");
    }

    @Override
    public void setDynamicProperty(T target, String name, Object value) {
        throw new UnsupportedOperationException("This operation is not supported for " + Entry.class + " types");
    }

    @Override
    public void unsetDynamicProperty(T target, String name) {
        throw new UnsupportedOperationException("This operation is not supported for " + Entry.class + " types");
    }

    @Override
    public long getTimeToLive(T target) {
        EntryInfo entryInfo = this.getEntryInfo(target);
        return entryInfo != null ? entryInfo.m_TimeToLive : Long.MAX_VALUE;
    }

    @Override
    public boolean setTimeToLive(T target, long ttl) {
        EntryInfo info = this.getEntryInfo(target);
        if (info != null) {
            info.m_TimeToLive = ttl;
            return true;
        }
        return false;
    }

    protected EntryInfo getEntryInfo(T target) {
        try {
            if (this._infoGetter != null) {
                return (EntryInfo)this._infoGetter.get(target);
            }
            if (this._isVersioned) {
                return _versionTable.getEntryVersion(target);
            }
            return null;
        }
        catch (Exception ex) {
            throw new InternalSpaceException("Fail to invoke __getEntryInfo()", ex);
        }
    }

    @Override
    public void setEntryInfo(T target, String uid, int version, long ttl) {
        if (this._infoSetter != null) {
            try {
                this._infoSetter.set(target, new EntryInfo(uid, version, ttl));
                return;
            }
            catch (Exception ex) {
                throw new InternalSpaceException("Fail to invoke __setEntryInfo() UID: " + uid + " for Entry: " + target.getClass(), ex);
            }
        }
        this.setUID(target, uid);
        if (this._isVersioned) {
            _versionTable.setEntryVersion(target, new EntryInfo(uid, version, ttl));
        }
    }

    @Override
    public boolean hasTimeToLiveProperty(T target) {
        return this.getEntryInfo(target) != null;
    }

    @Override
    public boolean hasTransientProperty(T target) {
        return false;
    }

    @Override
    public boolean hasUID(T target) {
        boolean hasUIDProperty = this._uidSetter != null || this._infoGetter != null && this._infoSetter != null;
        return hasUIDProperty && this.getUID(target) != null;
    }

    @Override
    public boolean hasVersionProperty(T target) {
        return this._infoGetter != null;
    }

    @Override
    public boolean supportsNestedOperations() {
        return false;
    }

    @Override
    public Class<?> getPathType(String path) {
        throw new InternalSpaceException("This operation is currently not supported for Entry.");
    }

    @Override
    public byte getExternalizableCode() {
        return 2;
    }

    @Override
    public void readExternal(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        super.readExternal(in, version);
        String className = IOUtils.readString(in);
        Class cls = ClassLoaderHelper.loadClass(className);
        try {
            this.init(cls);
        }
        catch (NoSuchMethodException e) {
            throw new ClassNotFoundException(e.toString(), e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        super.writeExternal(out, version);
        IOUtils.writeString(out, this._class.getName());
    }
}

