/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.internal.version.PlatformLogicalVersion;

public enum EntryType {
    OBJECT_JAVA(1, false),
    EXTERNAL_ENTRY(4, true),
    DOCUMENT_JAVA(6, true),
    CPP(7, true),
    OBJECT_DOTNET(8, true),
    DOCUMENT_DOTNET(9, true);

    public static final int MAX = 9;
    private static final EntryType[] _values;
    private final byte _code;
    private final boolean _isVirtual;

    private EntryType(byte code, boolean isVirtual) {
        this._code = code;
        this._isVirtual = isVirtual;
    }

    public byte getTypeCode() {
        return this._code;
    }

    public byte getTypeCode(PlatformLogicalVersion version) {
        return this._code;
    }

    public static EntryType fromByte(byte typeCode) {
        return _values[typeCode];
    }

    public boolean isVirtual() {
        return this._isVirtual;
    }

    public boolean isConcrete() {
        return !this._isVirtual;
    }

    static {
        _values = new EntryType[10];
        EntryType._values[EntryType.OBJECT_JAVA._code] = OBJECT_JAVA;
        EntryType._values[2] = OBJECT_JAVA;
        EntryType._values[3] = OBJECT_JAVA;
        EntryType._values[EntryType.EXTERNAL_ENTRY._code] = EXTERNAL_ENTRY;
        EntryType._values[5] = EXTERNAL_ENTRY;
        EntryType._values[EntryType.DOCUMENT_JAVA._code] = DOCUMENT_JAVA;
        EntryType._values[EntryType.CPP._code] = CPP;
        EntryType._values[EntryType.OBJECT_DOTNET._code] = OBJECT_DOTNET;
        EntryType._values[EntryType.DOCUMENT_DOTNET._code] = DOCUMENT_DOTNET;
    }
}

