/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.StorageTypeDeserialization;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.AbstractTypeIntrospector;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.PropertyInfo;
import com.gigaspaces.internal.metadata.converter.ConversionException;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.j_spaces.core.IGSEntry;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.client.ExternalEntryUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import net.jini.space.InternalSpaceException;

@InternalApi
public class ExternalEntryIntrospector<T extends ExternalEntry>
extends AbstractTypeIntrospector<T> {
    private static final long serialVersionUID = 1L;
    private static final byte OldVersionId = 2;
    public static final byte EXTERNALIZABLE_CODE = 4;
    private Class<T> _implClass;
    private PropertyInfo[] _properties;

    public ExternalEntryIntrospector() {
    }

    public ExternalEntryIntrospector(ITypeDesc typeDesc, Class<T> implClass) {
        super(typeDesc);
        this._implClass = implClass != null ? implClass : ExternalEntry.class;
        this._properties = typeDesc.getProperties();
    }

    @Override
    public boolean hasUID(T target) {
        return this.getUID(target) != null;
    }

    @Override
    public String getUID(T target, boolean isTemplate, boolean ignoreAutoGenerateUid) {
        return ((ExternalEntry)target).getUID();
    }

    @Override
    public boolean setUID(T target, String uid) {
        ((ExternalEntry)target).setUID(uid);
        return true;
    }

    @Override
    public boolean hasVersionProperty(T target) {
        return true;
    }

    @Override
    public int getVersion(T target) {
        return ((ExternalEntry)target).getVersion();
    }

    @Override
    public boolean setVersion(T target, int version) {
        ((ExternalEntry)target).setVersion(version);
        return true;
    }

    @Override
    public boolean hasTransientProperty(T target) {
        return true;
    }

    @Override
    public boolean isTransient(T target) {
        if (target == null) {
            return false;
        }
        return ((ExternalEntry)target).isTransient();
    }

    @Override
    public boolean setTransient(T target, boolean isTransient) {
        ((ExternalEntry)target).setTransient(isTransient);
        return true;
    }

    @Override
    public boolean hasTimeToLiveProperty(T target) {
        return true;
    }

    @Override
    public long getTimeToLive(T target) {
        return ((ExternalEntry)target).getTimeToLive();
    }

    @Override
    public boolean setTimeToLive(T target, long ttl) {
        ((ExternalEntry)target).setTimeToLive(ttl);
        return true;
    }

    @Override
    public void setEntryInfo(T target, String uid, int version, long timeToLive) {
        this.setUID(target, uid);
        this.setVersion(target, version);
        this.setTimeToLive(target, timeToLive);
    }

    @Override
    public T newInstance() throws InstantiationException, IllegalAccessException {
        return (T)((ExternalEntry)this._implClass.newInstance());
    }

    @Override
    protected Object[] processDocumentObjectInterop(Object[] values, EntryType entryType, boolean cloneOnChange) {
        return values;
    }

    @Override
    public Class<T> getType() {
        return this._implClass;
    }

    @Override
    public boolean hasDynamicProperties() {
        return false;
    }

    @Override
    public Map<String, Object> getDynamicProperties(T target) {
        return null;
    }

    @Override
    public void setDynamicProperties(T target, Map<String, Object> dynamicProperties) {
    }

    @Override
    public Object getValue(T target, int index) {
        return ((ExternalEntry)target).getFieldValue(index);
    }

    @Override
    public void setValue(T target, Object value, int index) {
        ((ExternalEntry)target).setFieldValue(index, value);
    }

    @Override
    protected Object getDynamicProperty(T target, String name) {
        throw new UnsupportedOperationException("This operation is not supported for ExternalEntry types");
    }

    @Override
    public void setDynamicProperty(T target, String name, Object value) {
        throw new UnsupportedOperationException("This operation is not supported for ExternalEntry types");
    }

    @Override
    public void unsetDynamicProperty(T target, String name) {
        throw new UnsupportedOperationException("This operation is not supported for ExternalEntry types");
    }

    @Override
    public Object[] getValues(T target) {
        Object[] values = ((ExternalEntry)target).getFieldsValues();
        if (values == null) {
            return new Object[this._properties.length];
        }
        String[] fieldsNames = ((ExternalEntry)target).getFieldsNames();
        if (fieldsNames == null) {
            return values;
        }
        HashMap<String, Object> fieldNamesToValues = new HashMap<String, Object>();
        for (int i = 0; i < fieldsNames.length; ++i) {
            fieldNamesToValues.put(fieldsNames[i], values[i]);
        }
        Object[] results = new Object[this._properties.length];
        for (int i = 0; i < this._properties.length; ++i) {
            String fieldName = this._properties[i].getName();
            results[i] = fieldNamesToValues.get(fieldName);
        }
        return results;
    }

    @Override
    public void setValues(T target, Object[] values) {
        ((ExternalEntry)target).setFieldsValues(values);
    }

    @Override
    public T toObject(IEntryPacket packet, StorageTypeDeserialization storageTypeDeserialization) {
        try {
            ExternalEntry res = (ExternalEntry)super.toObject(packet, storageTypeDeserialization);
            res.setClassName(packet.getTypeName());
            ExternalEntryUtils.updateTypeDescription(res, packet.getTypeDescriptor());
            res.setFifo(packet.isFifo());
            return (T)res;
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }

    @Override
    public T toObject(IGSEntry entry, ITypeDesc typeDesc) {
        ExternalEntry result = (ExternalEntry)super.toObject(entry, typeDesc);
        ExternalEntryUtils.updateTypeDescription(result, typeDesc);
        return (T)result;
    }

    public static String getUid(ITypeDesc typeDesc, Object[] fieldsValues) {
        if (typeDesc.getIdPropertyName() == null || !typeDesc.isAutoGenerateId()) {
            return null;
        }
        int propertyId = typeDesc.getIdentifierPropertyId();
        if (fieldsValues[propertyId] != null) {
            String uid = (String)fieldsValues[propertyId];
            fieldsValues[propertyId] = null;
            return uid;
        }
        return null;
    }

    @Override
    public boolean supportsNestedOperations() {
        return false;
    }

    @Override
    public Class<?> getPathType(String path) {
        throw new InternalSpaceException("This operation is currently not supported for VirtualEntry.");
    }

    @Override
    public byte getExternalizableCode() {
        return 4;
    }

    @Override
    public void readExternal(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        super.readExternal(in, version);
        this._implClass = (Class)IOUtils.readObject(in);
        int length = in.readInt();
        if (length >= 0) {
            this._properties = new PropertyInfo[length];
            for (int i = 0; i < length; ++i) {
                this._properties[i] = (PropertyInfo)IOUtils.readObject(in);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        super.writeExternal(out, version);
        IOUtils.writeObject(out, this._implClass);
        int length = this._properties == null ? -1 : this._properties.length;
        out.writeInt(length);
        for (int i = 0; i < length; ++i) {
            IOUtils.writeObject(out, this._properties[i]);
        }
    }
}

