/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.annotation.pojo.FifoSupport;
import com.gigaspaces.api.InternalApi;

@InternalApi
public class FifoHelper {
    private static final byte DEFAULT_CODE = 0;
    private static final byte OFF_CODE = 1;
    private static final byte OPERATION_CODE = 2;
    private static final byte ALL_CODE = 3;

    private FifoHelper() {
    }

    public static byte toCode(FifoSupport fifoSupport) {
        switch (fifoSupport) {
            case NOT_SET: {
                return 0;
            }
            case DEFAULT: {
                return 0;
            }
            case OFF: {
                return 1;
            }
            case OPERATION: {
                return 2;
            }
            case ALL: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unsupported fifo support: " + (Object)((Object)fifoSupport));
    }

    public static FifoSupport fromCode(byte code) {
        switch (code) {
            case 0: {
                return FifoSupport.DEFAULT;
            }
            case 1: {
                return FifoSupport.OFF;
            }
            case 2: {
                return FifoSupport.OPERATION;
            }
            case 3: {
                return FifoSupport.ALL;
            }
        }
        throw new IllegalArgumentException("Unsupported fifo support code: " + code);
    }

    public static FifoSupport fromOld(boolean isFifo) {
        return isFifo ? FifoSupport.ALL : FifoSupport.OFF;
    }
}

