/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.internal.io.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class GsXmlParser {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.metadata.pojo");
    private static final EntityResolver _entityResolver = new GsXmlEntityResolver();

    public static void parseGsXml(InputStream inputStream, Map<String, Node> map, String sourceDesc) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = XmlUtils.getDocumentBuilder();
        documentBuilder.setEntityResolver(_entityResolver);
        Document xmlDocument = documentBuilder.parse(inputStream);
        GsXmlParser.parseGsXml(xmlDocument, map, sourceDesc);
    }

    private static void parseGsXml(Document xmlDocument, Map<String, Node> map, String sourceDesc) {
        Element xmlElement = xmlDocument.getDocumentElement();
        NodeList nodeList = xmlElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals("class")) {
                String typeName = XmlUtils.getAttribute(node, "name");
                if (map.containsKey(typeName)) {
                    if (!_logger.isLoggable(Level.WARNING)) continue;
                    _logger.log(Level.WARNING, "Found duplicate metadata for type [" + typeName + "] while scanning [" + sourceDesc + "].");
                    continue;
                }
                map.put(typeName, node);
                if (!_logger.isLoggable(Level.FINER)) continue;
                _logger.log(Level.FINER, "Found metadata for type [" + typeName + "] while scanning [" + sourceDesc + "].");
                continue;
            }
            if (!_logger.isLoggable(Level.WARNING)) continue;
            _logger.log(Level.WARNING, "Unrecognized xml node: " + nodeName);
        }
    }

    private static class GsXmlEntityResolver
    implements EntityResolver {
        private GsXmlEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicID, String systemID) throws IOException, SAXException {
            if (systemID.indexOf("gigaspaces-metadata.dtd") != -1) {
                return new InputSource(this.getClass().getClassLoader().getResourceAsStream("gigaspaces-metadata.dtd"));
            }
            return null;
        }
    }
}

