/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.annotation.pojo.SpaceClass;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class IncludePropertiesHelper {
    private static final byte CODE_NULL = -1;
    private static final byte CODE_IMPLICIT = 0;
    private static final byte CODE_EXPLICIT = 1;

    public static void writeExternal(ObjectOutput out, SpaceClass.IncludeProperties value) throws IOException {
        int code = -1;
        if (value != null) {
            switch (value) {
                case IMPLICIT: {
                    code = 0;
                    break;
                }
                case EXPLICIT: {
                    code = 1;
                    break;
                }
                default: {
                    code = -1;
                }
            }
        }
        out.writeByte(code);
    }

    public static SpaceClass.IncludeProperties readExternal(ObjectInput in) throws IOException {
        byte code = in.readByte();
        switch (code) {
            case -1: {
                return null;
            }
            case 0: {
                return SpaceClass.IncludeProperties.IMPLICIT;
            }
            case 1: {
                return SpaceClass.IncludeProperties.EXPLICIT;
            }
        }
        return null;
    }
}

