/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.annotation.pojo.SpaceProperty;
import com.gigaspaces.metadata.index.SpaceIndexType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class IndexTypeHelper {
    private static final byte CODE_NOT_SET = -1;
    private static final byte CODE_NONE = 0;
    private static final byte CODE_BASIC = 1;
    private static final byte CODE_EXTENDED = 2;

    public static void writeExternal(ObjectOutput out, SpaceProperty.IndexType value) throws IOException {
        int code = -1;
        if (value != null) {
            switch (value) {
                case NONE: {
                    code = 0;
                    break;
                }
                case BASIC: {
                    code = 1;
                    break;
                }
                case EXTENDED: {
                    code = 2;
                    break;
                }
                default: {
                    code = -1;
                }
            }
        }
        out.writeByte(code);
    }

    public static SpaceProperty.IndexType readExternal(ObjectInput in) throws IOException {
        byte code = in.readByte();
        switch (code) {
            case -1: {
                return SpaceProperty.IndexType.NOT_SET;
            }
            case 0: {
                return SpaceProperty.IndexType.NONE;
            }
            case 1: {
                return SpaceProperty.IndexType.BASIC;
            }
            case 2: {
                return SpaceProperty.IndexType.EXTENDED;
            }
        }
        return SpaceProperty.IndexType.NOT_SET;
    }

    public static SpaceProperty.IndexType fromOld(boolean isIndex) {
        return isIndex ? SpaceProperty.IndexType.BASIC : SpaceProperty.IndexType.NONE;
    }

    public static SpaceIndexType[] fromOld(boolean[] indexIndicators) {
        if (indexIndicators == null) {
            return null;
        }
        SpaceIndexType[] indexTypes = new SpaceIndexType[indexIndicators.length];
        for (int i = 0; i < indexTypes.length; ++i) {
            indexTypes[i] = indexIndicators[i] ? SpaceIndexType.EQUAL : SpaceIndexType.NONE;
        }
        return indexTypes;
    }
}

