/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.DocumentProperties;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.AbstractTypeIntrospector;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.SpacePropertyInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfoRepository;
import com.gigaspaces.internal.metadata.converter.ConversionException;
import com.gigaspaces.internal.reflection.IConstructor;
import com.gigaspaces.internal.reflection.IParamsConstructor;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.gigaspaces.metadata.SpaceMetadataValidationException;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.IGSEntry;
import com.j_spaces.core.client.ClientUIDHandler;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

@InternalApi
public class PojoIntrospector<T>
extends AbstractTypeIntrospector<T> {
    private static final long serialVersionUID = 1L;
    private static final byte OldVersionId = 3;
    public static final byte EXTERNALIZABLE_CODE = 1;
    private SpaceTypeInfo _typeInfo;
    private transient IConstructor<T> _constructor;
    private transient SpacePropertyInfo _idProperty;
    private transient SpacePropertyInfo _versionProperty;
    private transient SpacePropertyInfo _timeToLiveProperty;
    private transient SpacePropertyInfo _transientProperty;
    private transient SpacePropertyInfo _dynamicPropertiesProperty;
    private transient boolean _isAutoPkGen;
    private transient boolean _transient;
    private transient Class<T> _pojoClass;

    public PojoIntrospector() {
    }

    public PojoIntrospector(ITypeDesc typeDesc) {
        super(typeDesc);
        SpaceTypeInfo typeInfo = SpaceTypeInfoRepository.getTypeInfo(typeDesc.getObjectClass());
        this.init(typeInfo);
    }

    @Override
    public Class<T> getType() {
        return this._pojoClass;
    }

    @Override
    public T newInstance() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return this._constructor.newInstance();
    }

    @Override
    public T toObject(IGSEntry entry, ITypeDesc typeDesc) {
        if (!this._typeInfo.hasConstructorProperties()) {
            return super.toObject(entry, typeDesc);
        }
        try {
            return this.instantiateObjectByConstructor(entry.getFieldsValues(), null, entry.getUID(), entry.getVersion(), entry.getTimeToLive(), entry.isTransient());
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }

    @Override
    protected T instantiateObject(Object[] values, Map<String, Object> dynamicProperties, String uid, int version, long timeToLive, boolean isTransient) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (!this._typeInfo.hasConstructorProperties()) {
            return super.instantiateObject(values, dynamicProperties, uid, version, timeToLive, isTransient);
        }
        return this.instantiateObjectByConstructor(values, dynamicProperties, uid, version, timeToLive, isTransient);
    }

    private T instantiateObjectByConstructor(Object[] values, Map<String, Object> dynamicProperties, String uid, int version, long timeToLive, boolean isTransient) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        return (T)this._typeInfo.createConstructorBasedInstance(values, dynamicProperties, uid, version, PojoIntrospector.calculateLease(timeToLive), !isTransient);
    }

    @Override
    protected Object[] processDocumentObjectInterop(Object[] values, EntryType entryType, boolean cloneOnChange) {
        return entryType.isVirtual() ? this.fromDocumentIfNeeded(values, cloneOnChange) : values;
    }

    public boolean hasPkField() {
        return this._idProperty != null;
    }

    @Override
    public int getVersion(T target) {
        if (this._versionProperty == null) {
            return 0;
        }
        Integer version = (Integer)this._versionProperty.getValue(target);
        return version == null ? 0 : version;
    }

    @Override
    public boolean setVersion(T target, int version) {
        if (this._versionProperty == null) {
            return false;
        }
        try {
            this._versionProperty.setValue(target, version);
            return true;
        }
        catch (Throwable e) {
            throw new ConversionException("Failed to set pojo version", e);
        }
    }

    @Override
    public long getTimeToLive(T target) {
        if (this._timeToLiveProperty == null) {
            return Long.MAX_VALUE;
        }
        Long ttl = (Long)this._timeToLiveProperty.getValue(target);
        long realTTL = ttl == null ? 0L : ttl;
        return realTTL - SystemTime.timeMillis();
    }

    @Override
    public boolean setTimeToLive(T target, long ttl) {
        if (this._timeToLiveProperty == null) {
            return false;
        }
        try {
            this._timeToLiveProperty.setValue(target, PojoIntrospector.calculateLease(ttl));
            return true;
        }
        catch (Throwable e) {
            throw new ConversionException("Failed to set pojo lease.", e);
        }
    }

    private static long calculateLease(long ttl) {
        return ttl == Long.MAX_VALUE ? ttl : ttl + SystemTime.timeMillis();
    }

    @Override
    public boolean isTransient(T target) {
        if (this._transientProperty == null || target == null) {
            return this._transient;
        }
        try {
            Boolean persistent = (Boolean)this.getValue(target, this._transientProperty);
            return persistent == null ? true : persistent == false;
        }
        catch (Exception e) {
            throw new ConversionException("Failed to get pojo transient", e);
        }
    }

    @Override
    public boolean setTransient(T target, boolean isTransient) {
        if (this._transientProperty == null) {
            return false;
        }
        try {
            this._transientProperty.setValue(target, !isTransient);
            return true;
        }
        catch (Exception e) {
            throw new ConversionException("Failed to set pojo transient", e);
        }
    }

    @Override
    public boolean hasDynamicProperties() {
        return this._dynamicPropertiesProperty != null;
    }

    @Override
    public Map<String, Object> getDynamicProperties(T target) {
        if (this._dynamicPropertiesProperty == null) {
            return null;
        }
        Map properties = (Map)this._dynamicPropertiesProperty.getValue(target);
        if (properties == null) {
            return null;
        }
        DocumentProperties dynamicProperties = new DocumentProperties(properties.size());
        for (Map.Entry entry : properties.entrySet()) {
            if (this._typeDesc.getFixedPropertyPosition((String)entry.getKey()) != -1) {
                throw new SpaceMetadataException("Illegal dynamic property '" + (String)entry.getKey() + "' in type '" + this._typeDesc.getTypeName() + "' - this property is defined as a fixed property.");
            }
            dynamicProperties.put((String)entry.getKey(), entry.getValue());
        }
        return dynamicProperties;
    }

    @Override
    public void setDynamicProperties(T target, Map<String, Object> dynamicProperties) {
        if (this._dynamicPropertiesProperty == null) {
            return;
        }
        if (dynamicProperties == null) {
            this._dynamicPropertiesProperty.setValue(target, null);
        } else {
            Map properties = (Map)this._dynamicPropertiesProperty.getValue(target);
            if (properties == null) {
                properties = new DocumentProperties();
                this._dynamicPropertiesProperty.setValue(target, properties);
            }
            properties.putAll(dynamicProperties);
        }
    }

    @Override
    public Object[] getValues(T target) {
        try {
            Object[] values = this._typeInfo.getSpacePropertiesValues(target, false);
            for (int i = 0; i < values.length; ++i) {
                SpacePropertyInfo property = this._typeInfo.getProperty(i);
                values[i] = this._isAutoPkGen && property == this._idProperty ? null : property.convertToNullIfNeeded(values[i]);
            }
            return values;
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }

    @Override
    public void setValues(T target, Object[] values) {
        try {
            this._typeInfo.setSpacePropertiesValues(target, values);
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }

    @Override
    public Object getValue(T target, int index) {
        try {
            return this.getValue(target, this._typeInfo.getProperty(index));
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }

    private Object getValue(T target, SpacePropertyInfo property) {
        Object value = property.getValue(target);
        return property.convertToNullIfNeeded(value);
    }

    @Override
    public void setValue(T target, Object value, int index) {
        try {
            this.setValue(target, this._typeInfo.getProperty(index), value);
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }

    private void setValue(T target, SpacePropertyInfo property, Object value) {
        value = property.convertFromNullIfNeeded(value);
        property.setValue(target, value);
    }

    @Override
    protected Object getDynamicProperty(T target, String name) {
        if (this._dynamicPropertiesProperty == null) {
            return null;
        }
        Map properties = (Map)this._dynamicPropertiesProperty.getValue(target);
        if (properties == null) {
            return null;
        }
        return properties.get(name);
    }

    @Override
    public void setDynamicProperty(T target, String name, Object value) {
        if (this._dynamicPropertiesProperty != null) {
            Map properties = (Map)this._dynamicPropertiesProperty.getValue(target);
            if (properties == null) {
                properties = new DocumentProperties();
                this._dynamicPropertiesProperty.setValue(target, properties);
            }
            properties.put(name, value);
        }
    }

    @Override
    public void unsetDynamicProperty(T target, String name) {
        Map properties;
        if (this._dynamicPropertiesProperty != null && (properties = (Map)this._dynamicPropertiesProperty.getValue(target)) != null) {
            properties.remove(name);
        }
    }

    private void init(SpaceTypeInfo typeInfo) {
        this._typeInfo = typeInfo;
        this._pojoClass = typeInfo.getType();
        if (typeInfo.hasConstructorProperties()) {
            IParamsConstructor<?> paramsConstructor = typeInfo.getParamsConstructor();
            if (paramsConstructor == null) {
                throw new SpaceMetadataValidationException(this._pojoClass, "Missing expected constructor");
            }
        } else {
            this._constructor = typeInfo.getDefaultConstructor();
            if (this._constructor == null) {
                throw new SpaceMetadataValidationException(this._pojoClass, "Must be a public static class and have a default constructor.");
            }
        }
        this._idProperty = typeInfo.getIdProperty();
        this._versionProperty = typeInfo.getVersionProperty();
        this._timeToLiveProperty = typeInfo.getLeaseExpirationProperty();
        this._transientProperty = typeInfo.getPersistProperty();
        this._dynamicPropertiesProperty = typeInfo.getDynamicPropertiesProperty();
        this._isAutoPkGen = typeInfo.getIdAutoGenerate();
        this._transient = !typeInfo.isPersist();
    }

    @Override
    public String getUID(T target, boolean isTemplate, boolean ignoreIdIfNotExists) {
        if (this._idProperty == null) {
            if (ignoreIdIfNotExists) {
                return null;
            }
            throw new SpaceMetadataException("Cannot get uid - SpaceId property is not defined.");
        }
        Object id = this.getValue(target, this._idProperty);
        if (this._isAutoPkGen) {
            if (id != null) {
                return id.toString();
            }
            if (ignoreIdIfNotExists) {
                return null;
            }
            throw new SpaceMetadataException("SpaceId(autoGenerate=true) property value cannot be null.");
        }
        if (isTemplate) {
            return null;
        }
        if (id != null) {
            return ClientUIDHandler.createUIDFromName(id.toString(), this.getType().getName());
        }
        throw new SpaceMetadataException("SpaceId(autoGenerate=false) property value cannot be null.");
    }

    @Override
    public boolean setUID(T target, String uid) {
        try {
            if (this._idProperty == null) {
                return false;
            }
            if (!this._isAutoPkGen) {
                return false;
            }
            String fieldValue = (String)this.getValue(target, this._idProperty);
            if (fieldValue != null && fieldValue.length() != 0) {
                return false;
            }
            this.setValue(target, this._idProperty, (Object)uid);
            return true;
        }
        catch (Exception e) {
            throw new SpaceMetadataException("Failed to set uid for type " + this.getType().getName(), e);
        }
    }

    @Override
    public void setEntryInfo(T target, String uid, int version, long ttl) {
        this.setUID(target, uid);
        this.setVersion(target, version);
    }

    @Override
    public boolean hasTimeToLiveProperty(T target) {
        return this._timeToLiveProperty != null;
    }

    @Override
    public boolean hasTransientProperty(T target) {
        return this._transientProperty != null;
    }

    @Override
    public boolean hasUID(T target) {
        return this._idProperty != null && this._isAutoPkGen && this.getValue(target, this._idProperty) != null;
    }

    @Override
    public boolean hasVersionProperty(T target) {
        return this._versionProperty != null;
    }

    @Override
    public boolean propertyHasNullValue(int position) {
        return this._typeInfo.getProperty(position).hasNullValue();
    }

    @Override
    public boolean hasConstructorProperties() {
        return this._typeInfo.hasConstructorProperties();
    }

    @Override
    public byte getExternalizableCode() {
        return 1;
    }

    @Override
    public void readExternal(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        super.readExternal(in, version);
        if (version.greaterOrEquals(PlatformLogicalVersion.v10_1_0)) {
            this.readExternalV10_1(in, version);
        } else {
            this.readExternalV7_1(in);
        }
    }

    private void readExternalV10_1(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        SpaceTypeInfo typeInfo = new SpaceTypeInfo();
        typeInfo.readExternal(in, version);
        this.init(typeInfo);
    }

    private void readExternalV7_1(ObjectInput in) throws IOException, ClassNotFoundException {
        SpaceTypeInfo typeInfo = (SpaceTypeInfo)IOUtils.readObject(in);
        this.init(typeInfo);
    }

    @Override
    public void writeExternal(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        super.writeExternal(out, version);
        if (version.greaterOrEquals(PlatformLogicalVersion.v10_1_0)) {
            this.writeExternalV10_1(out, version);
        } else {
            this.writeExternalV7_1(out);
        }
    }

    private void writeExternalV10_1(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        this._typeInfo.writeExternal(out, version);
    }

    private void writeExternalV7_1(ObjectOutput out) throws IOException {
        IOUtils.writeObject(out, this._typeInfo);
    }
}

