/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.utils.SerializationUtil;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.DotNetStorageType;
import com.gigaspaces.internal.metadata.SpaceDocumentSupportHelper;
import com.gigaspaces.internal.utils.ClassUtils;
import com.gigaspaces.internal.utils.ReflectionUtils;
import com.gigaspaces.metadata.SpaceDocumentSupport;
import com.gigaspaces.metadata.SpacePropertyDescriptor;
import com.gigaspaces.metadata.StorageType;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class PropertyInfo
implements SpacePropertyDescriptor,
Externalizable {
    private static final long serialVersionUID = 1L;
    private String _name;
    private String _typeName;
    private boolean _primitive;
    private boolean _spacePrimitive;
    private boolean _comparable;
    private Class<?> _type;
    private SpaceDocumentSupport _documentSupport;
    private StorageType _storageType;
    private byte _dotnetStorageType;

    public PropertyInfo() {
    }

    public PropertyInfo(String name, String typeName, SpaceDocumentSupport documentSupport, StorageType storageType) {
        this(name, typeName, null, documentSupport, storageType, DotNetStorageType.NULL);
    }

    public PropertyInfo(String name, Class<?> type, SpaceDocumentSupport documentSupport, StorageType storageType) {
        this(name, type.getName(), type, documentSupport, storageType, DotNetStorageType.NULL);
    }

    public PropertyInfo(String name, String typeName, Class<?> type, SpaceDocumentSupport documentSupport, StorageType storageType, byte dotNetStorageType) {
        this._name = name;
        this._typeName = typeName;
        this._type = type == null ? PropertyInfo.getTypeFromName(typeName) : type;
        this._primitive = ReflectionUtils.isPrimitive(typeName);
        this._spacePrimitive = ReflectionUtils.isSpacePrimitive(this._typeName);
        this._documentSupport = documentSupport != SpaceDocumentSupport.DEFAULT ? documentSupport : SpaceDocumentSupportHelper.getDefaultDocumentSupport(this._type);
        this._storageType = storageType;
        this._dotnetStorageType = dotNetStorageType;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getTypeName() {
        return this._typeName;
    }

    @Override
    public String getTypeDisplayName() {
        return ClassUtils.getTypeDisplayName(this._typeName);
    }

    @Override
    public Class<?> getType() {
        return this._type;
    }

    @Override
    public SpaceDocumentSupport getDocumentSupport() {
        return this._documentSupport;
    }

    @Override
    public StorageType getStorageType() {
        return this._storageType;
    }

    public void setDefaultStorageType(StorageType defaultStorageType) {
        this._storageType = this._spacePrimitive ? StorageType.OBJECT : defaultStorageType;
    }

    public byte getDotnetStorageType() {
        return this._dotnetStorageType;
    }

    public boolean isPrimitive() {
        return this._primitive;
    }

    public boolean isSpacePrimitive() {
        return this._spacePrimitive;
    }

    public String toString() {
        return "Property[name=" + this._name + ", type=" + this._typeName + "]";
    }

    public Object beforeSerialize(Object value) throws IOException {
        if (this._spacePrimitive) {
            return value;
        }
        return SerializationUtil.serializeFieldValue(value, this._storageType);
    }

    public Object afterDeserialize(Object value) throws IOException, ClassNotFoundException {
        if (this._spacePrimitive) {
            return value;
        }
        return SerializationUtil.deSerializeFieldValue(value, this._storageType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._name = IOUtils.readString(in);
        this._typeName = IOUtils.readString(in);
        this._spacePrimitive = in.readBoolean();
        this._comparable = in.readBoolean();
        this._type = PropertyInfo.getTypeFromName(this._typeName);
        this._documentSupport = SpaceDocumentSupport.DEFAULT;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeString(out, this._name);
        IOUtils.writeString(out, this._typeName);
        out.writeBoolean(this._spacePrimitive);
        out.writeBoolean(this._comparable);
    }

    private static Class<?> getTypeFromName(String typeName) {
        if (typeName == null || typeName.length() == 0) {
            return Object.class;
        }
        try {
            return ClassLoaderHelper.loadClass(typeName);
        }
        catch (ClassNotFoundException e) {
            return Object.class;
        }
    }

    public boolean isCommonJavaType() {
        return ReflectionUtils.isCommonJavaType(this._typeName);
    }
}

