/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.valuegetter.SpaceEntryCollectionValuesExtractor;
import com.gigaspaces.metadata.index.AbstractSpaceIndex;
import com.gigaspaces.metadata.index.ISpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndexType;
import com.gigaspaces.server.ServerEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class SpaceCollectionIndex
extends AbstractSpaceIndex {
    private static final long serialVersionUID = -7040439531937379040L;
    public static final String COLLECTION_INDICATOR = "[*]";
    protected SpaceEntryCollectionValuesExtractor _valuesExtractor;

    public SpaceCollectionIndex() {
    }

    public SpaceCollectionIndex(String path, SpaceIndexType indexType, boolean unique) {
        super(path, indexType, unique);
        this._valuesExtractor = new SpaceEntryCollectionValuesExtractor(path);
    }

    @Override
    public Object getIndexValue(ServerEntry entry) {
        return this._valuesExtractor.getValue(entry);
    }

    @Override
    public Object getIndexValueForTemplate(ServerEntry entry) {
        return this.getIndexValueFromCustomIndex(entry);
    }

    @Override
    public boolean isMultiValuePerEntryIndex() {
        return true;
    }

    @Override
    public ISpaceIndex.MultiValuePerEntryIndexTypes getMultiValueIndexType() {
        return ISpaceIndex.MultiValuePerEntryIndexTypes.COLLECTION;
    }

    @Override
    public ISpaceIndex.IndexOriginTypes getIndexOriginType() {
        return ISpaceIndex.IndexOriginTypes.COLLECTION;
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        this._valuesExtractor = (SpaceEntryCollectionValuesExtractor)IOUtils.readObject(in);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this._valuesExtractor = (SpaceEntryCollectionValuesExtractor)IOUtils.readNullableSwapExternalizableObject(in);
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
        IOUtils.writeObject(out, this._valuesExtractor);
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        IOUtils.writeNullableSwapExternalizableObject(out, this._valuesExtractor);
    }
}

