/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.DocumentProperties;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.metadata.SpaceDocumentSupport;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

@InternalApi
public class SpaceDocumentSupportHelper {
    private static final byte CODE_DEFAULT = 0;
    private static final byte CODE_CONVERT = 2;
    private static final byte CODE_COPY = 1;
    private static final Map<Class<?>, SpaceDocumentSupport> _defaultTypesDocumentSupport = SpaceDocumentSupportHelper.initDefaultTypesDocumentSupport();

    public static byte toCode(SpaceDocumentSupport documentSupport) {
        switch (documentSupport) {
            case DEFAULT: {
                return 0;
            }
            case CONVERT: {
                return 2;
            }
            case COPY: {
                return 1;
            }
        }
        return 0;
    }

    public static SpaceDocumentSupport fromCode(byte code) {
        switch (code) {
            case 0: {
                return SpaceDocumentSupport.DEFAULT;
            }
            case 2: {
                return SpaceDocumentSupport.CONVERT;
            }
            case 1: {
                return SpaceDocumentSupport.COPY;
            }
        }
        return SpaceDocumentSupport.DEFAULT;
    }

    private static Map<Class<?>, SpaceDocumentSupport> initDefaultTypesDocumentSupport() {
        HashMap result = new HashMap();
        result.put(Byte.TYPE, SpaceDocumentSupport.COPY);
        result.put(byte[].class, SpaceDocumentSupport.COPY);
        result.put(Short.TYPE, SpaceDocumentSupport.COPY);
        result.put(short[].class, SpaceDocumentSupport.COPY);
        result.put(Integer.TYPE, SpaceDocumentSupport.COPY);
        result.put(int[].class, SpaceDocumentSupport.COPY);
        result.put(Long.TYPE, SpaceDocumentSupport.COPY);
        result.put(long[].class, SpaceDocumentSupport.COPY);
        result.put(Float.TYPE, SpaceDocumentSupport.COPY);
        result.put(float[].class, SpaceDocumentSupport.COPY);
        result.put(Double.TYPE, SpaceDocumentSupport.COPY);
        result.put(double[].class, SpaceDocumentSupport.COPY);
        result.put(Boolean.TYPE, SpaceDocumentSupport.COPY);
        result.put(boolean[].class, SpaceDocumentSupport.COPY);
        result.put(Character.TYPE, SpaceDocumentSupport.COPY);
        result.put(char[].class, SpaceDocumentSupport.COPY);
        result.put(Byte.class, SpaceDocumentSupport.COPY);
        result.put(Byte[].class, SpaceDocumentSupport.COPY);
        result.put(Short.class, SpaceDocumentSupport.COPY);
        result.put(Short[].class, SpaceDocumentSupport.COPY);
        result.put(Integer.class, SpaceDocumentSupport.COPY);
        result.put(Integer[].class, SpaceDocumentSupport.COPY);
        result.put(Long.class, SpaceDocumentSupport.COPY);
        result.put(Long[].class, SpaceDocumentSupport.COPY);
        result.put(Float.class, SpaceDocumentSupport.COPY);
        result.put(Float[].class, SpaceDocumentSupport.COPY);
        result.put(Double.class, SpaceDocumentSupport.COPY);
        result.put(Double[].class, SpaceDocumentSupport.COPY);
        result.put(Boolean.class, SpaceDocumentSupport.COPY);
        result.put(Boolean[].class, SpaceDocumentSupport.COPY);
        result.put(Character.class, SpaceDocumentSupport.COPY);
        result.put(Character[].class, SpaceDocumentSupport.COPY);
        result.put(Object.class, SpaceDocumentSupport.DEFAULT);
        result.put(String.class, SpaceDocumentSupport.COPY);
        result.put(java.util.Date.class, SpaceDocumentSupport.COPY);
        result.put(UUID.class, SpaceDocumentSupport.COPY);
        result.put(Calendar.class, SpaceDocumentSupport.COPY);
        result.put(Date.class, SpaceDocumentSupport.COPY);
        result.put(Time.class, SpaceDocumentSupport.COPY);
        result.put(Timestamp.class, SpaceDocumentSupport.COPY);
        result.put(BigDecimal.class, SpaceDocumentSupport.COPY);
        result.put(BigInteger.class, SpaceDocumentSupport.COPY);
        result.put(HashMap.class, SpaceDocumentSupport.COPY);
        result.put(TreeMap.class, SpaceDocumentSupport.COPY);
        result.put(WeakHashMap.class, SpaceDocumentSupport.COPY);
        result.put(IdentityHashMap.class, SpaceDocumentSupport.COPY);
        result.put(ConcurrentHashMap.class, SpaceDocumentSupport.COPY);
        result.put(ArrayList.class, SpaceDocumentSupport.DEFAULT);
        result.put(LinkedList.class, SpaceDocumentSupport.DEFAULT);
        result.put(HashSet.class, SpaceDocumentSupport.DEFAULT);
        result.put(TreeSet.class, SpaceDocumentSupport.DEFAULT);
        result.put(Class.class, SpaceDocumentSupport.COPY);
        result.put(URI.class, SpaceDocumentSupport.COPY);
        result.put(Locale.class, SpaceDocumentSupport.COPY);
        result.put(SpaceDocument.class, SpaceDocumentSupport.COPY);
        result.put(DocumentProperties.class, SpaceDocumentSupport.COPY);
        result.put(LocalDateTime.class, SpaceDocumentSupport.COPY);
        result.put(LocalDate.class, SpaceDocumentSupport.COPY);
        result.put(LocalTime.class, SpaceDocumentSupport.COPY);
        result.put(Duration.class, SpaceDocumentSupport.COPY);
        result.put(DayOfWeek.class, SpaceDocumentSupport.COPY);
        result.put(MonthDay.class, SpaceDocumentSupport.COPY);
        result.put(Period.class, SpaceDocumentSupport.COPY);
        result.put(Year.class, SpaceDocumentSupport.COPY);
        result.put(YearMonth.class, SpaceDocumentSupport.COPY);
        result.put(ZonedDateTime.class, SpaceDocumentSupport.COPY);
        result.put(ZoneId.class, SpaceDocumentSupport.COPY);
        result.put(ZoneOffset.class, SpaceDocumentSupport.COPY);
        result.put(Instant.class, SpaceDocumentSupport.COPY);
        result.put(OffsetDateTime.class, SpaceDocumentSupport.COPY);
        result.put(OffsetTime.class, SpaceDocumentSupport.COPY);
        return result;
    }

    public static SpaceDocumentSupport getDefaultDocumentSupport(Class<?> type) {
        SpaceDocumentSupport result = _defaultTypesDocumentSupport.get(type);
        if (result != null) {
            return result;
        }
        if (Map.class.isAssignableFrom(type)) {
            return SpaceDocumentSupport.COPY;
        }
        if (Collection.class.isAssignableFrom(type)) {
            return SpaceDocumentSupport.DEFAULT;
        }
        if (type.isArray()) {
            return SpaceDocumentSupportHelper.getDefaultDocumentSupport(type.getComponentType());
        }
        if (type.isEnum()) {
            return SpaceDocumentSupport.COPY;
        }
        return SpaceDocumentSupport.CONVERT;
    }
}

