/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.metadata.index.SpaceIndexType;

@InternalApi
public class SpaceIndexTypeHelper {
    private static final byte NOT_SET_CODE = -1;
    private static final byte NONE_CODE = 0;
    private static final byte EQAL_CODE = 1;
    private static final byte EQUAL_AND_ORDERED_CODE = 2;
    private static final byte GEOSPATIAL_CODE = 3;
    private static final byte ORDERED_CODE = 4;

    public static byte toCode(SpaceIndexType spaceIndexType) {
        if (spaceIndexType == null) {
            return -1;
        }
        switch (spaceIndexType) {
            case NONE: {
                return 0;
            }
            case BASIC: 
            case EQUAL: {
                return 1;
            }
            case EXTENDED: 
            case EQUAL_AND_ORDERED: {
                return 2;
            }
            case ORDERED: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Unsupported space index type: " + (Object)((Object)spaceIndexType));
    }

    public static SpaceIndexType fromCode(byte code) {
        switch (code) {
            case -1: {
                return null;
            }
            case 0: {
                return SpaceIndexType.NONE;
            }
            case 1: {
                return SpaceIndexType.EQUAL;
            }
            case 2: {
                return SpaceIndexType.EQUAL_AND_ORDERED;
            }
            case 4: {
                return SpaceIndexType.ORDERED;
            }
        }
        throw new IllegalArgumentException("Unsupported space index type code: " + code);
    }
}

