/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.converter.ConversionException;
import com.gigaspaces.internal.metadata.pojo.PojoPropertyInfo;
import com.gigaspaces.internal.reflection.IField;
import com.gigaspaces.internal.reflection.IGetterMethod;
import com.gigaspaces.internal.reflection.ISetterMethod;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.gigaspaces.internal.reflection.standard.StandardReflectionFactory;
import com.gigaspaces.internal.utils.ClassUtils;
import com.gigaspaces.internal.utils.ReflectionUtils;
import com.gigaspaces.metadata.SpaceDocumentSupport;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.gigaspaces.metadata.SpacePropertyDescriptor;
import com.gigaspaces.metadata.StorageType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

@InternalApi
public class SpacePropertyInfo
implements SpacePropertyDescriptor,
Comparable<SpacePropertyInfo> {
    private final String _name;
    private final Class<?> _type;
    private final boolean _primitive;
    private final Method _getterMethod;
    private final Method _setterMethod;
    private IGetterMethod<Object> _getter;
    private ISetterMethod<Object> _setter;
    private Field _field;
    private IField<Object, Object> _fieldProperty;
    private int _level;
    private Primitive _nullValue;
    private StorageType _storageType;
    private SpaceDocumentSupport _documentSupport;

    public SpacePropertyInfo(PojoPropertyInfo property) {
        this._name = property.getName();
        this._type = property.getType();
        this._primitive = ReflectionUtils.isPrimitive(this._type.getName());
        this._getterMethod = property.getGetterMethod();
        this._setterMethod = property.getSetterMethod();
        this._level = -1;
    }

    public String toString() {
        return "SpacePropertyInfo: [" + this._name + "]";
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Class<?> getType() {
        return this._type;
    }

    public boolean isPrimitive() {
        return this._primitive;
    }

    @Override
    public String getTypeName() {
        return this._type.getName();
    }

    @Override
    public String getTypeDisplayName() {
        return ClassUtils.getTypeDisplayName(this.getTypeName());
    }

    public int getLevel() {
        return this._level;
    }

    public void setLevel(int level) {
        this._level = level;
    }

    public Method getGetterMethod() {
        return this._getterMethod;
    }

    public Method getSetterMethod() {
        return this._setterMethod;
    }

    public boolean hasNullValue() {
        return this._nullValue != null;
    }

    public Object getNullValue() {
        return this._nullValue == null ? null : this._nullValue.getValue();
    }

    public void setNullValue(String nullValue) {
        this._nullValue = nullValue == null || nullValue.length() == 0 ? null : new Primitive(this._type, nullValue);
    }

    public void setField(Field field) {
        if (field != null) {
            field.setAccessible(true);
        }
        this._field = field;
    }

    @Override
    public StorageType getStorageType() {
        return this._storageType;
    }

    public void setStorageType(StorageType storageType) {
        this._storageType = storageType;
    }

    @Override
    public SpaceDocumentSupport getDocumentSupport() {
        return this._documentSupport;
    }

    public void setDocumentSupport(SpaceDocumentSupport documentSupport) {
        this._documentSupport = documentSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(Object target) {
        if (this._getter == null) {
            SpacePropertyInfo spacePropertyInfo = this;
            synchronized (spacePropertyInfo) {
                if (this._getter == null) {
                    this._getter = ReflectionUtil.createGetterMethod(this._getterMethod);
                }
            }
        }
        try {
            return this._getter.get(target);
        }
        catch (IllegalArgumentException e) {
            throw new SpaceMetadataException("Failed to get property value.", e);
        }
        catch (IllegalAccessException e) {
            throw new SpaceMetadataException("Failed to get property value.", e);
        }
        catch (InvocationTargetException e) {
            throw new SpaceMetadataException("Failed to get property value.", e);
        }
    }

    public void setValue(Object target, Object value) {
        block6: {
            try {
                if (this._setterMethod != null) {
                    this.setValueBySetter(target, value);
                    break block6;
                }
                if (this._field != null) {
                    this.setValueByField(target, value);
                    break block6;
                }
                throw new SpaceMetadataException("Missing setter and field for property [" + this.getName() + "]");
            }
            catch (IllegalArgumentException e) {
                throw new SpaceMetadataException("Failed to set property value.", e);
            }
            catch (IllegalAccessException e) {
                throw new SpaceMetadataException("Failed to set property value.", e);
            }
            catch (InvocationTargetException e) {
                throw new SpaceMetadataException("Failed to set property value.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValueByField(Object target, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (this._fieldProperty == null) {
            SpacePropertyInfo spacePropertyInfo = this;
            synchronized (spacePropertyInfo) {
                if (this._fieldProperty == null) {
                    this._fieldProperty = Modifier.isFinal(this._field.getModifiers()) ? new StandardReflectionFactory().getField(this._field) : ReflectionUtil.createField(this._field);
                }
            }
        }
        this._fieldProperty.set(target, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValueBySetter(Object target, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this._setter == null) {
            SpacePropertyInfo spacePropertyInfo = this;
            synchronized (spacePropertyInfo) {
                if (this._setter == null) {
                    this._setter = ReflectionUtil.createSetterMethod(this._setterMethod);
                }
            }
        }
        this._setter.set(target, value);
    }

    public Object convertFromNullIfNeeded(Object value) {
        return value == null && this._nullValue != null ? this._nullValue.getValue() : value;
    }

    public Object convertToNullIfNeeded(Object value) {
        return value != null && this._nullValue != null && value.equals(this._nullValue.getValue()) ? null : value;
    }

    @Override
    public int compareTo(SpacePropertyInfo other) {
        int levelCompare = other._level - this._level;
        if (levelCompare != 0) {
            return levelCompare;
        }
        return this._name.compareTo(other._name);
    }

    private static final class Primitive {
        private final Object _value;

        public Primitive(Class<?> type, String value) {
            if (value == null) {
                throw new ConversionException("value can not be null.");
            }
            if (type.equals(Boolean.TYPE)) {
                this._value = Boolean.parseBoolean(value);
            } else if (type.equals(Byte.TYPE)) {
                this._value = Byte.parseByte(value);
            } else if (type.equals(Short.TYPE)) {
                this._value = Short.parseShort(value);
            } else if (type.equals(Character.TYPE)) {
                if (value.length() != 1) {
                    throw new IllegalArgumentException(value + " contains more than 1 char.");
                }
                this._value = Character.valueOf(value.charAt(0));
            } else if (type.equals(Integer.TYPE)) {
                this._value = Integer.parseInt(value);
            } else if (type.equals(Long.TYPE)) {
                this._value = Long.parseLong(value);
            } else if (type.equals(Float.TYPE)) {
                this._value = Float.valueOf(Float.parseFloat(value));
            } else if (type.equals(Double.TYPE)) {
                this._value = Double.parseDouble(value);
            } else {
                throw new ConversionException("The null value type class must be one of the following primitive types: boolean; byte; short; char; int; long; float; or double. Previously, it was : " + type);
            }
        }

        public Object getValue() {
            return this._value;
        }
    }
}

