/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.annotation.pojo.CompoundSpaceIndex;
import com.gigaspaces.annotation.pojo.CompoundSpaceIndexes;
import com.gigaspaces.annotation.pojo.FifoSupport;
import com.gigaspaces.annotation.pojo.SpaceClass;
import com.gigaspaces.annotation.pojo.SpaceClassConstructor;
import com.gigaspaces.annotation.pojo.SpaceDynamicProperties;
import com.gigaspaces.annotation.pojo.SpaceExclude;
import com.gigaspaces.annotation.pojo.SpaceFifoGroupingIndex;
import com.gigaspaces.annotation.pojo.SpaceFifoGroupingProperty;
import com.gigaspaces.annotation.pojo.SpaceId;
import com.gigaspaces.annotation.pojo.SpaceIndex;
import com.gigaspaces.annotation.pojo.SpaceIndexes;
import com.gigaspaces.annotation.pojo.SpaceLeaseExpiration;
import com.gigaspaces.annotation.pojo.SpacePersist;
import com.gigaspaces.annotation.pojo.SpaceProperty;
import com.gigaspaces.annotation.pojo.SpaceRouting;
import com.gigaspaces.annotation.pojo.SpaceSequenceNumber;
import com.gigaspaces.annotation.pojo.SpaceStorageType;
import com.gigaspaces.annotation.pojo.SpaceVersion;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.DocumentProperties;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.io.XmlUtils;
import com.gigaspaces.internal.metadata.ConstructorInstantiationDescriptor;
import com.gigaspaces.internal.metadata.ConstructorPropertiesHelper;
import com.gigaspaces.internal.metadata.FifoHelper;
import com.gigaspaces.internal.metadata.PojoDefaults;
import com.gigaspaces.internal.metadata.SpaceDocumentSupportHelper;
import com.gigaspaces.internal.metadata.SpacePropertyInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfoRepository;
import com.gigaspaces.internal.metadata.annotations.CustomSpaceIndex;
import com.gigaspaces.internal.metadata.annotations.CustomSpaceIndexes;
import com.gigaspaces.internal.metadata.annotations.SpaceSystemClass;
import com.gigaspaces.internal.metadata.pojo.PojoPropertyInfo;
import com.gigaspaces.internal.metadata.pojo.PojoTypeInfo;
import com.gigaspaces.internal.metadata.pojo.PojoTypeInfoRepository;
import com.gigaspaces.internal.query.valuegetter.ISpaceValueGetter;
import com.gigaspaces.internal.reflection.IConstructor;
import com.gigaspaces.internal.reflection.IParamsConstructor;
import com.gigaspaces.internal.reflection.IProperties;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.gigaspaces.internal.utils.ObjectUtils;
import com.gigaspaces.internal.utils.ReflectionUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.metadata.SpaceDocumentSupport;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.gigaspaces.metadata.SpaceMetadataValidationException;
import com.gigaspaces.metadata.StorageType;
import com.gigaspaces.metadata.index.CustomIndex;
import com.gigaspaces.metadata.index.ISpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndexFactory;
import com.gigaspaces.metadata.index.SpaceIndexType;
import com.gigaspaces.metadata.index.SpacePropertyIndex;
import com.gigaspaces.server.ServerEntry;
import com.j_spaces.kernel.ClassLoaderHelper;
import com.j_spaces.map.Envelope;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@InternalApi
public class SpaceTypeInfo
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final byte OldVersionId = 2;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.metadata.pojo");
    private static final String GS_XML_SUFFIX = ".gs.xml";
    private final transient Object _lock = new Object();
    private Class<?> _type;
    private SpaceTypeInfo _superTypeInfo;
    private IConstructor<?> _constructor;
    private IParamsConstructor<?> _paramsConstructor;
    private String[] _superClasses;
    private boolean _systemClass;
    private Boolean _persist;
    private Boolean _replicate;
    private FifoSupport _fifoSupport;
    private Boolean _inheritIndexes;
    private SpaceClass.IncludeProperties _includeProperties;
    private Map<String, com.gigaspaces.metadata.index.SpaceIndex> _indexes;
    private Map<String, SpacePropertyInfo> _properties;
    private SpacePropertyInfo[] _spaceProperties;
    private SpacePropertyInfo _idProperty;
    private Boolean _idAutoGenerate;
    private SpacePropertyInfo _routingProperty;
    private SpacePropertyInfo _versionProperty;
    private SpacePropertyInfo _persistProperty;
    private SpacePropertyInfo _leaseExpirationProperty;
    private SpacePropertyInfo _dynamicPropertiesProperty;
    private String _fifoGroupingName;
    private Set<String> _fifoGroupingIndexes;
    private transient IProperties _propertiesAccessor;
    private StorageType _storageType;
    private Boolean _blobstoreEnabled;
    private ConstructorInstantiationDescriptor _constructorDescriptor;
    private String _sequenceNumberPropertyName;

    public SpaceTypeInfo() {
    }

    public SpaceTypeInfo(Class<?> type, SpaceTypeInfo superTypeInfo, Map<String, Node> xmlMap) {
        this.initialize(type, superTypeInfo);
        InitContext initContext = new InitContext();
        boolean isInitialized = this.initByGsXml(type, xmlMap, initContext);
        if (!isInitialized) {
            this.initByAnnotations(initContext);
        }
        this.applyDefaults();
        if (this.hasConstructorProperties()) {
            this.generateConstructorBasedSpaceProperties(initContext);
        } else {
            this.generateSpaceProperties(initContext, null, false);
        }
        this.initIndexes(initContext);
        this.validate();
    }

    public String getName() {
        return this._type.getName();
    }

    public Class<?> getType() {
        return this._type;
    }

    public IParamsConstructor<?> getParamsConstructor() {
        if (this._paramsConstructor != null) {
            return this._paramsConstructor;
        }
        try {
            Constructor<?> constructor = this._type.getDeclaredConstructor(this._constructorDescriptor.getConstructorParameterTypes());
            this._paramsConstructor = ReflectionUtil.createParamsCtor(constructor);
            return this._paramsConstructor;
        }
        catch (SecurityException e) {
            throw new SpaceMetadataException("Error getting constructor for type [" + this._type.getName() + "].", e);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public IConstructor<?> getDefaultConstructor() {
        if (this._constructor != null) {
            return this._constructor;
        }
        try {
            Constructor<?> constructor = this._type.getDeclaredConstructor(new Class[0]);
            this._constructor = ReflectionUtil.createCtor(constructor);
            return this._constructor;
        }
        catch (SecurityException e) {
            throw new SpaceMetadataException("Error getting default constructor for type [" + this._type.getName() + "].", e);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public SpaceTypeInfo getSuperTypeInfo() {
        return this._superTypeInfo;
    }

    public String[] getSuperClasses() {
        return this._superClasses;
    }

    public boolean hasConstructorProperties() {
        return this._constructorDescriptor != null;
    }

    public boolean isSystemClass() {
        return this._systemClass;
    }

    public boolean isPersist() {
        return this._persist;
    }

    public boolean isReplicate() {
        return this._replicate;
    }

    public FifoSupport getFifoSupport() {
        return this._fifoSupport;
    }

    public StorageType getStorageType() {
        return this._storageType;
    }

    public boolean isBlobstoreEnabled() {
        return this._blobstoreEnabled;
    }

    public int getNumOfProperties() {
        return this._properties.size();
    }

    public int getNumOfSpaceProperties() {
        return this._spaceProperties.length;
    }

    public SpacePropertyInfo[] getSpaceProperties() {
        return this._spaceProperties;
    }

    public SpacePropertyInfo getProperty(int ordinal) {
        return this._spaceProperties[ordinal];
    }

    public SpacePropertyInfo getProperty(String name) {
        return this._properties.get(name);
    }

    public String getSequenceNumberPropertyName() {
        return this._sequenceNumberPropertyName;
    }

    public int indexOf(SpacePropertyInfo property) {
        if (property == null) {
            return -1;
        }
        for (int i = 0; i < this._spaceProperties.length; ++i) {
            if (this._spaceProperties[i] != property) continue;
            return i;
        }
        return -1;
    }

    public SpacePropertyInfo getIdProperty() {
        return this._idProperty;
    }

    public boolean getIdAutoGenerate() {
        return this._idAutoGenerate;
    }

    public SpacePropertyInfo getDynamicPropertiesProperty() {
        return this._dynamicPropertiesProperty;
    }

    public String getFifoGroupingName() {
        return this._fifoGroupingName;
    }

    public Set<String> getFifoGroupingIndexes() {
        return this._fifoGroupingIndexes;
    }

    public SpacePropertyInfo getLeaseExpirationProperty() {
        return this._leaseExpirationProperty;
    }

    public SpacePropertyInfo getPersistProperty() {
        return this._persistProperty;
    }

    public SpacePropertyInfo getRoutingProperty() {
        return this._routingProperty;
    }

    public SpacePropertyInfo getVersionProperty() {
        return this._versionProperty;
    }

    public Object createInstance() {
        IConstructor<?> constructor = this.getDefaultConstructor();
        if (constructor == null) {
            throw new SpaceMetadataValidationException(this._type, "Type must have a constructor with no parameters.");
        }
        try {
            return constructor.newInstance();
        }
        catch (InvocationTargetException e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Failed to create instance of type [" + this._type.getName() + "]: " + e.getMessage(), e);
            }
            throw new SpaceMetadataException("Failed to create instance of type [" + this._type.getName() + "]: " + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Failed to create instance of type [" + this._type.getName() + "]: " + e.getMessage(), e);
            }
            throw new SpaceMetadataException("Failed to create instance of type [" + this._type.getName() + "]: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Failed to create instance of type [" + this._type.getName() + "]: " + e.getMessage(), e);
            }
            throw new SpaceMetadataException("Failed to create instance of type [" + this._type.getName() + "]: " + e.getMessage(), e);
        }
    }

    public Object createConstructorBasedInstance(Object[] spacePropertyValues, Map<String, Object> dynamicProperties, String uid, int version, long lease, boolean persistent) {
        IParamsConstructor<?> paramsConstructor = this.getParamsConstructor();
        if (paramsConstructor == null) {
            throw new SpaceMetadataValidationException(this._type, "Type must have a exactly 1 constructor with parameters.");
        }
        try {
            Object result;
            int i;
            Object[] constructorArguments = new Object[this._constructorDescriptor.getNumberOfParameters()];
            if (spacePropertyValues != null) {
                for (i = 0; i < spacePropertyValues.length; ++i) {
                    Object value;
                    int spacePropertyToConstructorIndex = this._constructorDescriptor.getSpacePropertyToConstructorIndex(i);
                    if (spacePropertyToConstructorIndex < 0) continue;
                    constructorArguments[spacePropertyToConstructorIndex] = value = this.getProperty(i).convertFromNullIfNeeded(spacePropertyValues[i]);
                }
            }
            if (this._constructorDescriptor.getDynamicPropertiesConstructorIndex() >= 0) {
                constructorArguments[this._constructorDescriptor.getDynamicPropertiesConstructorIndex()] = this.getDocumentProperties(dynamicProperties);
            }
            if (this._idAutoGenerate.booleanValue() && this._constructorDescriptor.getIdPropertyConstructorIndex() >= 0) {
                constructorArguments[this._constructorDescriptor.getIdPropertyConstructorIndex()] = uid;
            }
            if (this._constructorDescriptor.getVersionConstructorIndex() >= 0) {
                constructorArguments[this._constructorDescriptor.getVersionConstructorIndex()] = version;
            }
            if (this._constructorDescriptor.getLeaseConstructorIndex() >= 0) {
                constructorArguments[this._constructorDescriptor.getLeaseConstructorIndex()] = lease;
            }
            if (this._constructorDescriptor.getPersistConstructorIndex() >= 0) {
                constructorArguments[this._constructorDescriptor.getPersistConstructorIndex()] = persistent;
            }
            for (i = 0; i < this._constructorDescriptor.getNumberOfParameters(); ++i) {
                if (!this._constructorDescriptor.isIndexExcluded(i)) continue;
                constructorArguments[i] = ObjectUtils.getDefaultValue(this._constructorDescriptor.getConstructorParameterTypes()[i]);
            }
            try {
                result = this._paramsConstructor.newInstance(constructorArguments);
            }
            catch (NullPointerException e) {
                throw new SpaceMetadataException("Error creating a new instance with constructor for type [" + this._type.getName() + "].", e);
            }
            if (this._constructorDescriptor.getConstructorParameterNames().length < this._spaceProperties.length) {
                for (int i2 = 0; i2 < spacePropertyValues.length; ++i2) {
                    int spacePropertyToConstructorIndex = this._constructorDescriptor.getSpacePropertyToConstructorIndex(i2);
                    if (spacePropertyToConstructorIndex >= 0) continue;
                    this._spaceProperties[i2].setValue(result, spacePropertyValues[i2]);
                }
            }
            if (this._idAutoGenerate.booleanValue() && this._idProperty != null && this._constructorDescriptor.getIdPropertyConstructorIndex() < 0) {
                this._idProperty.setValue(result, uid);
            }
            if (this._versionProperty != null && this._constructorDescriptor.getVersionConstructorIndex() < 0) {
                this._versionProperty.setValue(result, version);
            }
            if (this._leaseExpirationProperty != null && this._constructorDescriptor.getLeaseConstructorIndex() < 0) {
                this._leaseExpirationProperty.setValue(result, lease);
            }
            if (this._persistProperty != null && this._constructorDescriptor.getPersistConstructorIndex() < 0) {
                this._persistProperty.setValue(result, persistent);
            }
            if (this._dynamicPropertiesProperty != null && this._constructorDescriptor.getDynamicPropertiesConstructorIndex() < 0) {
                this._dynamicPropertiesProperty.setValue(result, this.getDocumentProperties(dynamicProperties));
            }
            return result;
        }
        catch (InvocationTargetException e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Failed to create instance of type [" + this._type.getName() + "]: " + e.getMessage(), e);
            }
            throw new SpaceMetadataException("Failed to create instance of type [" + this._type.getName() + "]: " + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Failed to create instance of type [" + this._type.getName() + "]: " + e.getMessage(), e);
            }
            throw new SpaceMetadataException("Failed to create instance of type [" + this._type.getName() + "]: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Failed to create instance of type [" + this._type.getName() + "]: " + e.getMessage(), e);
            }
            throw new SpaceMetadataException("Failed to create instance of type [" + this._type.getName() + "]: " + e.getMessage(), e);
        }
    }

    private DocumentProperties getDocumentProperties(Map<String, Object> dynamicProperties) {
        if (dynamicProperties == null) {
            return null;
        }
        if (dynamicProperties instanceof DocumentProperties) {
            return (DocumentProperties)dynamicProperties;
        }
        DocumentProperties result = new DocumentProperties();
        result.putAll((Map<? extends String, ? extends Object>)dynamicProperties);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProperties getSpacePropertiesAccessor() {
        if (this._propertiesAccessor == null) {
            Object object = this._lock;
            synchronized (object) {
                if (this._propertiesAccessor == null) {
                    this._propertiesAccessor = ReflectionUtil.createProperties(this);
                }
            }
        }
        return this._propertiesAccessor;
    }

    public Object[] getSpacePropertiesValues(Object object, boolean useNullValues) {
        Object[] values;
        try {
            values = this.getSpacePropertiesAccessor().getValues(object);
        }
        catch (IllegalArgumentException e) {
            throw new SpaceMetadataException("Failed to get values from object of type '" + object.getClass().getName() + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new SpaceMetadataException("Failed to get values from object of type '" + object.getClass().getName() + "'.", e);
        }
        catch (InvocationTargetException e) {
            throw new SpaceMetadataException("Failed to get values from object of type '" + object.getClass().getName() + "'.", e);
        }
        if (useNullValues) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = this._spaceProperties[i].convertToNullIfNeeded(values[i]);
            }
        }
        return values;
    }

    public void setSpacePropertiesValues(Object object, Object[] values) {
        try {
            this.getSpacePropertiesAccessor().setValues(object, values);
        }
        catch (IllegalArgumentException e) {
            throw new SpaceMetadataException("Failed to set values in object of type '" + object.getClass().getName() + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new SpaceMetadataException("Failed to set values in object of type '" + object.getClass().getName() + "'.", e);
        }
        catch (InvocationTargetException e) {
            throw new SpaceMetadataException("Failed to set values in object of type '" + object.getClass().getName() + "'.", e);
        }
    }

    private void initialize(Class<?> type, SpaceTypeInfo superTypeInfo) {
        this._type = type;
        this._superTypeInfo = superTypeInfo;
        this._properties = SpaceTypeInfo.generateProperties(type);
        this._superClasses = SpaceTypeInfo.generateSuperClasses(type, superTypeInfo);
        this._indexes = new HashMap<String, com.gigaspaces.metadata.index.SpaceIndex>();
        this._fifoGroupingIndexes = new HashSet<String>();
    }

    private static Map<String, SpacePropertyInfo> generateProperties(Class<?> type) {
        HashMap<String, SpacePropertyInfo> properties = new HashMap<String, SpacePropertyInfo>();
        PojoTypeInfo pojoTypeInfo = PojoTypeInfoRepository.getPojoTypeInfo(type);
        for (Map.Entry<String, PojoPropertyInfo> entry : pojoTypeInfo.getProperties().entrySet()) {
            if (entry.getValue().getType() == null) continue;
            properties.put(entry.getKey(), new SpacePropertyInfo(entry.getValue()));
        }
        return properties;
    }

    private static String[] generateSuperClasses(Class<?> type, SpaceTypeInfo superTypeInfo) {
        if (superTypeInfo == null) {
            return new String[]{Object.class.getName(), Object.class.getName()};
        }
        if (superTypeInfo.getSuperTypeInfo() == null) {
            return new String[]{type.getName(), superTypeInfo.getName()};
        }
        String[] superSuperClasses = superTypeInfo.getSuperClasses();
        String[] superClasses = new String[superSuperClasses.length + 1];
        superClasses[0] = type.getName();
        for (int i = 1; i < superClasses.length; ++i) {
            superClasses[i] = superSuperClasses[i - 1];
        }
        return superClasses;
    }

    private void applyDefaults() {
        if (this._persist == null) {
            this._persist = true;
        }
        if (this._replicate == null) {
            this._replicate = true;
        }
        if (this._blobstoreEnabled == null) {
            this._blobstoreEnabled = true;
        }
        if (this._fifoSupport == null || this._fifoSupport == FifoSupport.NOT_SET || this._fifoSupport == FifoSupport.DEFAULT) {
            FifoSupport fifoSupport = this._fifoSupport = this._superTypeInfo != null ? this._superTypeInfo.getFifoSupport() : PojoDefaults.FIFO_SUPPORT;
        }
        if (this._inheritIndexes == null) {
            this._inheritIndexes = true;
        }
        if (this._includeProperties == null) {
            this._includeProperties = PojoDefaults.INCLUDE_PROPERTIES;
        }
        if (this._superTypeInfo != null) {
            this._idProperty = this.updatePropertyBySuper(this._idProperty, this._superTypeInfo._idProperty);
            this._leaseExpirationProperty = this.updatePropertyBySuper(this._leaseExpirationProperty, this._superTypeInfo._leaseExpirationProperty);
            this._persistProperty = this.updatePropertyBySuper(this._persistProperty, this._superTypeInfo._persistProperty);
            this._routingProperty = this.updatePropertyBySuper(this._routingProperty, this._superTypeInfo._routingProperty);
            this._versionProperty = this.updatePropertyBySuper(this._versionProperty, this._superTypeInfo._versionProperty);
            this._dynamicPropertiesProperty = this.updatePropertyBySuper(this._dynamicPropertiesProperty, this._superTypeInfo._dynamicPropertiesProperty);
            if (this._fifoGroupingName == null) {
                this._fifoGroupingName = this._superTypeInfo.getFifoGroupingName();
            } else if (this._superTypeInfo._fifoGroupingName != null) {
                throw new SpaceMetadataValidationException(this._type, "Cannot declare a fifo grouping [" + this._fifoGroupingName + "] if one has already been defined in the super class [" + this._superTypeInfo._fifoGroupingName + "].");
            }
            if (this._sequenceNumberPropertyName == null) {
                this._sequenceNumberPropertyName = this._superTypeInfo.getSequenceNumberPropertyName();
            } else if (this._superTypeInfo._sequenceNumberPropertyName != null) {
                throw new SpaceMetadataValidationException(this._type, "Cannot declare a sequence-number [" + this._sequenceNumberPropertyName + "] if one has already been defined in the super class [" + this._superTypeInfo._sequenceNumberPropertyName + "].");
            }
            for (String superFifoGroupingIndex : this._superTypeInfo._fifoGroupingIndexes) {
                this._fifoGroupingIndexes.add(superFifoGroupingIndex);
            }
            StorageType superStorageType = this._superTypeInfo.getStorageType();
            if (this._storageType == null || this._storageType == StorageType.DEFAULT) {
                this._storageType = superStorageType;
            } else if (superStorageType != null && superStorageType != StorageType.DEFAULT) {
                throw new SpaceMetadataValidationException(this._type, "Cannot declare a storage type [" + (Object)((Object)this._storageType) + "] if one has already been defined in the super class [" + (Object)((Object)superStorageType) + "].");
            }
            if (this._idAutoGenerate == null) {
                this._idAutoGenerate = this._superTypeInfo._idAutoGenerate;
            }
        }
        if (this._storageType == null) {
            this._storageType = PojoDefaults.STORAGE_TYPE;
        }
        if (this._idAutoGenerate == null) {
            this._idAutoGenerate = false;
        }
    }

    private SpacePropertyInfo updatePropertyBySuper(SpacePropertyInfo currProperty, SpacePropertyInfo superProperty) {
        return currProperty != null || superProperty == null ? currProperty : this._properties.get(superProperty.getName());
    }

    private boolean initByGsXml(Class<?> type, Map<String, Node> xmlMap, InitContext initContext) {
        Node classNode = this.findClassNode(type, xmlMap);
        if (classNode == null) {
            return false;
        }
        this._persist = XmlUtils.getAttributeBoolean(classNode, "persist");
        this._replicate = XmlUtils.getAttributeBoolean(classNode, "replicate");
        this._blobstoreEnabled = XmlUtils.getAttributeBoolean(classNode, "blobstore-enabled");
        this._fifoSupport = XmlUtils.getAttributeEnum(classNode, "fifo-support", FifoSupport.class);
        this._inheritIndexes = XmlUtils.getAttributeBoolean(classNode, "inherit-indexes");
        this._includeProperties = XmlUtils.getAttributeEnum(classNode, "include-properties", SpaceClass.IncludeProperties.class);
        this._storageType = XmlUtils.getAttributeEnum(classNode, "storage-type", StorageType.class, StorageType.DEFAULT, true);
        Boolean fifo = XmlUtils.getAttributeBoolean(classNode, "fifo");
        if (fifo != null) {
            if (this._fifoSupport != null) {
                throw new SpaceMetadataValidationException(type, "Defining 'fifo' on a class is no longer supported - use 'fifoSupport' instead.");
            }
            this._fifoSupport = fifo != false ? FifoSupport.ALL : FifoSupport.OFF;
        }
        ArrayList<Node> compounds = null;
        NodeList nodeList = classNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node propertyNode = nodeList.item(i);
            String nodeName = propertyNode.getNodeName();
            if (nodeName.equals("property")) {
                SpacePropertyInfo property = this.getProperty(propertyNode);
                SpaceIndexType indexType = XmlUtils.getAttributeEnum(propertyNode, "index", SpaceIndexType.class);
                boolean unique = XmlUtils.getAttributeBoolean(propertyNode, "unique", false);
                if (indexType != null && indexType != SpaceIndexType.NONE) {
                    initContext.addIndex(property.getName(), indexType, unique);
                }
                property.setNullValue(XmlUtils.getAttribute(propertyNode, "null-value"));
                property.setStorageType(XmlUtils.getAttributeEnum(propertyNode, "storage-type", StorageType.class, StorageType.DEFAULT, true));
                property.setDocumentSupport(XmlUtils.getAttributeEnum(propertyNode, "document-support", SpaceDocumentSupport.class, SpaceDocumentSupport.DEFAULT));
                NodeList propertyNodeList = propertyNode.getChildNodes();
                for (int j = 0; j < propertyNodeList.getLength(); ++j) {
                    Node propertyChildNode = propertyNodeList.item(j);
                    String propertyChildNodeName = propertyChildNode.getNodeName();
                    if (propertyChildNodeName.equals("index")) {
                        this.addPropertyIndex(property.getName(), propertyChildNode, initContext);
                        continue;
                    }
                    if (!propertyChildNodeName.equals("fifo-grouping-index")) continue;
                    this.updateFifoGroupingIndexes(property, propertyChildNode, initContext);
                }
                initContext.explicitlyIncluded.add(property);
                continue;
            }
            if (nodeName.equals("id")) {
                this._idProperty = this.updateProperty(this._idProperty, propertyNode);
                this._idAutoGenerate = XmlUtils.getAttributeBoolean(propertyNode, "auto-generate");
                continue;
            }
            if (nodeName.equals("routing")) {
                this._routingProperty = this.updateProperty(this._routingProperty, propertyNode);
                continue;
            }
            if (nodeName.equals("version")) {
                this._versionProperty = this.updateProperty(this._versionProperty, propertyNode);
                continue;
            }
            if (nodeName.equals("persist")) {
                this._persistProperty = this.updateProperty(this._persistProperty, propertyNode);
                continue;
            }
            if (nodeName.equals("lease-expiration")) {
                this._leaseExpirationProperty = this.updateProperty(this._leaseExpirationProperty, propertyNode);
                continue;
            }
            if (nodeName.equals("dynamic-properties")) {
                this._dynamicPropertiesProperty = this.updateProperty(this._dynamicPropertiesProperty, propertyNode);
                continue;
            }
            if (nodeName.equals("fifo-grouping-property")) {
                this.updateFifoGroupingName(propertyNode, initContext);
                continue;
            }
            if (nodeName.equals("sequence-number")) {
                this.updateSequenceNumberName(propertyNode, initContext);
                continue;
            }
            if (nodeName.equals("exclude")) {
                initContext.explicitlyExcluded.add(this.getProperty(propertyNode));
                continue;
            }
            if (nodeName.equals("reference")) {
                String actualSuperClass = this._superClasses[1];
                String superClass = XmlUtils.getAttribute(propertyNode, "class-ref");
                if (!actualSuperClass.equals(superClass)) {
                    if (!_logger.isLoggable(Level.WARNING)) continue;
                    _logger.log(Level.WARNING, "Metadata for type [" + this._type.getName() + "] defines class-ref [" + superClass + "] but actual super class is [" + actualSuperClass + "]. The actual super class will be used. To avoid this message please remove the class-ref definition (it is not required).");
                    continue;
                }
                if (!_logger.isLoggable(Level.INFO)) continue;
                _logger.log(Level.INFO, "Specifying class reference in gs.xml is no longer required (see type " + this._type.getName() + ").");
                continue;
            }
            if (nodeName.equals("compound-index")) {
                if (compounds == null) {
                    compounds = new ArrayList<Node>();
                }
                compounds.add(propertyNode);
                continue;
            }
            if (!_logger.isLoggable(Level.WARNING)) continue;
            _logger.log(Level.WARNING, "Unrecognized xml node: " + nodeName);
        }
        if (compounds != null && !compounds.isEmpty()) {
            for (Node c : compounds) {
                String paths = XmlUtils.getAttribute(c, "paths", null);
                if (paths == null || paths.equals("")) {
                    _logger.log(Level.SEVERE, "missing paths in xml definition of compound index class " + this._type.getName());
                    throw new IllegalArgumentException("missing paths in xml definition of compound index class " + this._type.getName());
                }
                String delim = paths.indexOf(",") != -1 ? "," : " ";
                StringTokenizer st = new StringTokenizer(paths, delim);
                int pnum = st.countTokens();
                if (pnum < 2) {
                    _logger.log(Level.SEVERE, "invalid paths in xml definition of compound index class " + this._type.getName() + " paths=" + paths);
                    throw new IllegalArgumentException("invalid paths in xml definition of compound index class " + this._type.getName() + " paths=" + paths);
                }
                String[] ps = new String[pnum];
                for (int i = 0; i < pnum; ++i) {
                    ps[i] = st.nextToken().trim();
                }
                SpaceProperty.IndexType indexType = XmlUtils.getAttributeEnum(c, "type", SpaceProperty.IndexType.class, SpaceProperty.IndexType.BASIC, true);
                boolean unique = XmlUtils.getAttributeBoolean(c, "unique", false);
                try {
                    this.addCompoundIndex(ps, indexType.toSpaceIndexType(), unique);
                }
                catch (Exception ex) {
                    _logger.log(Level.SEVERE, "creating a compound index from GSXML failed class " + this._type.getName() + " exception=" + ex);
                    throw new RuntimeException("creating a compound index from GSXML failed class " + this._type.getName() + " exception=" + ex);
                }
            }
        }
        return true;
    }

    private void addPropertyIndex(String name, SpaceIndex annotation, InitContext initContext) {
        if (annotation == null) {
            return;
        }
        this.addPropertyIndex(name, annotation.path(), annotation.type(), "@" + annotation.annotationType().getSimpleName(), annotation.unique(), initContext);
    }

    private void addPropertyIndex(String name, Node xmlNode, InitContext initContext) {
        if (xmlNode == null) {
            return;
        }
        String path = XmlUtils.getAttribute(xmlNode, "path");
        SpaceIndexType indexType = XmlUtils.getAttributeEnum(xmlNode, "type", SpaceIndexType.class, SpaceIndexType.EQUAL);
        boolean unique = XmlUtils.getAttributeBoolean(xmlNode, "unique", false);
        this.addPropertyIndex(name, path, indexType, "<index>", unique, initContext);
    }

    private void addPropertyIndex(String name, String path, SpaceIndexType indexType, String configName, boolean unique, InitContext initContext) {
        if (path == null || path.length() == 0) {
            initContext.addIndex(name, indexType, unique);
        } else {
            path = path.startsWith("[*]") ? name + path : name + "." + path;
            com.gigaspaces.metadata.index.SpaceIndex index = SpaceIndexFactory.createPathIndex(path, indexType, unique);
            this.addIndex(index, configName);
        }
    }

    private Node findClassNode(Class<?> type, Map<String, Node> xmlMap) {
        Node classNode;
        String typeName = type.getName();
        if (xmlMap != null && (classNode = xmlMap.get(typeName)) != null) {
            return classNode;
        }
        String fileName = "/" + typeName.replace('.', '/') + GS_XML_SUFFIX;
        Node classNode2 = SpaceTypeInfoRepository.loadFile(fileName, typeName);
        if (classNode2 != null) {
            return classNode2;
        }
        return null;
    }

    private SpacePropertyInfo getProperty(Node xmlNode) {
        String name = XmlUtils.getAttribute(xmlNode, "name");
        if (name == null || name.length() == 0) {
            throw new SpaceMetadataValidationException(this._type, "Property name was not set for xml node " + xmlNode.getNodeName());
        }
        SpacePropertyInfo property = this._properties.get(name);
        if (property == null) {
            throw new SpaceMetadataValidationException(this._type, "Type does not contain property [" + name + "] specified in xml node [" + xmlNode.getNodeName() + "].");
        }
        return property;
    }

    private SpacePropertyInfo updateProperty(SpacePropertyInfo currProperty, Node propertyNode) {
        SpacePropertyInfo newProperty = this.getProperty(propertyNode);
        if (currProperty != null) {
            throw new SpaceMetadataValidationException(this._type, "xml node [" + propertyNode.getNodeName() + "] is declared on both [" + currProperty.getName() + "] and [" + newProperty.getName() + "].");
        }
        return newProperty;
    }

    private void updateFifoGroupingName(Node propertyNode, InitContext initContext) {
        SpacePropertyInfo newProperty = this.getProperty(propertyNode);
        String path = XmlUtils.getAttribute(propertyNode, "path");
        this.validateNoCollectionPath(path);
        String fifoGroupingName = this.constructFifoGroupingName(newProperty.getName(), path);
        if (this._fifoGroupingName != null) {
            throw new SpaceMetadataValidationException(this._type, "xml node [" + propertyNode.getNodeName() + "] is declared on both [" + this._fifoGroupingName + "] and [" + fifoGroupingName + "].");
        }
        this._fifoGroupingName = fifoGroupingName;
        initContext.explicitlyIncluded.add(newProperty);
    }

    private void updateSequenceNumberName(Node propertyNode, InitContext initContext) {
        SpacePropertyInfo newProperty = this.getProperty(propertyNode);
        String sequenceNumberPropertyName = XmlUtils.getAttribute(propertyNode, "name");
        if (this._sequenceNumberPropertyName != null) {
            throw new SpaceMetadataValidationException(this._type, "xml node [" + propertyNode.getNodeName() + "] is declared on both [" + this._sequenceNumberPropertyName + "] and [" + sequenceNumberPropertyName + "].");
        }
        this._sequenceNumberPropertyName = sequenceNumberPropertyName;
        initContext.explicitlyIncluded.add(newProperty);
    }

    private void updateFifoGroupingIndexes(SpacePropertyInfo property, Node propertyNode, InitContext initContext) {
        String path = XmlUtils.getAttribute(propertyNode, "path");
        this.validateNoCollectionPath(path);
        this._fifoGroupingIndexes.add(this.constructFifoGroupingName(property.getName(), path));
        initContext.explicitlyIncluded.add(property);
    }

    private String constructFifoGroupingName(String fifoGroupingPropertyName, String fifoGroupingPropertyPath) {
        String fifoGroupingName = fifoGroupingPropertyName;
        if (fifoGroupingPropertyPath != null && fifoGroupingPropertyPath.length() != 0) {
            fifoGroupingName = fifoGroupingName + "." + fifoGroupingPropertyPath;
        }
        return fifoGroupingName;
    }

    /*
     * WARNING - void declaration
     */
    private void initByAnnotations(InitContext initContext) {
        CompoundSpaceIndexes compoundSpaceIndexes;
        Object customIndexAnnotations;
        CustomSpaceIndexes customIndexesAnnotation;
        SpaceSystemClass systemClassAnnotation;
        SpaceClass classAnnotation = this._type.getAnnotation(SpaceClass.class);
        if (classAnnotation != null) {
            this._persist = classAnnotation.persist();
            this._replicate = classAnnotation.replicate();
            this._fifoSupport = classAnnotation.fifoSupport();
            this._inheritIndexes = classAnnotation.inheritIndexes();
            this._includeProperties = classAnnotation.includeProperties();
            this._storageType = classAnnotation.storageType();
            this._blobstoreEnabled = classAnnotation.blobstoreEnabled();
        }
        if ((systemClassAnnotation = this._type.getAnnotation(SpaceSystemClass.class)) != null) {
            this._systemClass = true;
        }
        if ((customIndexesAnnotation = this._type.getAnnotation(CustomSpaceIndexes.class)) != null && (customIndexAnnotations = customIndexesAnnotation.value()) != null) {
            void var6_7;
            boolean bl = false;
            while (var6_7 < ((CustomSpaceIndex[])customIndexAnnotations).length) {
                this.addCustomIndex((CustomSpaceIndex)customIndexAnnotations[var6_7]);
                ++var6_7;
            }
        }
        this.addCustomIndex(this._type.getAnnotation(CustomSpaceIndex.class));
        for (Map.Entry entry : this._properties.entrySet()) {
            SpaceSequenceNumber sequenceNumberAnnotation;
            SpaceIndex[] indexAnnotations;
            SpaceFifoGroupingIndex fifoGroupingIndexAnnotation;
            SpaceFifoGroupingProperty fifoGroupingPropertyAnnotation;
            SpaceId idAnnotation;
            SpacePropertyInfo property = (SpacePropertyInfo)entry.getValue();
            Method getter = property.getGetterMethod();
            if (getter == null || getter.getDeclaringClass() != this._type) continue;
            SpaceProperty propertyAnnotation = getter.getAnnotation(SpaceProperty.class);
            if (propertyAnnotation != null) {
                initContext.explicitlyIncluded.add(property);
                property.setNullValue(propertyAnnotation.nullValue());
                property.setDocumentSupport(propertyAnnotation.documentSupport());
                SpaceProperty.IndexType indexType = propertyAnnotation.index();
                if (indexType != null && indexType != SpaceProperty.IndexType.NOT_SET) {
                    initContext.addIndex(property.getName(), indexType.toSpaceIndexType());
                }
            } else {
                property.setDocumentSupport(SpaceDocumentSupport.DEFAULT);
            }
            SpaceStorageType storageTypeAnnotation = getter.getAnnotation(SpaceStorageType.class);
            if (storageTypeAnnotation != null) {
                property.setStorageType(storageTypeAnnotation.storageType());
                initContext.explicitlyIncluded.add(property);
            }
            if ((idAnnotation = getter.getAnnotation(SpaceId.class)) != null) {
                this._idProperty = this.updateProperty(this._idProperty, property, idAnnotation);
                this._idAutoGenerate = idAnnotation.autoGenerate();
            }
            this._routingProperty = this.updateProperty(this._routingProperty, property, SpaceRouting.class);
            this._versionProperty = this.updateProperty(this._versionProperty, property, SpaceVersion.class);
            this._persistProperty = this.updateProperty(this._persistProperty, property, SpacePersist.class);
            this._leaseExpirationProperty = this.updateProperty(this._leaseExpirationProperty, property, SpaceLeaseExpiration.class);
            this._dynamicPropertiesProperty = this.updateProperty(this._dynamicPropertiesProperty, property, SpaceDynamicProperties.class);
            if (getter.getAnnotation(SpaceExclude.class) != null) {
                initContext.explicitlyExcluded.add(property);
            }
            if ((fifoGroupingPropertyAnnotation = getter.getAnnotation(SpaceFifoGroupingProperty.class)) != null) {
                this.updateFifoGroupingName(property, fifoGroupingPropertyAnnotation);
                initContext.explicitlyIncluded.add(property);
            }
            if ((fifoGroupingIndexAnnotation = getter.getAnnotation(SpaceFifoGroupingIndex.class)) != null) {
                this.updateFifoGroupingIndexes(property, fifoGroupingIndexAnnotation);
                initContext.explicitlyIncluded.add(property);
            }
            this.addPropertyIndex(property.getName(), getter.getAnnotation(SpaceIndex.class), initContext);
            SpaceIndexes indexesAnnotation = getter.getAnnotation(SpaceIndexes.class);
            if (indexesAnnotation != null && (indexAnnotations = indexesAnnotation.value()) != null) {
                for (int i = 0; i < indexAnnotations.length; ++i) {
                    this.addPropertyIndex(property.getName(), indexAnnotations[i], initContext);
                }
            }
            if ((sequenceNumberAnnotation = getter.getAnnotation(SpaceSequenceNumber.class)) == null) continue;
            this.updateSequenceNumberName(property, sequenceNumberAnnotation);
            initContext.explicitlyIncluded.add(property);
        }
        CompoundSpaceIndex csi = this._type.getAnnotation(CompoundSpaceIndex.class);
        if (csi != null) {
            this.addCompoundIndex(csi);
        }
        if ((compoundSpaceIndexes = this._type.getAnnotation(CompoundSpaceIndexes.class)) != null) {
            CompoundSpaceIndex[] cs = compoundSpaceIndexes.value();
            for (CompoundSpaceIndex c : cs) {
                if (c == null) {
                    throw new IllegalArgumentException("CompoundSpaceIndexes member cannot be null");
                }
                this.addCompoundIndex(c);
            }
        }
        Constructor<?> spaceClassConstructor = null;
        for (Constructor<?> constructor : this._type.getConstructors()) {
            if (constructor.getAnnotation(SpaceClassConstructor.class) == null) continue;
            if (this._includeProperties == SpaceClass.IncludeProperties.EXPLICIT) {
                throw new SpaceMetadataValidationException(this._type, "Cannot set explicit include properties together with space class constructor");
            }
            if (spaceClassConstructor != null) {
                throw new SpaceMetadataValidationException(this._type, "Cannot define more then one space class constructor annotation");
            }
            spaceClassConstructor = constructor;
        }
        if (spaceClassConstructor != null) {
            this._constructorDescriptor = new ConstructorInstantiationDescriptor();
            this._constructorDescriptor.setConstructor(spaceClassConstructor);
        }
    }

    private void addIndex(com.gigaspaces.metadata.index.SpaceIndex index, String configName) {
        if (this._indexes.containsKey(index.getName())) {
            throw new SpaceMetadataValidationException(this._type, configName + ": duplicate index definition. Index with the name [" + index.getName() + "] is already defined.");
        }
        this._indexes.put(index.getName(), index);
    }

    private void addCustomIndex(CustomSpaceIndex indexAnnotation) {
        ISpaceValueGetter<ServerEntry> indexGetter;
        if (indexAnnotation == null) {
            return;
        }
        String annotationName = "@" + indexAnnotation.annotationType().getSimpleName();
        Class<? extends ISpaceValueGetter<ServerEntry>> indexValueGetterClass = indexAnnotation.indexValueGetter();
        if (!ISpaceValueGetter.class.isAssignableFrom(indexValueGetterClass)) {
            throw new SpaceMetadataValidationException(this._type, annotationName + "(indexValueGetter) value must be a java class that implements [" + ISpaceValueGetter.class.getName() + "<IServerEntry>].");
        }
        try {
            indexGetter = indexValueGetterClass.newInstance();
        }
        catch (Exception e) {
            throw new SpaceMetadataValidationException(this._type, "Failed to instantiate " + annotationName + "(indexValueGetter) class [" + indexValueGetterClass.getName() + "].", e);
        }
        CustomIndex index = new CustomIndex(indexAnnotation.name(), indexGetter, indexAnnotation.unique(), indexAnnotation.type());
        this.addIndex(index, annotationName);
    }

    private void addCompoundIndex(CompoundSpaceIndex csi) {
        this.addCompoundIndex(csi.paths(), SpaceIndexType.EQUAL, csi.unique());
    }

    private void addCompoundIndex(String[] paths, SpaceIndexType type, boolean unique) {
        com.gigaspaces.metadata.index.SpaceIndex index = SpaceIndexFactory.createCompoundIndex(paths, type, null, unique);
        this.addIndex(index, index.getName());
    }

    private SpacePropertyInfo updateProperty(SpacePropertyInfo currProperty, SpacePropertyInfo newProperty, Class<? extends Annotation> annotation) {
        return this.updateProperty(currProperty, newProperty, newProperty.getGetterMethod().getAnnotation(annotation));
    }

    private void updateSequenceNumberName(SpacePropertyInfo property, SpaceSequenceNumber sequenceNumberAnnotation) {
        if (this._sequenceNumberPropertyName != null) {
            throw new SpaceMetadataValidationException(this._type, property, "@" + sequenceNumberAnnotation.annotationType().getSimpleName() + " is already defined on [" + this._sequenceNumberPropertyName + "].");
        }
        this._sequenceNumberPropertyName = property.getName();
    }

    private void updateFifoGroupingName(SpacePropertyInfo property, SpaceFifoGroupingProperty fifoGroupingAnnotation) {
        if (this._fifoGroupingName != null) {
            throw new SpaceMetadataValidationException(this._type, property, "@" + fifoGroupingAnnotation.annotationType().getSimpleName() + " is already defined on [" + this._fifoGroupingName + "].");
        }
        String path = fifoGroupingAnnotation.path();
        this.validateNoCollectionPath(path);
        this._fifoGroupingName = this.constructFifoGroupingName(property.getName(), path);
    }

    private void updateFifoGroupingIndexes(SpacePropertyInfo property, SpaceFifoGroupingIndex fifoGroupingIndexAnnotation) {
        String path = fifoGroupingIndexAnnotation.path();
        this.validateNoCollectionPath(path);
        this._fifoGroupingIndexes.add(this.constructFifoGroupingName(property.getName(), path));
    }

    private void validateNoCollectionPath(String path) {
        if (path != null && path.length() != 0 && path.indexOf("[*]") != -1) {
            throw new SpaceMetadataValidationException(this._type, "[" + path + "] collection index cannot be fifo groups index");
        }
    }

    private SpacePropertyInfo updateProperty(SpacePropertyInfo currProperty, SpacePropertyInfo newProperty, Annotation annotation) {
        if (annotation == null) {
            return currProperty;
        }
        if (currProperty != null) {
            throw new SpaceMetadataValidationException(this._type, newProperty, "@" + annotation.annotationType().getSimpleName() + " is already defined on property [" + currProperty.getName() + "].");
        }
        return newProperty;
    }

    private void generateSpaceProperties(InitContext initContext, List<SpacePropertyInfo> spacePropertiesList, boolean afterGenerateConstructorProperties) {
        List<SpacePropertyInfo> list = spacePropertiesList == null ? new ArrayList<SpacePropertyInfo>(this._properties.size()) : spacePropertiesList;
        for (Map.Entry<String, SpacePropertyInfo> entry : this._properties.entrySet()) {
            SpacePropertyInfo property = entry.getValue();
            this.processSpaceProperty(initContext, list, property, afterGenerateConstructorProperties);
        }
        Collections.sort(list);
        if (this._type == Envelope.class) {
            list.add(list.remove(0));
        }
        this._spaceProperties = list.toArray(new SpacePropertyInfo[list.size()]);
    }

    private void generateConstructorBasedSpaceProperties(InitContext initContext) {
        Constructor<?> constructor = this._constructorDescriptor.getConstructor();
        String[] parameterNames = ConstructorPropertiesHelper.extractParameterNames(constructor);
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        ArrayList<SpacePropertyInfo> list = new ArrayList<SpacePropertyInfo>(parameterNames.length);
        boolean idPropertyInParameterNames = false;
        for (int i = 0; i < parameterNames.length; ++i) {
            String parameterName = parameterNames[i];
            Class<?> parameterType = parameterTypes[i];
            SpacePropertyInfo propertyInfo = this._properties.get(parameterName);
            if (propertyInfo == null || propertyInfo.getType() != parameterType) {
                if (ConstructorPropertiesHelper.possiblyGenericConstructorParameterName(parameterName)) {
                    throw new SpaceMetadataValidationException(this._type, "Invalid constructor parameter: " + parameterName + ". It is possible that the class file does not contain  the necessary debug information required to extract the constructor parameter names.");
                }
                throw new SpaceMetadataValidationException(this._type, "Invalid constructor parameter: " + parameterName + ". Are you missing a getter for this property? (If you want to exclude this property, add getter for it with @SpaceExclude)");
            }
            this.processSpaceProperty(initContext, list, propertyInfo, false);
            if (propertyInfo != this._idProperty) continue;
            idPropertyInParameterNames = true;
        }
        if (this._idAutoGenerate.booleanValue() && !idPropertyInParameterNames) {
            this.processSpaceProperty(initContext, list, this._idProperty, false);
        }
        this.generateSpaceProperties(initContext, list, true);
        this._constructorDescriptor = ConstructorPropertiesHelper.buildConstructorInstantiationDescriptor(constructor, parameterNames, parameterTypes, this);
        this.extractFieldsForProperties();
    }

    private void extractFieldsForProperties() {
        LinkedList<SpacePropertyInfo> extractedProperties = new LinkedList<SpacePropertyInfo>();
        extractedProperties.addAll(Arrays.asList(this._spaceProperties));
        if (this._leaseExpirationProperty != null) {
            extractedProperties.add(this._leaseExpirationProperty);
        }
        if (this._persistProperty != null) {
            extractedProperties.add(this._persistProperty);
        }
        if (this._dynamicPropertiesProperty != null) {
            extractedProperties.add(this._dynamicPropertiesProperty);
        }
        for (SpacePropertyInfo property : extractedProperties) {
            if (property == this._idProperty || property.getSetterMethod() != null) continue;
            try {
                Field field = ReflectionUtils.getDeclaredField(this._type, property.getName());
                if (field == null) {
                    throw new SpaceMetadataValidationException(this._type, property, "Failed finding matching field for setter-less property.");
                }
                if (field.getType() != property.getType()) {
                    throw new SpaceMetadataValidationException(this._type, property, "Matching field for setter-less property is of different type then getter.");
                }
                property.setField(field);
            }
            catch (SecurityException e) {
                throw new SpaceMetadataValidationException(this._type, property, "Failed extracting matching field for setter-less property.", e);
            }
        }
    }

    private void processSpaceProperty(InitContext initContext, List<SpacePropertyInfo> spaceProperties, SpacePropertyInfo property, boolean afterGenerateConstructorProperties) {
        SpacePropertyInfo superProperty;
        int superLevel = -1;
        if (this._superTypeInfo != null && (superProperty = this._superTypeInfo.getProperty(property.getName())) != null) {
            superLevel = superProperty.getLevel();
            if (!property.hasNullValue() && superProperty.hasNullValue()) {
                property.setNullValue(superProperty.getNullValue().toString());
            }
            if (property.getStorageType() == null || property.getStorageType() == StorageType.DEFAULT) {
                property.setStorageType(superProperty.getStorageType());
            } else if (superProperty.getStorageType() != null && superProperty.getStorageType() != property.getStorageType()) {
                throw new SpaceMetadataValidationException(this._type, property, "Cannot declare storage type different from the storage type declared in the super class.");
            }
            if (property.getDocumentSupport() == null || property.getDocumentSupport() == SpaceDocumentSupport.DEFAULT) {
                property.setDocumentSupport(superProperty.getDocumentSupport());
            }
        }
        if (this.isSpaceProperty(property, superLevel, initContext)) {
            property.setLevel(superLevel + 1);
            this.applySpacePropertyAnnotationDefaults(property);
            if (!afterGenerateConstructorProperties || !this.isSetByConstructor(property)) {
                spaceProperties.add(property);
            }
        } else if (superLevel >= 0) {
            throw new SpaceMetadataValidationException(this._type, property, "Cannot exclude a property which is a space property in a super class.");
        }
    }

    private void applySpacePropertyAnnotationDefaults(SpacePropertyInfo property) {
        if (property.getStorageType() == null) {
            property.setStorageType(StorageType.DEFAULT);
        }
        if (property.getDocumentSupport() == null || property.getDocumentSupport() == SpaceDocumentSupport.DEFAULT) {
            property.setDocumentSupport(SpaceDocumentSupportHelper.getDefaultDocumentSupport(property.getType()));
        }
    }

    private boolean isSpaceProperty(SpacePropertyInfo property, int superLevel, InitContext initContext) {
        boolean isExplicitlyExcluded = initContext.explicitlyExcluded.contains(property);
        boolean isExplicitlyIncluded = initContext.explicitlyIncluded.contains(property);
        String propertyName = property.getName();
        if (isExplicitlyExcluded) {
            if (property == this._routingProperty) {
                throw new SpaceMetadataValidationException(this._type, property, "Cannot exclude a space routing property.");
            }
            if (property == this._idProperty) {
                throw new SpaceMetadataValidationException(this._type, property, "Cannot exclude a space id property.");
            }
            if (initContext.indexedProperties.containsKey(propertyName)) {
                throw new SpaceMetadataValidationException(this._type, property, "Cannot exclude an indexed property.");
            }
            if (isExplicitlyIncluded) {
                throw new SpaceMetadataValidationException(this._type, property, "Cannot exclude an explicitly included space property.");
            }
            return false;
        }
        if (property == this._versionProperty) {
            if (isExplicitlyIncluded) {
                throw new SpaceMetadataValidationException(this._type, property, "A version property cannot be a space property.");
            }
            return false;
        }
        if (property == this._leaseExpirationProperty) {
            if (isExplicitlyIncluded) {
                throw new SpaceMetadataValidationException(this._type, property, "A lease expiration property cannot be a space property.");
            }
            return false;
        }
        if (property == this._dynamicPropertiesProperty) {
            if (isExplicitlyIncluded) {
                throw new SpaceMetadataValidationException(this._type, property, "A dynamic properties property cannot be a space property.");
            }
            return false;
        }
        if (property == this._persistProperty) {
            if (isExplicitlyIncluded) {
                throw new SpaceMetadataValidationException(this._type, property, "A persist property cannot be a space property.");
            }
            return false;
        }
        if (isExplicitlyIncluded) {
            return true;
        }
        if (property == this._idProperty) {
            return true;
        }
        if (property == this._routingProperty) {
            return true;
        }
        if (initContext.indexedProperties.containsKey(property.getName())) {
            return true;
        }
        Method getter = property.getGetterMethod();
        Method setter = property.getSetterMethod();
        if (getter == null || setter == null && !this.isSetByConstructor(property)) {
            return false;
        }
        switch (this._includeProperties) {
            case IMPLICIT: {
                if (getter.getDeclaringClass().equals(this._type) || setter != null && setter.getDeclaringClass().equals(this._type)) {
                    return true;
                }
                return superLevel >= 0;
            }
            case EXPLICIT: {
                return superLevel >= 0;
            }
        }
        throw new IllegalArgumentException("Illegal IncludeProperties: " + (Object)((Object)this._includeProperties));
    }

    private boolean isSetByConstructor(SpacePropertyInfo property) {
        if (this._constructorDescriptor != null) {
            Constructor<?> constructor = this._constructorDescriptor.getConstructor();
            ArrayList<String> constructorParamNames = new ArrayList<String>(Arrays.asList(ConstructorPropertiesHelper.extractParameterNames(constructor)));
            return constructorParamNames.contains(property.getName());
        }
        return false;
    }

    private void initIndexes(InitContext initContext) {
        SpacePropertyIndex index;
        for (Map.Entry<String, com.gigaspaces.metadata.index.SpaceIndex> entry : initContext.indexedProperties.entrySet()) {
            boolean isUnique;
            String name = entry.getKey();
            if (this._indexes.containsKey(name)) {
                throw new SpaceMetadataValidationException(this._type, "Duplicate index definition for '" + name + "'.");
            }
            SpacePropertyInfo property = this.getProperty(name);
            SpaceIndexType indexType = entry.getValue().getIndexType();
            int propertyPosition = this.indexOf(property);
            boolean bl = isUnique = property == this._idProperty && this._idAutoGenerate == false;
            if (!isUnique && entry.getValue().getIndexType().isIndexed()) {
                isUnique = ((ISpaceIndex)entry.getValue()).isUnique();
            }
            SpacePropertyIndex index2 = new SpacePropertyIndex(property.getName(), indexType, isUnique, propertyPosition);
            this._indexes.put(index2.getName(), index2);
        }
        if (this._inheritIndexes.booleanValue() && this._superTypeInfo != null) {
            for (Map.Entry<String, com.gigaspaces.metadata.index.SpaceIndex> entry : this._superTypeInfo.getIndexes().entrySet()) {
                if (this._indexes.containsKey(entry.getKey())) continue;
                com.gigaspaces.metadata.index.SpaceIndex index3 = entry.getValue();
                String indexName = entry.getKey();
                this._indexes.put(indexName, index3);
            }
        }
        if (this._idProperty != null && !this._idAutoGenerate.booleanValue() && !this._indexes.containsKey(this._idProperty.getName())) {
            index = new SpacePropertyIndex(this._idProperty.getName(), SpaceIndexType.EQUAL, true, this.indexOf(this._idProperty));
            this._indexes.put(index.getName(), index);
        }
        if (this._routingProperty != null && !this._indexes.containsKey(this._routingProperty.getName())) {
            index = new SpacePropertyIndex(this._routingProperty.getName(), SpaceIndexType.EQUAL, false, this.indexOf(this._routingProperty));
            this._indexes.put(index.getName(), index);
        }
    }

    private void validate() {
        this.validatePropertyType(this._persistProperty, "persist", Boolean.TYPE, Boolean.class);
        this.validatePropertyType(this._leaseExpirationProperty, "lease expiration", Long.TYPE, Long.class);
        this.validatePropertyType(this._versionProperty, "version", Integer.TYPE, Integer.class);
        this.validatePropertyType(this._dynamicPropertiesProperty, "dynamic properties", Map.class, Map.class);
        if (this._idProperty != null && this._idAutoGenerate.booleanValue() && this._idProperty.getType() != String.class) {
            throw new SpaceMetadataValidationException(this._type, this._idProperty, "id property with autogenerate=true must be of type String.");
        }
        this.validateSequenceNumberProperty();
        this.validatePropertyCombination(this._versionProperty, this._leaseExpirationProperty, "version", "lease expiration");
        this.validatePropertyCombination(this._versionProperty, this._persistProperty, "version", "persist");
        this.validatePropertyCombination(this._versionProperty, this._idProperty, "version", "id");
        this.validatePropertyCombination(this._versionProperty, this._routingProperty, "version", "routing");
        this.validatePropertyCombination(this._leaseExpirationProperty, this._persistProperty, "lease expiration", "persist");
        this.validatePropertyCombination(this._leaseExpirationProperty, this._idProperty, "lease expiration", "id");
        this.validatePropertyCombination(this._leaseExpirationProperty, this._routingProperty, "lease expiration", "routing");
        this.validatePropertyCombination(this._persistProperty, this._idProperty, "persist", "id");
        this.validatePropertyCombination(this._persistProperty, this._routingProperty, "persist", "routing");
        this.validateGetterSetter(this._idProperty, "Id", this._idAutoGenerate != false ? ConstructorPropertyValidation.REQUIERS_SETTER : ConstructorPropertyValidation.REQUIERS_CONSTRUCTOR_PARAM);
        if (this._routingProperty != this._idProperty) {
            this.validateGetterSetter(this._routingProperty, "Routing", ConstructorPropertyValidation.REQUIERS_CONSTRUCTOR_PARAM);
        }
        this.validateGetterSetter(this._versionProperty, "Version", ConstructorPropertyValidation.REQUIERS_SETTER);
        this.validateGetterSetter(this._persistProperty, "Persist", ConstructorPropertyValidation.REQUIERS_AT_LEAST_ONE);
        this.validateGetterSetter(this._leaseExpirationProperty, "Lease expiration", ConstructorPropertyValidation.REQUIERS_AT_LEAST_ONE);
        for (int i = 0; i < this._spaceProperties.length; ++i) {
            if (this._spaceProperties[i] == this._idProperty || this._spaceProperties[i] == this._routingProperty) continue;
            this.validateGetterSetter(this._spaceProperties[i], "Space", ConstructorPropertyValidation.REQUIERS_CONSTRUCTOR_PARAM);
        }
    }

    private void validatePropertyType(SpacePropertyInfo property, String attribute, Class<?> validType1, Class<?> validType2) {
        if (property != null && !validType1.isAssignableFrom(property.getType()) && !validType2.isAssignableFrom(property.getType())) {
            throw new SpaceMetadataValidationException(this._type, property, attribute + " property must be of type " + validType1.getSimpleName() + ".");
        }
    }

    private void validateSequenceNumberProperty() {
        if (this._sequenceNumberPropertyName == null) {
            return;
        }
        SpacePropertyInfo property = this._properties.get(this._sequenceNumberPropertyName);
        if (property == null) {
            throw new SpaceMetadataValidationException(this._type, "Type does not contain property [" + this._sequenceNumberPropertyName + "] specified as sequence-number ].");
        }
        if (!(property.getTypeName().equals(Long.class.getName()) || property.getTypeName().equals(Long.TYPE.getName()) || property.getTypeName().equals(Object.class.getName()))) {
            throw new IllegalArgumentException("SpaceSequenceNumber property must be of type Long ,long or Object");
        }
    }

    private void validatePropertyCombination(SpacePropertyInfo property1, SpacePropertyInfo property2, String property1Desc, String property2Desc) {
        if (property1 != null && property1 == property2) {
            throw new SpaceMetadataValidationException(this._type, property1, property1Desc + " and " + property2Desc + " cannot be used for the same property.");
        }
    }

    private void validateGetterSetter(SpacePropertyInfo property, String propertyDesc, ConstructorPropertyValidation validation) {
        if (property != null) {
            boolean hasSetterMethod;
            if (property.getGetterMethod() == null) {
                throw new SpaceMetadataValidationException(this._type, property, propertyDesc + " property must have a getter.");
            }
            boolean bl = hasSetterMethod = property.getSetterMethod() != null;
            if (this.hasConstructorProperties()) {
                boolean hasConstructorParameter;
                if (validation == ConstructorPropertyValidation.REQUIERS_SETTER && !hasSetterMethod) {
                    throw new SpaceMetadataValidationException(this._type, property, propertyDesc + " property must have a setter.");
                }
                boolean bl2 = hasConstructorParameter = this._constructorDescriptor.indexOfProperty(property.getName()) >= 0;
                if (validation == ConstructorPropertyValidation.REQUIERS_CONSTRUCTOR_PARAM && hasConstructorParameter && hasSetterMethod) {
                    throw new SpaceMetadataValidationException(this._type, property, propertyDesc + " property is ambiguous, property shouldn't be included in the constructor AND have a setter method.");
                }
                if (validation == ConstructorPropertyValidation.REQUIERS_CONSTRUCTOR_PARAM && !hasConstructorParameter && !hasSetterMethod) {
                    throw new SpaceMetadataValidationException(this._type, property, propertyDesc + " property must be included in the constructor or have a setter method.");
                }
                if (validation == ConstructorPropertyValidation.REQUIERS_AT_LEAST_ONE && !hasSetterMethod && !hasConstructorParameter) {
                    throw new SpaceMetadataValidationException(this._type, property, propertyDesc + " property must have a setter or be included in the constructor.");
                }
            } else if (!hasSetterMethod) {
                throw new SpaceMetadataValidationException(this._type, property, propertyDesc + " property must have a setter.");
            }
        }
    }

    private void validateWarnings() {
        if (this._spaceProperties.length == 0) {
            _logger.log(Level.WARNING, "Type [" + this._type.getName() + "] does not have any properties which can be saved in a space.");
            return;
        }
        if (this._routingProperty == null && (this._idProperty == null || this._idAutoGenerate.booleanValue())) {
            _logger.log(Level.WARNING, "Type [" + this._type.getName() + "] does not define a routing property or an id property with autoGenerate=false - The routing property will be selected implicitly.\nConsider setting a routing property explicitly to avoid unexpected behaviour or errors.");
        }
        if (this._indexes.isEmpty()) {
            _logger.log(Level.WARNING, "Type [" + this._type.getName() + "] does not have any indexes - this may impact queries performance.\nConsider indexing properties which participate in common queries to improve performance.");
        }
    }

    public String getFullDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("SpaceTypeInfo for type [" + this._type.getName() + "]:\n");
        sb.append("Super classes: " + SpaceTypeInfo.concat(this._superClasses) + ".\n");
        sb.append("Persist = [" + this._persist + "]\n");
        sb.append("Replicate = [" + this._replicate + "]\n");
        sb.append("blobstoreEnabled = [" + this._blobstoreEnabled + "]\n");
        sb.append("FifoSupport = [" + (Object)((Object)this._fifoSupport) + "]\n");
        sb.append("Fifo grouping = [" + this._fifoGroupingName + "]\n");
        sb.append("Fifo grouping indexes = [" + this._fifoGroupingIndexes + "]\n");
        sb.append("InheritIndexes = [" + this._inheritIndexes + "]\n");
        sb.append("IncludeProperties = [" + (Object)((Object)this._includeProperties) + "]\n");
        sb.append("Number of properties = [" + this._properties.size() + "]\n");
        sb.append("Number of space properties = [" + this._spaceProperties.length + "]\n");
        for (int i = 0; i < this._spaceProperties.length; ++i) {
            SpacePropertyInfo prop = this._spaceProperties[i];
            sb.append("Property #" + i + " - Name: [" + prop.getName() + "], NullValue: [" + prop.getNullValue() + "]\n");
        }
        sb.append("Id Property: [" + SpaceTypeInfo.getPropertyName(this._idProperty) + "], AutoGenerate: [" + this._idAutoGenerate + "]\n");
        sb.append("Routing Property: [" + SpaceTypeInfo.getPropertyName(this._routingProperty) + "]\n");
        sb.append("Version Property: [" + SpaceTypeInfo.getPropertyName(this._versionProperty) + "]\n");
        sb.append("Persist Property: [" + SpaceTypeInfo.getPropertyName(this._persistProperty) + "]\n");
        sb.append("Lease Expiration Property: [" + SpaceTypeInfo.getPropertyName(this._leaseExpirationProperty) + "]\n");
        sb.append("Dynamic Properties Property: [" + SpaceTypeInfo.getPropertyName(this._dynamicPropertiesProperty) + "]\n");
        sb.append("End of info for type [" + this._type.getName() + "].");
        return sb.toString();
    }

    private static String concat(String[] array) {
        if (array == null) {
            return "[null]";
        }
        if (array.length == 0) {
            return "[]";
        }
        String result = "[" + array[0];
        for (int i = 1; i < array.length; ++i) {
            result = result + "," + array[i];
        }
        result = result + "]";
        return result;
    }

    private static String getPropertyName(SpacePropertyInfo property) {
        return property == null ? null : property.getName();
    }

    public Map<String, com.gigaspaces.metadata.index.SpaceIndex> getIndexes() {
        return this._indexes;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in, LRMIInvocationContext.getEndpointLogicalVersion());
    }

    public void readExternal(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        if (version.greaterOrEquals(PlatformLogicalVersion.v10_1_0)) {
            this.readExternalV10_1(in, version);
        } else if (version.greaterOrEquals(PlatformLogicalVersion.v10_0_0)) {
            this.readExternalV10_0(in, version);
        } else if (version.greaterOrEquals(PlatformLogicalVersion.v9_6_0)) {
            this.readExternalV9_6(in, version);
        } else {
            this.readExternalV8_0(in);
        }
    }

    private void readExternalV10_1(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        this.readExternalV10_0(in, version);
        this._sequenceNumberPropertyName = IOUtils.readString(in);
    }

    private void readExternalV10_0(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        this.readExternalV9_6(in, version);
        this._blobstoreEnabled = in.readBoolean();
    }

    private void readExternalV9_6(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        String typeName = IOUtils.readString(in);
        Class type = ClassLoaderHelper.loadClass(typeName);
        SpaceTypeInfo superTypeInfo = null;
        boolean hasSuperTypeInfo = in.readBoolean();
        if (hasSuperTypeInfo) {
            superTypeInfo = new SpaceTypeInfo();
            superTypeInfo.readExternal(in, version);
        }
        this.initialize(type, superTypeInfo);
        this._systemClass = in.readBoolean();
        this._persist = in.readBoolean();
        this._replicate = in.readBoolean();
        this._fifoSupport = FifoHelper.fromCode(in.readByte());
        this._constructorDescriptor = (ConstructorInstantiationDescriptor)IOUtils.readObject(in);
        this._idProperty = this.readProperty(in);
        this._idAutoGenerate = in.readBoolean();
        this._routingProperty = this.readProperty(in);
        this._versionProperty = this.readProperty(in);
        this._persistProperty = this.readProperty(in);
        this._leaseExpirationProperty = this.readProperty(in);
        this._dynamicPropertiesProperty = this.readProperty(in);
        int numOfSpaceProperties = in.readInt();
        this._spaceProperties = new SpacePropertyInfo[numOfSpaceProperties];
        for (int i = 0; i < numOfSpaceProperties; ++i) {
            SpacePropertyInfo property = this.readProperty(in);
            String nullValue = IOUtils.readString(in);
            property.setNullValue(nullValue);
            this._spaceProperties[i] = property;
        }
        int length = in.readInt();
        if (length >= 0) {
            this._indexes = new HashMap<String, com.gigaspaces.metadata.index.SpaceIndex>(length);
            for (int i = 0; i < length; ++i) {
                com.gigaspaces.metadata.index.SpaceIndex index = (com.gigaspaces.metadata.index.SpaceIndex)IOUtils.readObject(in);
                this._indexes.put(index.getName(), index);
            }
        }
        if (this.hasConstructorProperties()) {
            this.extractFieldsForProperties();
        }
        this._blobstoreEnabled = true;
    }

    private void readExternalV8_0(ObjectInput in) throws IOException, ClassNotFoundException {
        String typeName = IOUtils.readString(in);
        Class type = ClassLoaderHelper.loadClass(typeName);
        SpaceTypeInfo superTypeInfo = null;
        boolean hasSuperTypeInfo = in.readBoolean();
        if (hasSuperTypeInfo) {
            superTypeInfo = new SpaceTypeInfo();
            superTypeInfo.readExternal(in);
        }
        this.initialize(type, superTypeInfo);
        this._systemClass = in.readBoolean();
        this._persist = in.readBoolean();
        this._replicate = in.readBoolean();
        this._fifoSupport = FifoHelper.fromCode(in.readByte());
        this._idProperty = this.readProperty(in);
        this._idAutoGenerate = in.readBoolean();
        this._routingProperty = this.readProperty(in);
        this._versionProperty = this.readProperty(in);
        this._persistProperty = this.readProperty(in);
        this._leaseExpirationProperty = this.readProperty(in);
        this._dynamicPropertiesProperty = this.readProperty(in);
        int numOfSpaceProperties = in.readInt();
        this._spaceProperties = new SpacePropertyInfo[numOfSpaceProperties];
        for (int i = 0; i < numOfSpaceProperties; ++i) {
            SpacePropertyInfo property = this.readProperty(in);
            String nullValue = IOUtils.readString(in);
            property.setNullValue(nullValue);
            this._spaceProperties[i] = property;
        }
        int length = in.readInt();
        if (length >= 0) {
            this._indexes = new HashMap<String, com.gigaspaces.metadata.index.SpaceIndex>(length);
            for (int i = 0; i < length; ++i) {
                com.gigaspaces.metadata.index.SpaceIndex index = (com.gigaspaces.metadata.index.SpaceIndex)IOUtils.readObject(in);
                this._indexes.put(index.getName(), index);
            }
        }
        this._blobstoreEnabled = true;
    }

    private SpacePropertyInfo readProperty(ObjectInput in) throws IOException, ClassNotFoundException {
        String propertyName = IOUtils.readString(in);
        if (propertyName == null) {
            return null;
        }
        SpacePropertyInfo property = this._properties.get(propertyName);
        if (property == null) {
            throw new SpaceMetadataException("Error deserializing space type info for type [" + this._type.getName() + "] - the property [" + propertyName + "] does not exist in the class loaded in the server.");
        }
        return property;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal(out, LRMIInvocationContext.getEndpointLogicalVersion());
    }

    public void writeExternal(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        if (version.greaterOrEquals(PlatformLogicalVersion.v10_1_0)) {
            this.writeExternalV10_1(out, version);
        } else if (version.greaterOrEquals(PlatformLogicalVersion.v10_0_0)) {
            this.writeExternalV10_0(out, version);
        } else if (version.greaterOrEquals(PlatformLogicalVersion.v9_6_0)) {
            this.writeExternalV9_6(out, version);
        } else {
            this.writeExternalV8_0(out);
        }
    }

    private void writeExternalV10_1(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        this.writeExternalV10_0(out, version);
        IOUtils.writeString(out, this._sequenceNumberPropertyName);
    }

    private void writeExternalV10_0(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        this.writeExternalV9_6(out, version);
        out.writeBoolean(this._blobstoreEnabled);
    }

    private void writeExternalV9_6(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        IOUtils.writeString(out, this._type.getName());
        if (this._superTypeInfo == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this._superTypeInfo.writeExternal(out, version);
        }
        out.writeBoolean(this._systemClass);
        out.writeBoolean(this._persist);
        out.writeBoolean(this._replicate);
        out.writeByte(FifoHelper.toCode(this._fifoSupport));
        IOUtils.writeObject(out, this._constructorDescriptor);
        IOUtils.writeString(out, SpaceTypeInfo.getPropertyName(this._idProperty));
        out.writeBoolean(this._idAutoGenerate);
        IOUtils.writeString(out, SpaceTypeInfo.getPropertyName(this._routingProperty));
        IOUtils.writeString(out, SpaceTypeInfo.getPropertyName(this._versionProperty));
        IOUtils.writeString(out, SpaceTypeInfo.getPropertyName(this._persistProperty));
        IOUtils.writeString(out, SpaceTypeInfo.getPropertyName(this._leaseExpirationProperty));
        IOUtils.writeString(out, SpaceTypeInfo.getPropertyName(this._dynamicPropertiesProperty));
        out.writeInt(this._spaceProperties.length);
        for (int i = 0; i < this._spaceProperties.length; ++i) {
            SpacePropertyInfo property = this._spaceProperties[i];
            IOUtils.writeString(out, property.getName());
            String nullValue = property.hasNullValue() ? property.getNullValue().toString() : null;
            IOUtils.writeString(out, nullValue);
        }
        int length = this._indexes == null ? -1 : this._indexes.size();
        out.writeInt(length);
        if (length > 0) {
            for (Map.Entry<String, com.gigaspaces.metadata.index.SpaceIndex> entry : this._indexes.entrySet()) {
                IOUtils.writeObject(out, entry.getValue());
            }
        }
    }

    private void writeExternalV8_0(ObjectOutput out) throws IOException {
        IOUtils.writeString(out, this._type.getName());
        if (this._superTypeInfo == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this._superTypeInfo.writeExternal(out);
        }
        out.writeBoolean(this._systemClass);
        out.writeBoolean(this._persist);
        out.writeBoolean(this._replicate);
        out.writeByte(FifoHelper.toCode(this._fifoSupport));
        IOUtils.writeString(out, SpaceTypeInfo.getPropertyName(this._idProperty));
        out.writeBoolean(this._idAutoGenerate);
        IOUtils.writeString(out, SpaceTypeInfo.getPropertyName(this._routingProperty));
        IOUtils.writeString(out, SpaceTypeInfo.getPropertyName(this._versionProperty));
        IOUtils.writeString(out, SpaceTypeInfo.getPropertyName(this._persistProperty));
        IOUtils.writeString(out, SpaceTypeInfo.getPropertyName(this._leaseExpirationProperty));
        IOUtils.writeString(out, SpaceTypeInfo.getPropertyName(this._dynamicPropertiesProperty));
        out.writeInt(this._spaceProperties.length);
        for (int i = 0; i < this._spaceProperties.length; ++i) {
            SpacePropertyInfo property = this._spaceProperties[i];
            IOUtils.writeString(out, property.getName());
            String nullValue = property.hasNullValue() ? property.getNullValue().toString() : null;
            IOUtils.writeString(out, nullValue);
        }
        int length = this._indexes == null ? -1 : this._indexes.size();
        out.writeInt(length);
        if (length > 0) {
            for (Map.Entry<String, com.gigaspaces.metadata.index.SpaceIndex> entry : this._indexes.entrySet()) {
                IOUtils.writeObject(out, entry.getValue());
            }
        }
    }

    private class InitContext {
        public final Map<String, com.gigaspaces.metadata.index.SpaceIndex> indexedProperties = new HashMap<String, com.gigaspaces.metadata.index.SpaceIndex>();
        public final Set<SpacePropertyInfo> explicitlyIncluded = new HashSet<SpacePropertyInfo>();
        public final Set<SpacePropertyInfo> explicitlyExcluded = new HashSet<SpacePropertyInfo>();

        private InitContext() {
        }

        public void addIndex(String name, SpaceIndexType indexType) {
            this.addIndex(name, indexType, false);
        }

        public void addIndex(String name, SpaceIndexType indexType, boolean unique) {
            if (this.indexedProperties.containsKey(name)) {
                throw new SpaceMetadataValidationException(SpaceTypeInfo.this._type, "Duplicate index definition. Index with the name [" + name + "] is already defined.");
            }
            this.indexedProperties.put(name, SpaceIndexFactory.createPropertyIndex(name, indexType, unique));
        }
    }

    private static enum ConstructorPropertyValidation {
        REQUIERS_SETTER,
        REQUIERS_CONSTRUCTOR_PARAM,
        REQUIERS_AT_LEAST_ONE;

    }
}

