/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.classloader.AbstractClassRepository;
import com.gigaspaces.internal.io.BootIOUtils;
import com.gigaspaces.internal.metadata.GsXmlParser;
import com.gigaspaces.internal.metadata.SpaceTypeInfo;
import com.gigaspaces.internal.metadata.converter.ConversionException;
import com.j_spaces.kernel.ResourceLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

@InternalApi
public class SpaceTypeInfoRepository
extends AbstractClassRepository<SpaceTypeInfo> {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.metadata.pojo");
    private static final String GS_MAPPING = "/config/mapping";
    private static final SpaceTypeInfoRepository _globalRepository = new SpaceTypeInfoRepository();

    public SpaceTypeInfoRepository() {
        this.initialize();
    }

    public static SpaceTypeInfoRepository getGlobalRepository() {
        return _globalRepository;
    }

    public static SpaceTypeInfo getTypeInfo(Class<?> type) {
        return (SpaceTypeInfo)_globalRepository.getByType(type);
    }

    private void initialize() {
        block3: {
            try {
                this.loadFolder(GS_MAPPING);
            }
            catch (Throwable e) {
                if (!_logger.isLoggable(Level.WARNING)) break block3;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Failed to parse *.gs.xml files from folder '/config/mapping': ", e);
                }
                _logger.log(Level.WARNING, "Failed to parse *.gs.xml files from folder '/config/mapping' for more information set logger '" + _logger.getName() + "' level to FINE.");
            }
        }
    }

    @Override
    protected SpaceTypeInfo create(Class<?> type, SpaceTypeInfo superTypeInfo, Object context) {
        SpaceTypeInfo typeInfo = new SpaceTypeInfo(type, superTypeInfo, (Map)context);
        if (_logger.isLoggable(Level.FINE)) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.log(Level.FINER, "Type metadata created and cached: [" + type.getName() + "].\n" + typeInfo.getFullDescription());
            } else {
                _logger.log(Level.FINE, "Type metadata created and cached: [" + type.getName() + "].");
            }
        }
        return typeInfo;
    }

    public void loadFolder(String path) {
        URL url = ResourceLoader.getResourceURL(path = path.trim());
        if (url == null) {
            return;
        }
        File file = new File(URLDecoder.decode(url.getFile()));
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Scanning for type metadata info at [" + file.getAbsolutePath() + "].");
        }
        HashMap<String, Node> xmlMap = new HashMap<String, Node>();
        SpaceTypeInfoRepository.loadPath(file, xmlMap);
        String[] typeNames = xmlMap.keySet().toArray(new String[xmlMap.size()]);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Found " + typeNames.length + " type metadata specifications while scanning [" + file.getAbsolutePath() + "].");
        }
        for (String typeName : typeNames) {
            try {
                SpaceTypeInfo typeInfo = (SpaceTypeInfo)super.getByName(typeName, xmlMap);
                if (typeInfo != null || !_logger.isLoggable(Level.WARNING)) continue;
                _logger.log(Level.WARNING, "Skipped gs.xml for type [" + typeName + "] because type could not be loaded.");
            }
            catch (Throwable e) {
                if (!_logger.isLoggable(Level.WARNING)) continue;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.WARNING, "Failed to load type info for type [" + typeName + "].", e);
                    continue;
                }
                _logger.log(Level.WARNING, "Failed to load type info for type [" + typeName + "]: " + e.getMessage());
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Finished loading types metadata from [" + file.getAbsolutePath() + "].");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadPath(File file, Map<String, Node> xmlMap) {
        if (file.isDirectory()) {
            File[] subFiles = BootIOUtils.listFiles((File)file);
            for (int i = 0; i < subFiles.length; ++i) {
                SpaceTypeInfoRepository.loadPath(subFiles[i], xmlMap);
            }
            return;
        }
        if (!file.getName().endsWith(".gs.xml")) return;
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "Scanning for type metadata info at [{0}].", file.getAbsolutePath());
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            GsXmlParser.parseGsXml(inputStream, xmlMap, file.getAbsolutePath());
            return;
        }
        catch (Exception e) {
            if (!_logger.isLoggable(Level.SEVERE)) return;
            _logger.log(Level.SEVERE, "Error while scanning for type metadata info at [" + file.getAbsolutePath() + "].", e);
            return;
        }
        finally {
            block15: {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    if (!_logger.isLoggable(Level.WARNING)) break block15;
                    _logger.log(Level.WARNING, "Could not close input stream for file [" + file.getAbsolutePath() + "].", e);
                }
            }
        }
    }

    public static Node loadFile(String fileName, String typeName) {
        InputStream inputStream = ResourceLoader.getResourceStream(fileName);
        if (inputStream == null) {
            return null;
        }
        try {
            HashMap<String, Node> xmlMap = new HashMap<String, Node>();
            GsXmlParser.parseGsXml(inputStream, xmlMap, fileName);
            for (Map.Entry entry : xmlMap.entrySet()) {
                if (!((String)entry.getKey()).equals(typeName)) continue;
                Node node = (Node)entry.getValue();
                return node;
            }
            Iterator iterator = null;
            return iterator;
        }
        catch (Exception e) {
            throw new ConversionException("Could not parse the mapping document in input stream", e);
        }
        finally {
            block14: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!_logger.isLoggable(Level.WARNING)) break block14;
                    _logger.log(Level.WARNING, "Could not close input stream", e);
                }
            }
        }
    }
}

