/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.annotation.pojo.FifoSupport;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.io.CustomClassLoaderObjectInputStream;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.EntryIntrospector;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.EntryTypeDesc;
import com.gigaspaces.internal.metadata.ExternalEntryIntrospector;
import com.gigaspaces.internal.metadata.FifoHelper;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.ITypeIntrospector;
import com.gigaspaces.internal.metadata.IdentifierInfo;
import com.gigaspaces.internal.metadata.MetadataEntryIntrospector;
import com.gigaspaces.internal.metadata.PojoIntrospector;
import com.gigaspaces.internal.metadata.PropertyInfo;
import com.gigaspaces.internal.metadata.SpaceDocumentSupportHelper;
import com.gigaspaces.internal.metadata.SpaceIdType;
import com.gigaspaces.internal.metadata.TypeDescVersionedSerializable;
import com.gigaspaces.internal.metadata.VirtualEntryIntrospector;
import com.gigaspaces.internal.utils.ReflectionUtils;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.metadata.SpaceDocumentSupport;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.gigaspaces.metadata.SpaceMetadataValidationException;
import com.gigaspaces.metadata.StorageType;
import com.gigaspaces.metadata.index.ISpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndexFactory;
import com.gigaspaces.metadata.index.SpaceIndexType;
import com.gigaspaces.query.extension.metadata.TypeQueryExtensions;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.client.MetaDataEntry;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jini.core.entry.Entry;

@InternalApi
public class TypeDesc
implements ITypeDesc {
    private static final long serialVersionUID = 1L;
    public static final int NO_SUCH_PROPERTY = -1;
    private static final boolean ENABLE_EXTERNALIZABLE = Boolean.getBoolean("com.gs.transport_protocol.lrmi.serialize-using-externalizable");
    private String _typeName;
    private String _codeBase;
    private String[] _superTypesNames;
    private PropertyInfo[] _fixedProperties;
    private boolean _supportsDynamicProperties;
    private boolean _supportsOptimisticLocking;
    private String _idPropertyName;
    private boolean _autoGenerateId;
    private String _defaultPropertyName;
    private String _routingPropertyName;
    private String _fifoGroupingName;
    private Set<String> _fifoGroupingIndexes;
    private FifoSupport _fifoSupport;
    private boolean _systemType;
    private boolean _replicable;
    private EntryType _objectType;
    private StorageType _storageType;
    boolean _isAllPropertiesObjectStorageType;
    private boolean _blobstoreEnabled;
    private Class<? extends Object> _objectClass;
    private ITypeIntrospector<?> _objectIntrospector;
    private Map<String, SpaceIndex> _indexes;
    private TypeQueryExtensions queryExtensionsInfo;
    private int _sequenceNumberFixedPropertyPos;
    private transient EntryTypeDesc[] _entryTypeDescs;
    private transient String _typeSimpleName;
    private transient boolean _isExternalizable;
    private transient Map<String, Integer> _fixedPropertiesMap;
    private transient int _idPropertyPos;
    private transient int _defaultPropertyPos;
    private transient int _routingPropertyPos;
    private transient Class<? extends ExternalEntry> _externalEntryWrapperClass;
    private transient ITypeIntrospector<? extends ExternalEntry> _externalEntryIntrospector;
    private transient boolean _autoGenerateRouting;
    private String _documentWrapperClassName;
    private transient Class<? extends SpaceDocument> _documentWrapperClass;
    private transient ITypeIntrospector<? extends SpaceDocument> _documentIntrospector;
    private transient String[] _restrictedSuperClasses;
    private transient int _checksum;
    private transient int _numOfIndexedProperties;
    private transient int[] _indexedPropertiesIDs;
    private transient String _description;
    private String _dotnetDocumentWrapperTypeName;
    private byte _dotnetDynamicPropertiesStorageType;
    private transient List<SpaceIndex> _compoundIndexes;
    private transient String _primitivePropertiesWithoutNullValues;

    public TypeDesc() {
    }

    public TypeDesc(String typeName, String codeBase, String[] superTypesNames, PropertyInfo[] properties, boolean supportsDynamicProperties, Map<String, SpaceIndex> indexes, String idPropertyName, boolean idAutoGenerate, String defaultPropertyName, String routingPropertyName, String fifoGroupingName, Set<String> fifoGroupingIndexes, boolean systemType, FifoSupport fifoMode, boolean replicable, boolean supportsOptimisticLocking, StorageType storageType, EntryType entryType, Class<? extends Object> objectClass, Class<? extends ExternalEntry> externalEntryClass, Class<? extends SpaceDocument> documentWrapperClass, String dotnetDocumentWrapperType, byte dotnetStorageType, boolean blobstoreEnabled, String sequenceNumberPropertyName, TypeQueryExtensions queryExtensionsInfo) {
        this._typeName = typeName;
        this._codeBase = codeBase;
        this._superTypesNames = superTypesNames;
        this._fixedProperties = properties;
        this._supportsDynamicProperties = supportsDynamicProperties;
        this._indexes = indexes;
        this._idPropertyName = idPropertyName;
        this._autoGenerateId = idAutoGenerate;
        this._documentWrapperClassName = documentWrapperClass == null ? null : documentWrapperClass.getName();
        this._dotnetDocumentWrapperTypeName = dotnetDocumentWrapperType;
        this._dotnetDynamicPropertiesStorageType = dotnetStorageType;
        this._defaultPropertyName = TypeDesc.calcDefaultPropertyName(defaultPropertyName, this._idPropertyName, properties, indexes);
        this._routingPropertyName = routingPropertyName != null ? routingPropertyName : this._defaultPropertyName;
        this._fifoGroupingName = fifoGroupingName;
        this._fifoGroupingIndexes = fifoGroupingIndexes != null ? fifoGroupingIndexes : new HashSet();
        this._systemType = systemType;
        this._fifoSupport = fifoMode;
        this._replicable = replicable;
        this._supportsOptimisticLocking = supportsOptimisticLocking;
        this._storageType = storageType;
        this._objectType = entryType;
        this._objectClass = objectClass;
        this._objectIntrospector = this.initObjectIntrospector();
        this._externalEntryWrapperClass = externalEntryClass;
        this._blobstoreEnabled = blobstoreEnabled;
        this.queryExtensionsInfo = queryExtensionsInfo;
        if (this._documentWrapperClassName == null) {
            if (this._dotnetDocumentWrapperTypeName == null) {
                this._dotnetDocumentWrapperTypeName = SpaceDocument.class.getName();
            }
            this._documentWrapperClassName = this._dotnetDocumentWrapperTypeName;
        } else if (this._dotnetDocumentWrapperTypeName == null) {
            this._dotnetDocumentWrapperTypeName = this._documentWrapperClassName;
        }
        this.validate();
        this.updateDefaultStorageType();
        this.validateAndUpdateSequenceNumberInfo(sequenceNumberPropertyName);
        this.initializeV9_0_0();
        this.addFifoGroupingIndexesIfNeeded(this._indexes, this._fifoGroupingName, this._fifoGroupingIndexes);
    }

    private void updateDefaultStorageType() {
        for (PropertyInfo property : this._fixedProperties) {
            if (property.getStorageType() != StorageType.DEFAULT) continue;
            property.setDefaultStorageType(this._storageType);
        }
    }

    private void validate() {
        if (this._fifoGroupingName != null && !StringUtils.hasText(this._fifoGroupingName)) {
            throw new IllegalArgumentException("When fifo grouping property is set, it must not be an empty path");
        }
        if (!this._fifoGroupingIndexes.isEmpty() && this._fifoGroupingName == null) {
            throw new IllegalStateException("Cannot declare fifo grouping index without a fifo grouping property");
        }
        for (PropertyInfo property : this._fixedProperties) {
            String propertyName = property.getName();
            if (propertyName.equals(this._idPropertyName)) {
                this.updateAndValidateObjectStorageType(property, "SpaceId and storage type other than " + (Object)((Object)StorageType.OBJECT) + " cannot be used for the same property.");
            }
            if (propertyName.equals(this._routingPropertyName)) {
                this.updateAndValidateObjectStorageType(property, "SpaceRouting and storage type other than " + (Object)((Object)StorageType.OBJECT) + " cannot be used for the same property.");
            }
            if (this._fifoGroupingName != null && this.isSameProperty(this._fifoGroupingName, propertyName)) {
                this.updateAndValidateObjectStorageType(property, "SpaceFifoGroupingProperty and storage type other than " + (Object)((Object)StorageType.OBJECT) + " cannot be used for the same property.");
            }
            for (String fifoGroupingIndexPath : this._fifoGroupingIndexes) {
                if (!this.isSameProperty(fifoGroupingIndexPath, propertyName)) continue;
                this.updateAndValidateObjectStorageType(property, "SpaceFifoGroupingIndex and storage type other than " + (Object)((Object)StorageType.OBJECT) + " cannot be used for the same property.");
            }
            if (ReflectionUtils.isSpacePrimitive(property.getType().getName())) {
                this.updateAndValidateObjectStorageType(property, "Primitive property type- cannot declare storage type other than " + (Object)((Object)StorageType.OBJECT));
            }
            for (String indexName : this._indexes.keySet()) {
                SpaceIndexType indexType = this._indexes.get(indexName).getIndexType();
                if (indexType == null || indexType == SpaceIndexType.NONE || !this.isSameProperty(indexName, propertyName)) continue;
                this.updateAndValidateObjectStorageType(property, "Space index with type = " + (Object)((Object)indexType) + " (not " + (Object)((Object)SpaceIndexType.NONE) + ") and storage type with type = " + (Object)((Object)property.getStorageType()) + " (not StorageType." + (Object)((Object)StorageType.OBJECT) + ") cannot be used for the same property.");
            }
        }
    }

    private void updateAndValidateObjectStorageType(PropertyInfo property, String errMsg) {
        StorageType storageType = property.getStorageType();
        if (storageType == StorageType.DEFAULT) {
            property.setDefaultStorageType(StorageType.OBJECT);
        } else if (storageType != StorageType.OBJECT) {
            throw new SpaceMetadataValidationException(this._typeName, property, errMsg);
        }
    }

    private boolean isSameProperty(String indexName, String propertyName) {
        return indexName.equals(propertyName) || indexName.startsWith(propertyName + ".") || indexName.startsWith(propertyName + "[*]");
    }

    private void validateAndUpdateSequenceNumberInfo(String sequenceNumberPropertyName) {
        this._sequenceNumberFixedPropertyPos = -1;
        if (sequenceNumberPropertyName != null) {
            if (!StringUtils.hasText(sequenceNumberPropertyName)) {
                throw new IllegalArgumentException("When SpaceSequenceNumber property is set, it must not be empty");
            }
            for (int pos = 0; pos < this._fixedProperties.length; ++pos) {
                PropertyInfo property = this._fixedProperties[pos];
                String propertyName = property.getName();
                if (!propertyName.equals(sequenceNumberPropertyName)) continue;
                if (!(property.getTypeName().equals(Long.class.getName()) || property.getTypeName().equals(Long.TYPE.getName()) || property.getTypeName().equals(Object.class.getName()))) {
                    throw new IllegalArgumentException("SpaceSequenceNumber property must be of type Long or long");
                }
                this._sequenceNumberFixedPropertyPos = pos;
                return;
            }
            throw new SpaceMetadataValidationException(this._typeName, sequenceNumberPropertyName, " invalid property name specified for SpaceSequenceNumber");
        }
    }

    private ITypeIntrospector<? extends Object> initObjectIntrospector() {
        if (this._objectClass == null) {
            return null;
        }
        if (ExternalEntry.class.isAssignableFrom(this._objectClass)) {
            return null;
        }
        try {
            if (MetaDataEntry.class.isAssignableFrom(this._objectClass)) {
                return new MetadataEntryIntrospector(this);
            }
            if (Entry.class.isAssignableFrom(this._objectClass)) {
                return new EntryIntrospector(this);
            }
        }
        catch (NoSuchMethodException e) {
            throw new SpaceMetadataException("Failed to create introspector for type '" + this._objectClass.getName() + "'", e);
        }
        return new PojoIntrospector(this);
    }

    private static int indexOfProperty(PropertyInfo[] properties, String propertyName) {
        if (propertyName == null) {
            return -1;
        }
        for (int i = 0; i < properties.length; ++i) {
            if (!properties[i].getName().equals(propertyName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ITypeDesc clone() {
        try {
            TypeDesc copy = (TypeDesc)super.clone();
            copy._indexes = new HashMap<String, SpaceIndex>(this._indexes);
            copy.buildCompoundIndexesList();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean isInactive() {
        return false;
    }

    @Override
    public String getTypeName() {
        return this._typeName;
    }

    @Override
    public String getTypeSimpleName() {
        return this._typeSimpleName;
    }

    @Override
    public Class<? extends Object> getObjectClass() {
        return this._objectClass;
    }

    @Override
    public Class<? extends SpaceDocument> getDocumentWrapperClass() {
        return this._documentWrapperClass;
    }

    @Override
    public String getCodeBase() {
        return this._codeBase;
    }

    @Override
    public boolean isExternalizable() {
        return this._isExternalizable;
    }

    @Override
    public String[] getSuperClassesNames() {
        return this._superTypesNames;
    }

    @Override
    public String getSuperTypeName() {
        if (this._superTypesNames == null || this._superTypesNames.length < 2) {
            return null;
        }
        return this._superTypesNames[1];
    }

    @Override
    public String[] getRestrictSuperClassesNames() {
        return this._restrictedSuperClasses;
    }

    @Override
    public PropertyInfo[] getProperties() {
        return this._fixedProperties;
    }

    @Override
    public int getNumOfFixedProperties() {
        return this._fixedProperties.length;
    }

    @Override
    public PropertyInfo getFixedProperty(int propertyID) {
        return this._fixedProperties[propertyID];
    }

    @Override
    public int getFixedPropertyPosition(String propertyName) {
        if (propertyName == null) {
            return -1;
        }
        Integer position = this._fixedPropertiesMap.get(propertyName);
        return position != null ? position : -1;
    }

    @Override
    public PropertyInfo getFixedProperty(String propertyName) {
        int propertyID = this.getFixedPropertyPosition(propertyName);
        return propertyID != -1 ? this._fixedProperties[propertyID] : null;
    }

    @Override
    public boolean supportsDynamicProperties() {
        return this._supportsDynamicProperties;
    }

    @Override
    public boolean supportsOptimisticLocking() {
        return this._supportsOptimisticLocking;
    }

    @Override
    public int getNumOfIndexedProperties() {
        return this._numOfIndexedProperties;
    }

    @Override
    public int getIndexedPropertyID(int propertyID) {
        return this._indexedPropertiesIDs[propertyID];
    }

    @Override
    public int getIdentifierPropertyId() {
        return this._idPropertyPos;
    }

    @Override
    public String getIdPropertyName() {
        return this._idPropertyName;
    }

    @Override
    public SpaceIdType getSpaceIdType() {
        if (this._idPropertyName == null || this._idPropertyName.length() == 0) {
            return SpaceIdType.NONE;
        }
        return this._autoGenerateId ? SpaceIdType.AUTOMATIC : SpaceIdType.MANUAL;
    }

    @Override
    public boolean isAutoGenerateId() {
        return this._autoGenerateId;
    }

    @Override
    public boolean isAutoGenerateRouting() {
        return this._autoGenerateRouting;
    }

    @Override
    public int getRoutingPropertyId() {
        return this._routingPropertyPos;
    }

    @Override
    public String getRoutingPropertyName() {
        return this._routingPropertyName;
    }

    @Override
    public String getDefaultPropertyName() {
        return this._defaultPropertyName;
    }

    @Override
    public boolean isFifoSupported() {
        return this._fifoSupport != FifoSupport.OFF;
    }

    @Override
    public boolean isFifoDefault() {
        return this._fifoSupport == FifoSupport.ALL;
    }

    @Override
    public FifoSupport getFifoSupport() {
        return this._fifoSupport;
    }

    @Override
    public boolean isSystemType() {
        return this._systemType;
    }

    @Override
    public boolean isReplicable() {
        return this._replicable;
    }

    @Override
    public boolean isBlobstoreEnabled() {
        return this._blobstoreEnabled;
    }

    @Override
    public EntryType getObjectType() {
        return this._objectType;
    }

    @Override
    public String[] getPropertiesNames() {
        String[] names = new String[this._fixedProperties.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this._fixedProperties[i].getName();
        }
        return names;
    }

    @Override
    public String[] getPropertiesTypes() {
        String[] types = new String[this._fixedProperties.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this._fixedProperties[i].getTypeName();
        }
        return types;
    }

    @Override
    public boolean[] getPropertiesIndexTypes() {
        boolean[] indexTypes = new boolean[this._fixedProperties.length];
        for (int i = 0; i < indexTypes.length; ++i) {
            indexTypes[i] = this.getIndexType(this._fixedProperties[i].getName()).isIndexed();
        }
        return indexTypes;
    }

    @Override
    public int getChecksum() {
        return this._checksum;
    }

    @Override
    public boolean isConcreteType() {
        return this._objectIntrospector != null;
    }

    @Override
    public boolean supports(EntryType entryType) {
        return entryType == null || entryType.isVirtual() || this.isConcreteType();
    }

    @Override
    public EntryTypeDesc getEntryTypeDesc(EntryType entryType) {
        return this._entryTypeDescs[entryType == null ? (byte)0 : entryType.getTypeCode()];
    }

    @Override
    public ITypeIntrospector getIntrospector(EntryType entryType) {
        ITypeIntrospector<Object> result;
        if (entryType == null) {
            entryType = this._objectType;
        }
        if (entryType.isConcrete()) {
            result = this._objectIntrospector;
        } else if (entryType == EntryType.DOCUMENT_JAVA || entryType == EntryType.CPP || entryType == EntryType.OBJECT_DOTNET || entryType == EntryType.DOCUMENT_DOTNET) {
            result = this._documentIntrospector;
        } else if (entryType == EntryType.EXTERNAL_ENTRY) {
            result = this._externalEntryIntrospector;
        } else {
            throw new IllegalArgumentException("Unsupported entry type - " + (Object)((Object)entryType));
        }
        if (result == null) {
            throw new IllegalArgumentException("Type descriptor for type [" + this.getTypeName() + "] does not contain an introspector for " + (Object)((Object)entryType));
        }
        return result;
    }

    @Override
    public Map<String, SpaceIndex> getIndexes() {
        return this._indexes;
    }

    @Override
    public TypeQueryExtensions getQueryExtensions() {
        return this.queryExtensionsInfo;
    }

    @Override
    public SpaceIndexType getIndexType(String indexName) {
        SpaceIndex index = this._indexes.get(indexName);
        return index != null ? index.getIndexType() : SpaceIndexType.NONE;
    }

    @Override
    public byte getDotnetDynamicPropertiesStorageType() {
        return this._dotnetDynamicPropertiesStorageType;
    }

    @Override
    public String getDotnetDocumentWrapperTypeName() {
        return this._dotnetDocumentWrapperTypeName;
    }

    @Override
    public String getPrimitivePropertiesWithoutNullValues() {
        return this._primitivePropertiesWithoutNullValues;
    }

    private static int calcChecksum(String[] superClasses, PropertyInfo[] properties) {
        int superClassesChecksum = TypeDesc.calculateChecksum(superClasses);
        int propertiesChecksum = TypeDesc.calculateChecksum(properties);
        return superClassesChecksum ^ propertiesChecksum;
    }

    private static String[] calcRestrictSuperClasses(String[] superClasses, String className) {
        if (superClasses == null || superClasses.length < 2) {
            return superClasses;
        }
        int startIndex = 0;
        if (superClasses[0].equals(className)) {
            ++startIndex;
        }
        int endIndex = superClasses.length - 1;
        if (superClasses[superClasses.length - 1].equals(Object.class.getName())) {
            --endIndex;
        }
        int size = endIndex - startIndex + 1;
        String[] result = new String[size];
        System.arraycopy(superClasses, startIndex, result, 0, size);
        return result;
    }

    private static String calcDefaultPropertyName(String explicitDefaultPropertyName, String idPropertyName, PropertyInfo[] properties, Map<String, SpaceIndex> indexes) {
        if (explicitDefaultPropertyName != null) {
            return explicitDefaultPropertyName;
        }
        if (idPropertyName != null) {
            return idPropertyName;
        }
        if (indexes != null) {
            for (int i = 0; i < properties.length; ++i) {
                SpaceIndex spaceIndex = indexes.get(properties[i].getName());
                if (spaceIndex == null || !spaceIndex.getIndexType().isIndexed()) continue;
                return properties[i].getName();
            }
        }
        return properties.length != 0 ? properties[0].getName() : null;
    }

    private void calcIndexedPropertiesIDs() {
        int length = this._fixedProperties.length;
        this._indexedPropertiesIDs = new int[length];
        this._numOfIndexedProperties = 0;
        for (int i = 0; i < length; ++i) {
            int n;
            if (this.getIndexType(this.getFixedProperty(i).getName()).isIndexed()) {
                int n2 = this._numOfIndexedProperties;
                n = n2;
                this._numOfIndexedProperties = n2 + 1;
            } else {
                n = -1;
            }
            this._indexedPropertiesIDs[i] = n;
        }
    }

    @Override
    public boolean hasSequenceNumber() {
        return this._sequenceNumberFixedPropertyPos >= 0;
    }

    @Override
    public int getSequenceNumberFixedPropertyID() {
        return this._sequenceNumberFixedPropertyPos;
    }

    private static int calculateChecksum(PropertyInfo[] properties) {
        if (properties == null) {
            return 0;
        }
        int result = 0;
        for (PropertyInfo property : properties) {
            result = 31 * result + TypeDesc.hashCode(property.getName());
            result = 47 * result + TypeDesc.hashCode(property.getTypeName());
        }
        return result;
    }

    private static int calculateChecksum(String[] array) {
        if (array == null) {
            return 0;
        }
        int result = 0;
        int offset = 0;
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            result = 31 * result + TypeDesc.hashCode(array[offset++]);
        }
        return result;
    }

    private static int hashCode(String s) {
        int result = 0;
        int offset = 0;
        char[] chars = s.toCharArray();
        int length = chars.length;
        for (int i = 0; i < length; ++i) {
            result = 31 * result + chars[offset++];
        }
        return result;
    }

    public String toString() {
        if (this._description == null) {
            this._description = this.generateDescription();
        }
        return this._description;
    }

    private String generateDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("typeName=").append(this._typeName).append(", ");
        sb.append("checksum=").append(this._checksum).append(", ");
        sb.append("codebase=").append(this._codeBase).append(", ");
        sb.append("superTypesNames=").append(Arrays.toString(this._superTypesNames)).append(", ");
        sb.append("supportsDynamicProperties=").append(this._supportsDynamicProperties).append(", ");
        sb.append("supportsOptimisticLocking=").append(this._supportsOptimisticLocking).append(", ");
        sb.append("systemType=").append(this._systemType).append(", ");
        sb.append("replicatable=").append(this._replicable).append(", ");
        sb.append("blobstoreEnabled=").append(this._blobstoreEnabled).append(", ");
        sb.append("storageType=").append((Object)this._storageType).append(", ");
        sb.append("fifoSupport=").append((Object)this._fifoSupport).append(", ");
        sb.append("idPropertyName=").append(this._idPropertyName).append(", ");
        sb.append("idAutoGenerate=").append(this._autoGenerateId).append(", ");
        sb.append("routingPropertyName=").append(this._routingPropertyName).append(", ");
        sb.append("fifoGroupingPropertyName=").append(this._fifoGroupingName).append(", ");
        String sequenceNumberPropertyName = this._sequenceNumberFixedPropertyPos != -1 ? this._fixedProperties[this._sequenceNumberFixedPropertyPos].getName() : null;
        sb.append("sequenceNumberPropertyName=").append(sequenceNumberPropertyName).append(", ");
        sb.append("objectClass=").append(this._objectClass == null ? "" : this._objectClass.getName()).append(", ");
        sb.append("documentWrapperClass=").append(this._documentWrapperClassName).append(", ");
        sb.append("fixedProperties=").append(Arrays.toString(this._fixedProperties)).append(", ");
        sb.append("indexes=").append(Arrays.toString(this._indexes.values().toArray())).append(", ");
        sb.append("fifoGroupingIndexes=").append(this._fifoGroupingIndexes);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in, LRMIInvocationContext.getEndpointLogicalVersion(), false);
    }

    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in, PlatformLogicalVersion.getLogicalVersion(), true);
    }

    void readExternal(ObjectInput in, PlatformLogicalVersion version, boolean swap) throws IOException, ClassNotFoundException {
        this._sequenceNumberFixedPropertyPos = -1;
        if (version.greaterOrEquals(PlatformLogicalVersion.v11_0_0)) {
            this.readExternalV11_0_0(in, version, swap);
        } else if (version.greaterOrEquals(PlatformLogicalVersion.v10_1_0)) {
            this.readExternalV10_1(in, version, swap);
        } else if (version.greaterOrEquals(PlatformLogicalVersion.v10_0_0)) {
            this.readExternalV10_0(in);
        } else {
            this.readExternalV9_0_2(in);
        }
    }

    private void readExternalV10_1(ObjectInput in, PlatformLogicalVersion version, boolean swap) throws IOException, ClassNotFoundException {
        this._typeName = IOUtils.readString(in);
        this._codeBase = IOUtils.readString(in);
        this._superTypesNames = IOUtils.readStringArray(in);
        int numOfProperties = in.readInt();
        if (numOfProperties >= 0) {
            this._fixedProperties = new PropertyInfo[numOfProperties];
            for (int i = 0; i < numOfProperties; ++i) {
                String name = IOUtils.readString(in);
                String typeName = IOUtils.readString(in);
                Class type = (Class)IOUtils.readObject(in);
                SpaceDocumentSupport documentSupport = SpaceDocumentSupportHelper.fromCode(in.readByte());
                StorageType storageType = StorageType.fromCode(in.readInt());
                byte dotnetStorageType = in.readByte();
                this._fixedProperties[i] = new PropertyInfo(name, typeName, type, documentSupport, storageType, dotnetStorageType);
            }
        }
        this._idPropertyName = IOUtils.readString(in);
        this._autoGenerateId = in.readBoolean();
        this._defaultPropertyName = IOUtils.readString(in);
        this._routingPropertyName = IOUtils.readString(in);
        this._fifoGroupingName = IOUtils.readString(in);
        int numOfFifoGroupingIndexes = in.readInt();
        if (numOfFifoGroupingIndexes >= 0) {
            this._fifoGroupingIndexes = new HashSet<String>();
            for (int i = 0; i < numOfFifoGroupingIndexes; ++i) {
                String fifoGroupingIndex = IOUtils.readString(in);
                this._fifoGroupingIndexes.add(fifoGroupingIndex);
            }
        }
        this._sequenceNumberFixedPropertyPos = in.readInt();
        this._fifoSupport = FifoHelper.fromCode(in.readByte());
        this._systemType = in.readBoolean();
        this._replicable = in.readBoolean();
        this._blobstoreEnabled = in.readBoolean();
        this._supportsDynamicProperties = in.readBoolean();
        this._dotnetDynamicPropertiesStorageType = in.readByte();
        this._supportsOptimisticLocking = in.readBoolean();
        this._objectType = EntryType.fromByte(in.readByte());
        this._storageType = StorageType.fromCode(in.readInt());
        this._objectIntrospector = TypeDesc.readIntrospector(in, version);
        this._documentWrapperClassName = IOUtils.readString(in);
        this._dotnetDocumentWrapperTypeName = IOUtils.readString(in);
        int numOfIndexes = in.readInt();
        if (numOfIndexes >= 0) {
            this._indexes = new HashMap<String, SpaceIndex>(numOfIndexes);
            for (int i = 0; i < numOfIndexes; ++i) {
                ISpaceIndex index = swap ? (ISpaceIndex)IOUtils.readNullableSwapExternalizableObject(in) : (ISpaceIndex)IOUtils.readObject(in);
                this._indexes.put(index.getName(), index);
            }
        }
        this.initializeV9_0_0();
    }

    private void readExternalV11_0_0(ObjectInput in, PlatformLogicalVersion version, boolean swap) throws IOException, ClassNotFoundException {
        this._typeName = IOUtils.readString(in);
        this._codeBase = IOUtils.readString(in);
        this._superTypesNames = IOUtils.readStringArray(in);
        int numOfProperties = in.readInt();
        if (numOfProperties >= 0) {
            this._fixedProperties = new PropertyInfo[numOfProperties];
            for (int i = 0; i < numOfProperties; ++i) {
                String name = IOUtils.readString(in);
                String typeName = IOUtils.readString(in);
                Class type = (Class)IOUtils.readObject(in);
                SpaceDocumentSupport documentSupport = SpaceDocumentSupportHelper.fromCode(in.readByte());
                StorageType storageType = StorageType.fromCode(in.readInt());
                byte dotnetStorageType = in.readByte();
                this._fixedProperties[i] = new PropertyInfo(name, typeName, type, documentSupport, storageType, dotnetStorageType);
            }
        }
        this._idPropertyName = IOUtils.readString(in);
        this._autoGenerateId = in.readBoolean();
        this._defaultPropertyName = IOUtils.readString(in);
        this._routingPropertyName = IOUtils.readString(in);
        this._fifoGroupingName = IOUtils.readString(in);
        int numOfFifoGroupingIndexes = in.readInt();
        if (numOfFifoGroupingIndexes >= 0) {
            this._fifoGroupingIndexes = new HashSet<String>();
            for (int i = 0; i < numOfFifoGroupingIndexes; ++i) {
                String fifoGroupingIndex = IOUtils.readString(in);
                this._fifoGroupingIndexes.add(fifoGroupingIndex);
            }
        }
        this._sequenceNumberFixedPropertyPos = in.readInt();
        this._fifoSupport = FifoHelper.fromCode(in.readByte());
        this._systemType = in.readBoolean();
        this._replicable = in.readBoolean();
        this._blobstoreEnabled = in.readBoolean();
        this._supportsDynamicProperties = in.readBoolean();
        this._dotnetDynamicPropertiesStorageType = in.readByte();
        this._supportsOptimisticLocking = in.readBoolean();
        this._objectType = EntryType.fromByte(in.readByte());
        this._storageType = StorageType.fromCode(in.readInt());
        this._objectIntrospector = TypeDesc.readIntrospector(in, version);
        this._documentWrapperClassName = IOUtils.readString(in);
        this._dotnetDocumentWrapperTypeName = IOUtils.readString(in);
        int numOfIndexes = in.readInt();
        if (numOfIndexes >= 0) {
            this._indexes = new HashMap<String, SpaceIndex>(numOfIndexes);
            for (int i = 0; i < numOfIndexes; ++i) {
                ISpaceIndex index = swap ? (ISpaceIndex)IOUtils.readNullableSwapExternalizableObject(in) : (ISpaceIndex)IOUtils.readObject(in);
                this._indexes.put(index.getName(), index);
            }
        }
        this.readObjectsFromByteArray(in);
        this.initializeV9_0_0();
    }

    private void writeObjectsAsByteArray(ObjectOutput out) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream ba = new ObjectOutputStream(byteArrayOutputStream);
        ba.writeObject(this.queryExtensionsInfo);
        IOUtils.writeObject(out, byteArrayOutputStream.toByteArray());
    }

    private void readObjectsFromByteArray(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] byteArray = (byte[])IOUtils.readObject(in);
        CustomClassLoaderObjectInputStream objectInputStream = new CustomClassLoaderObjectInputStream(new ByteArrayInputStream(byteArray), Thread.currentThread().getContextClassLoader());
        this.queryExtensionsInfo = (TypeQueryExtensions)objectInputStream.readObject();
    }

    private void readExternalV10_0(ObjectInput in) throws IOException, ClassNotFoundException {
        this._typeName = IOUtils.readString(in);
        this._codeBase = IOUtils.readString(in);
        this._superTypesNames = IOUtils.readStringArray(in);
        int numOfProperties = in.readInt();
        if (numOfProperties >= 0) {
            this._fixedProperties = new PropertyInfo[numOfProperties];
            for (int i = 0; i < numOfProperties; ++i) {
                String name = IOUtils.readString(in);
                String typeName = IOUtils.readString(in);
                Class type = (Class)IOUtils.readObject(in);
                SpaceDocumentSupport documentSupport = SpaceDocumentSupportHelper.fromCode(in.readByte());
                StorageType storageType = StorageType.fromCode(in.readInt());
                byte dotnetStorageType = in.readByte();
                this._fixedProperties[i] = new PropertyInfo(name, typeName, type, documentSupport, storageType, dotnetStorageType);
            }
        }
        this._idPropertyName = IOUtils.readString(in);
        this._autoGenerateId = in.readBoolean();
        this._defaultPropertyName = IOUtils.readString(in);
        this._routingPropertyName = IOUtils.readString(in);
        this._fifoGroupingName = IOUtils.readString(in);
        int numOfFifoGroupingIndexes = in.readInt();
        if (numOfFifoGroupingIndexes >= 0) {
            this._fifoGroupingIndexes = new HashSet<String>();
            for (int i = 0; i < numOfFifoGroupingIndexes; ++i) {
                String fifoGroupingIndex = IOUtils.readString(in);
                this._fifoGroupingIndexes.add(fifoGroupingIndex);
            }
        }
        this._fifoSupport = FifoHelper.fromCode(in.readByte());
        this._systemType = in.readBoolean();
        this._replicable = in.readBoolean();
        this._blobstoreEnabled = in.readBoolean();
        this._supportsDynamicProperties = in.readBoolean();
        this._dotnetDynamicPropertiesStorageType = in.readByte();
        this._supportsOptimisticLocking = in.readBoolean();
        this._objectType = EntryType.fromByte(in.readByte());
        this._storageType = StorageType.fromCode(in.readInt());
        this._objectIntrospector = (ITypeIntrospector)IOUtils.readObject(in);
        this._documentWrapperClassName = IOUtils.readString(in);
        this._dotnetDocumentWrapperTypeName = IOUtils.readString(in);
        int numOfIndexes = in.readInt();
        if (numOfIndexes >= 0) {
            this._indexes = new HashMap<String, SpaceIndex>(numOfIndexes);
            for (int i = 0; i < numOfIndexes; ++i) {
                ISpaceIndex index = (ISpaceIndex)IOUtils.readObject(in);
                this._indexes.put(index.getName(), index);
            }
        }
        this.initializeV9_0_0();
    }

    private void readExternalV9_0_2(ObjectInput in) throws IOException, ClassNotFoundException {
        this._typeName = IOUtils.readString(in);
        this._codeBase = IOUtils.readString(in);
        this._superTypesNames = IOUtils.readStringArray(in);
        int numOfProperties = in.readInt();
        if (numOfProperties >= 0) {
            this._fixedProperties = new PropertyInfo[numOfProperties];
            for (int i = 0; i < numOfProperties; ++i) {
                String name = IOUtils.readString(in);
                String typeName = IOUtils.readString(in);
                Class type = (Class)IOUtils.readObject(in);
                SpaceDocumentSupport documentSupport = SpaceDocumentSupportHelper.fromCode(in.readByte());
                StorageType storageType = StorageType.fromCode(in.readInt());
                byte dotnetStorageType = in.readByte();
                this._fixedProperties[i] = new PropertyInfo(name, typeName, type, documentSupport, storageType, dotnetStorageType);
            }
        }
        this._idPropertyName = IOUtils.readString(in);
        this._autoGenerateId = in.readBoolean();
        this._defaultPropertyName = IOUtils.readString(in);
        this._routingPropertyName = IOUtils.readString(in);
        this._fifoGroupingName = IOUtils.readString(in);
        int numOfFifoGroupingIndexes = in.readInt();
        if (numOfFifoGroupingIndexes >= 0) {
            this._fifoGroupingIndexes = new HashSet<String>();
            for (int i = 0; i < numOfFifoGroupingIndexes; ++i) {
                String fifoGroupingIndex = IOUtils.readString(in);
                this._fifoGroupingIndexes.add(fifoGroupingIndex);
            }
        }
        this._fifoSupport = FifoHelper.fromCode(in.readByte());
        this._systemType = in.readBoolean();
        this._replicable = in.readBoolean();
        this._supportsDynamicProperties = in.readBoolean();
        this._dotnetDynamicPropertiesStorageType = in.readByte();
        this._supportsOptimisticLocking = in.readBoolean();
        this._objectType = EntryType.fromByte(in.readByte());
        this._storageType = StorageType.fromCode(in.readInt());
        this._objectIntrospector = (ITypeIntrospector)IOUtils.readObject(in);
        this._documentWrapperClassName = IOUtils.readString(in);
        this._dotnetDocumentWrapperTypeName = IOUtils.readString(in);
        int numOfIndexes = in.readInt();
        if (numOfIndexes >= 0) {
            this._indexes = new HashMap<String, SpaceIndex>(numOfIndexes);
            for (int i = 0; i < numOfIndexes; ++i) {
                ISpaceIndex index = (ISpaceIndex)IOUtils.readObject(in);
                this._indexes.put(index.getName(), index);
            }
        }
        this.initializeV9_0_0();
    }

    private void initializeV9_0_0() {
        this._typeSimpleName = StringUtils.getSuffix(this._typeName, ".");
        this._idPropertyPos = TypeDesc.indexOfProperty(this._fixedProperties, this._idPropertyName);
        if (this._idPropertyPos != -1) {
            this._fixedProperties[this._idPropertyPos] = new IdentifierInfo(this._fixedProperties[this._idPropertyPos], this._autoGenerateId);
        }
        this._fixedPropertiesMap = new HashMap<String, Integer>();
        for (int i = 0; i < this._fixedProperties.length; ++i) {
            this._fixedPropertiesMap.put(this._fixedProperties[i].getName(), i);
        }
        this._defaultPropertyPos = TypeDesc.indexOfProperty(this._fixedProperties, this._defaultPropertyName);
        this._routingPropertyPos = TypeDesc.indexOfProperty(this._fixedProperties, this._routingPropertyName);
        this._restrictedSuperClasses = TypeDesc.calcRestrictSuperClasses(this._superTypesNames, this._typeName);
        this._checksum = TypeDesc.calcChecksum(this._superTypesNames, this._fixedProperties);
        this.calcIndexedPropertiesIDs();
        if (this._objectIntrospector != null) {
            this._objectIntrospector.initialize(this);
            this._isExternalizable = ENABLE_EXTERNALIZABLE && Externalizable.class.isAssignableFrom(this._objectIntrospector.getType()) && !this._objectIntrospector.hasConstructorProperties();
        }
        this._externalEntryIntrospector = new ExternalEntryIntrospector<ExternalEntry>(this, this._externalEntryWrapperClass);
        this._documentWrapperClass = ClassLoaderHelper.loadClass(this._documentWrapperClassName, true, SpaceDocument.class);
        this._documentIntrospector = new VirtualEntryIntrospector<SpaceDocument>(this, this._documentWrapperClass);
        this._autoGenerateRouting = this._autoGenerateId && this._idPropertyName.equals(this._routingPropertyName);
        this._isAllPropertiesObjectStorageType = this.initializeAllPropertiesObjectStorageType();
        this._entryTypeDescs = this.initEntryTypeDescs();
        this.buildCompoundIndexesList();
        this._primitivePropertiesWithoutNullValues = this.findPrimitivePropertiesWithoutNullValues();
    }

    private String findPrimitivePropertiesWithoutNullValues() {
        if (this._objectIntrospector == null) {
            return null;
        }
        String result = null;
        for (int i = 0; i < this._fixedProperties.length; ++i) {
            if (!this._fixedProperties[i].isPrimitive() || this._fixedProperties[i].getType() == Boolean.TYPE || this._objectIntrospector.propertyHasNullValue(i)) continue;
            result = result == null ? this._fixedProperties[i].getName() + " (" + this._fixedProperties[i].getTypeName() + ")" : result + ", " + this._fixedProperties[i].getName() + " (" + this._fixedProperties[i].getTypeName() + ")";
        }
        return result;
    }

    private boolean initializeAllPropertiesObjectStorageType() {
        for (int i = 0; i < this._fixedProperties.length; ++i) {
            StorageType storageType = this._fixedProperties[i].getStorageType();
            if (storageType == StorageType.DEFAULT) {
                throw new IllegalStateException("StorageType should not be default at this point");
            }
            if (storageType == StorageType.OBJECT) continue;
            return false;
        }
        return true;
    }

    private EntryTypeDesc[] initEntryTypeDescs() {
        EntryTypeDesc[] result = new EntryTypeDesc[10];
        result[EntryType.OBJECT_JAVA.getTypeCode()] = new EntryTypeDesc(EntryType.OBJECT_JAVA, this);
        result[EntryType.EXTERNAL_ENTRY.getTypeCode()] = new EntryTypeDesc(EntryType.EXTERNAL_ENTRY, this);
        result[EntryType.DOCUMENT_JAVA.getTypeCode()] = new EntryTypeDesc(EntryType.DOCUMENT_JAVA, this);
        result[EntryType.CPP.getTypeCode()] = new EntryTypeDesc(EntryType.CPP, this);
        result[EntryType.OBJECT_DOTNET.getTypeCode()] = new EntryTypeDesc(EntryType.OBJECT_DOTNET, this);
        result[EntryType.DOCUMENT_DOTNET.getTypeCode()] = new EntryTypeDesc(EntryType.DOCUMENT_DOTNET, this);
        result[0] = result[this._objectType.getTypeCode()];
        return result;
    }

    @Override
    public boolean isAllPropertiesObjectStorageType() {
        return this._isAllPropertiesObjectStorageType;
    }

    private void addFifoGroupingIndexesIfNeeded(Map<String, SpaceIndex> indexes, String fifoGroupingName, Set<String> fifoGroupingIndexNames) {
        if (fifoGroupingName == null) {
            return;
        }
        if (indexes.get(fifoGroupingName) == null) {
            indexes.put(fifoGroupingName, SpaceIndexFactory.createPropertyIndex(fifoGroupingName, SpaceIndexType.EQUAL));
        }
        for (String fifoGroupingIndexName : fifoGroupingIndexNames) {
            if (indexes.get(fifoGroupingIndexName) != null) continue;
            indexes.put(fifoGroupingIndexName, SpaceIndexFactory.createPropertyIndex(fifoGroupingIndexName, SpaceIndexType.EQUAL));
        }
    }

    @Override
    public StorageType getStorageType() {
        return this._storageType;
    }

    @Override
    public String getFifoGroupingPropertyPath() {
        return this._fifoGroupingName;
    }

    @Override
    public Set<String> getFifoGroupingIndexesPaths() {
        return this._fifoGroupingIndexes;
    }

    private void buildCompoundIndexesList() {
        if (this._indexes != null && !this._indexes.isEmpty()) {
            for (Map.Entry<String, SpaceIndex> entry : this._indexes.entrySet()) {
                if (!((ISpaceIndex)entry.getValue()).isCompoundIndex()) continue;
                if (this._compoundIndexes == null) {
                    this._compoundIndexes = new ArrayList<SpaceIndex>();
                }
                this._compoundIndexes.add(entry.getValue());
            }
        }
    }

    @Override
    public List<SpaceIndex> getCompoundIndexes() {
        return this._compoundIndexes;
    }

    @Override
    public boolean anyCompoundIndex() {
        return this._compoundIndexes != null && this._compoundIndexes.size() > 0;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal(out, LRMIInvocationContext.getEndpointLogicalVersion(), false);
    }

    public void writeToSwap(ObjectOutput out) throws IOException {
        this.writeExternal(out, PlatformLogicalVersion.getLogicalVersion(), true);
    }

    void writeExternal(ObjectOutput out, PlatformLogicalVersion version, boolean swap) throws IOException {
        if (version.greaterOrEquals(PlatformLogicalVersion.v11_0_0)) {
            this.writeExternalV11_0_0(out, version, swap);
        } else if (version.greaterOrEquals(PlatformLogicalVersion.v10_1_0)) {
            this.writeExternalV10_1(out, version, swap);
        } else if (version.greaterOrEquals(PlatformLogicalVersion.v10_0_0)) {
            this.writeExternalV10_0(out);
        } else {
            this.writeExternalV9_0_2(out);
        }
    }

    private void writeExternalV11_0_0(ObjectOutput out, PlatformLogicalVersion version, boolean swap) throws IOException {
        IOUtils.writeString(out, this._typeName);
        IOUtils.writeString(out, this._codeBase);
        IOUtils.writeStringArray(out, this._superTypesNames);
        int numOfProperties = this._fixedProperties == null ? -1 : this._fixedProperties.length;
        out.writeInt(numOfProperties);
        for (int i = 0; i < numOfProperties; ++i) {
            PropertyInfo property = this._fixedProperties[i];
            IOUtils.writeString(out, property.getName());
            IOUtils.writeString(out, property.getTypeName());
            IOUtils.writeObject(out, property.getType());
            out.writeByte(SpaceDocumentSupportHelper.toCode(property.getDocumentSupport()));
            out.writeInt(property.getStorageType().getCode());
            out.writeByte(property.getDotnetStorageType());
        }
        IOUtils.writeString(out, this._idPropertyName);
        out.writeBoolean(this._autoGenerateId);
        IOUtils.writeString(out, this._defaultPropertyName);
        IOUtils.writeString(out, this._routingPropertyName);
        IOUtils.writeString(out, this._fifoGroupingName);
        int numOfFifoGroupingIndexes = this._fifoGroupingIndexes == null ? -1 : this._fifoGroupingIndexes.size();
        out.writeInt(numOfFifoGroupingIndexes);
        if (numOfFifoGroupingIndexes > 0) {
            for (String fifoGroupingIndexName : this._fifoGroupingIndexes) {
                IOUtils.writeString(out, fifoGroupingIndexName);
            }
        }
        out.writeInt(this._sequenceNumberFixedPropertyPos);
        out.writeByte(FifoHelper.toCode(this._fifoSupport));
        out.writeBoolean(this._systemType);
        out.writeBoolean(this._replicable);
        out.writeBoolean(this._blobstoreEnabled);
        out.writeBoolean(this._supportsDynamicProperties);
        out.writeByte(this._dotnetDynamicPropertiesStorageType);
        out.writeBoolean(this._supportsOptimisticLocking);
        out.writeByte(this._objectType.getTypeCode());
        out.writeInt(this._storageType.getCode());
        TypeDesc.writeIntrospector(out, version, this._objectIntrospector);
        IOUtils.writeString(out, this._documentWrapperClassName);
        IOUtils.writeString(out, this._dotnetDocumentWrapperTypeName);
        int numOfIndexes = this._indexes == null ? -1 : this._indexes.size();
        out.writeInt(numOfIndexes);
        if (numOfIndexes > 0) {
            for (Map.Entry<String, SpaceIndex> entry : this._indexes.entrySet()) {
                if (swap) {
                    IOUtils.writeNullableSwapExternalizableObject(out, (ISpaceIndex)entry.getValue());
                    continue;
                }
                IOUtils.writeObject(out, entry.getValue());
            }
        }
        this.writeObjectsAsByteArray(out);
    }

    private void writeExternalV10_1(ObjectOutput out, PlatformLogicalVersion version, boolean swap) throws IOException {
        IOUtils.writeString(out, this._typeName);
        IOUtils.writeString(out, this._codeBase);
        IOUtils.writeStringArray(out, this._superTypesNames);
        int numOfProperties = this._fixedProperties == null ? -1 : this._fixedProperties.length;
        out.writeInt(numOfProperties);
        for (int i = 0; i < numOfProperties; ++i) {
            PropertyInfo property = this._fixedProperties[i];
            IOUtils.writeString(out, property.getName());
            IOUtils.writeString(out, property.getTypeName());
            IOUtils.writeObject(out, property.getType());
            out.writeByte(SpaceDocumentSupportHelper.toCode(property.getDocumentSupport()));
            out.writeInt(property.getStorageType().getCode());
            out.writeByte(property.getDotnetStorageType());
        }
        IOUtils.writeString(out, this._idPropertyName);
        out.writeBoolean(this._autoGenerateId);
        IOUtils.writeString(out, this._defaultPropertyName);
        IOUtils.writeString(out, this._routingPropertyName);
        IOUtils.writeString(out, this._fifoGroupingName);
        int numOfFifoGroupingIndexes = this._fifoGroupingIndexes == null ? -1 : this._fifoGroupingIndexes.size();
        out.writeInt(numOfFifoGroupingIndexes);
        if (numOfFifoGroupingIndexes > 0) {
            for (String fifoGroupingIndexName : this._fifoGroupingIndexes) {
                IOUtils.writeString(out, fifoGroupingIndexName);
            }
        }
        out.writeInt(this._sequenceNumberFixedPropertyPos);
        out.writeByte(FifoHelper.toCode(this._fifoSupport));
        out.writeBoolean(this._systemType);
        out.writeBoolean(this._replicable);
        out.writeBoolean(this._blobstoreEnabled);
        out.writeBoolean(this._supportsDynamicProperties);
        out.writeByte(this._dotnetDynamicPropertiesStorageType);
        out.writeBoolean(this._supportsOptimisticLocking);
        out.writeByte(this._objectType.getTypeCode());
        out.writeInt(this._storageType.getCode());
        TypeDesc.writeIntrospector(out, version, this._objectIntrospector);
        IOUtils.writeString(out, this._documentWrapperClassName);
        IOUtils.writeString(out, this._dotnetDocumentWrapperTypeName);
        int numOfIndexes = this._indexes == null ? -1 : this._indexes.size();
        out.writeInt(numOfIndexes);
        if (numOfIndexes > 0) {
            for (Map.Entry<String, SpaceIndex> entry : this._indexes.entrySet()) {
                if (swap) {
                    IOUtils.writeNullableSwapExternalizableObject(out, (ISpaceIndex)entry.getValue());
                    continue;
                }
                IOUtils.writeObject(out, entry.getValue());
            }
        }
    }

    private void writeExternalV10_0(ObjectOutput out) throws IOException {
        IOUtils.writeString(out, this._typeName);
        IOUtils.writeString(out, this._codeBase);
        IOUtils.writeStringArray(out, this._superTypesNames);
        int numOfProperties = this._fixedProperties == null ? -1 : this._fixedProperties.length;
        out.writeInt(numOfProperties);
        for (int i = 0; i < numOfProperties; ++i) {
            PropertyInfo property = this._fixedProperties[i];
            IOUtils.writeString(out, property.getName());
            IOUtils.writeString(out, property.getTypeName());
            IOUtils.writeObject(out, property.getType());
            out.writeByte(SpaceDocumentSupportHelper.toCode(property.getDocumentSupport()));
            out.writeInt(property.getStorageType().getCode());
            out.writeByte(property.getDotnetStorageType());
        }
        IOUtils.writeString(out, this._idPropertyName);
        out.writeBoolean(this._autoGenerateId);
        IOUtils.writeString(out, this._defaultPropertyName);
        IOUtils.writeString(out, this._routingPropertyName);
        IOUtils.writeString(out, this._fifoGroupingName);
        int numOfFifoGroupingIndexes = this._fifoGroupingIndexes == null ? -1 : this._fifoGroupingIndexes.size();
        out.writeInt(numOfFifoGroupingIndexes);
        if (numOfFifoGroupingIndexes > 0) {
            for (String fifoGroupingIndexName : this._fifoGroupingIndexes) {
                IOUtils.writeString(out, fifoGroupingIndexName);
            }
        }
        out.writeByte(FifoHelper.toCode(this._fifoSupport));
        out.writeBoolean(this._systemType);
        out.writeBoolean(this._replicable);
        out.writeBoolean(this._blobstoreEnabled);
        out.writeBoolean(this._supportsDynamicProperties);
        out.writeByte(this._dotnetDynamicPropertiesStorageType);
        out.writeBoolean(this._supportsOptimisticLocking);
        out.writeByte(this._objectType.getTypeCode());
        out.writeInt(this._storageType.getCode());
        IOUtils.writeObject(out, this._objectIntrospector);
        IOUtils.writeString(out, this._documentWrapperClassName);
        IOUtils.writeString(out, this._dotnetDocumentWrapperTypeName);
        int numOfIndexes = this._indexes == null ? -1 : this._indexes.size();
        out.writeInt(numOfIndexes);
        if (numOfIndexes > 0) {
            for (Map.Entry<String, SpaceIndex> entry : this._indexes.entrySet()) {
                IOUtils.writeObject(out, entry.getValue());
            }
        }
    }

    private void writeExternalV9_0_2(ObjectOutput out) throws IOException {
        IOUtils.writeString(out, this._typeName);
        IOUtils.writeString(out, this._codeBase);
        IOUtils.writeStringArray(out, this._superTypesNames);
        int numOfProperties = this._fixedProperties == null ? -1 : this._fixedProperties.length;
        out.writeInt(numOfProperties);
        for (int i = 0; i < numOfProperties; ++i) {
            PropertyInfo property = this._fixedProperties[i];
            IOUtils.writeString(out, property.getName());
            IOUtils.writeString(out, property.getTypeName());
            IOUtils.writeObject(out, property.getType());
            out.writeByte(SpaceDocumentSupportHelper.toCode(property.getDocumentSupport()));
            out.writeInt(property.getStorageType().getCode());
            out.writeByte(property.getDotnetStorageType());
        }
        IOUtils.writeString(out, this._idPropertyName);
        out.writeBoolean(this._autoGenerateId);
        IOUtils.writeString(out, this._defaultPropertyName);
        IOUtils.writeString(out, this._routingPropertyName);
        IOUtils.writeString(out, this._fifoGroupingName);
        int numOfFifoGroupingIndexes = this._fifoGroupingIndexes == null ? -1 : this._fifoGroupingIndexes.size();
        out.writeInt(numOfFifoGroupingIndexes);
        if (numOfFifoGroupingIndexes > 0) {
            for (String fifoGroupingIndexName : this._fifoGroupingIndexes) {
                IOUtils.writeString(out, fifoGroupingIndexName);
            }
        }
        out.writeByte(FifoHelper.toCode(this._fifoSupport));
        out.writeBoolean(this._systemType);
        out.writeBoolean(this._replicable);
        out.writeBoolean(this._supportsDynamicProperties);
        out.writeByte(this._dotnetDynamicPropertiesStorageType);
        out.writeBoolean(this._supportsOptimisticLocking);
        out.writeByte(this._objectType.getTypeCode());
        out.writeInt(this._storageType.getCode());
        IOUtils.writeObject(out, this._objectIntrospector);
        IOUtils.writeString(out, this._documentWrapperClassName);
        IOUtils.writeString(out, this._dotnetDocumentWrapperTypeName);
        int numOfIndexes = this._indexes == null ? -1 : this._indexes.size();
        out.writeInt(numOfIndexes);
        if (numOfIndexes > 0) {
            for (Map.Entry<String, SpaceIndex> entry : this._indexes.entrySet()) {
                IOUtils.writeObject(out, entry.getValue());
            }
        }
    }

    @Override
    public Serializable getVersionedSerializable() {
        return new TypeDescVersionedSerializable(this);
    }

    private static void writeIntrospector(ObjectOutput out, PlatformLogicalVersion version, ITypeIntrospector<?> objectIntrospector) throws IOException {
        if (objectIntrospector == null) {
            out.write(0);
        } else {
            out.write(objectIntrospector.getExternalizableCode());
            objectIntrospector.writeExternal(out, version);
        }
    }

    private static ITypeIntrospector<?> readIntrospector(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        ITypeIntrospector<?> result = TypeDesc.initFromCode(in.readByte());
        if (result != null) {
            result.readExternal(in, version);
        }
        return result;
    }

    private static ITypeIntrospector<?> initFromCode(byte code) {
        switch (code) {
            case 0: {
                return null;
            }
            case 1: {
                return new PojoIntrospector();
            }
            case 2: {
                return new EntryIntrospector();
            }
            case 3: {
                return new MetadataEntryIntrospector();
            }
            case 4: {
                return new ExternalEntryIntrospector();
            }
        }
        throw new IllegalStateException("Unsupported introspector code: " + code);
    }
}

