/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.ITypeDesc;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@InternalApi
public class TypeDescriptorUtils {
    public static List<ITypeDesc> sort(Map<String, ITypeDesc> typeDescriptors) {
        TypeHierarchySorter sorter = new TypeHierarchySorter();
        for (ITypeDesc typeDescriptor : typeDescriptors.values()) {
            sorter.addTypeName(typeDescriptor.getTypeName(), typeDescriptor.getSuperTypeName());
        }
        Map allTypeNameNodes = sorter.nodes;
        TypeNameNode root = sorter.fixAndGetRoot();
        LinkedList<ITypeDesc> result = new LinkedList<ITypeDesc>();
        for (String typeName : root.children) {
            TypeDescriptorUtils.addSelfThenChildren(typeName, typeDescriptors, allTypeNameNodes, result);
        }
        return result;
    }

    private static void addSelfThenChildren(String typeName, Map<String, ITypeDesc> typeDescriptors, Map<String, TypeNameNode> nodes, List<ITypeDesc> result) {
        ITypeDesc typeDescriptor = typeDescriptors.get(typeName);
        result.add(typeDescriptor);
        TypeNameNode typeNameNode = nodes.get(typeName);
        for (String childTypeName : typeNameNode.children) {
            TypeDescriptorUtils.addSelfThenChildren(childTypeName, typeDescriptors, nodes, result);
        }
    }

    private static class TypeHierarchySorter {
        private final TypeNameNode root = new TypeNameNode(Object.class.getName(), null);
        private final Map<String, TypeNameNode> nodes = new HashMap<String, TypeNameNode>();

        private TypeHierarchySorter() {
            this.nodes.put(this.root.typeName, this.root);
        }

        private void addTypeName(String typeName, String superTypeName) {
            TypeNameNode typeNameNode = this.nodes.get(typeName);
            TypeNameNode superTypeNameNode = this.nodes.get(superTypeName);
            if (typeNameNode == null) {
                typeNameNode = new TypeNameNode(typeName, superTypeName);
                this.nodes.put(typeName, typeNameNode);
            } else {
                typeNameNode.superTypeName = superTypeName;
            }
            if (superTypeNameNode == null) {
                superTypeNameNode = new TypeNameNode(superTypeName, Object.class.getName());
            }
            superTypeNameNode.children.add(typeName);
            this.nodes.put(superTypeName, superTypeNameNode);
        }

        private TypeNameNode fixAndGetRoot() {
            for (TypeNameNode typeNameNode : this.nodes.values()) {
                if (typeNameNode == this.root || !typeNameNode.superTypeName.equals(this.root.typeName)) continue;
                this.root.children.add(typeNameNode.typeName);
            }
            return this.root;
        }
    }

    private static class TypeNameNode {
        private final String typeName;
        private String superTypeName;
        private final Set<String> children = new HashSet<String>();

        private TypeNameNode(String typeName, String superTypeName) {
            this.typeName = typeName;
            this.superTypeName = superTypeName;
        }
    }
}

