/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.DocumentProperties;
import com.gigaspaces.entry.VirtualEntry;
import com.gigaspaces.internal.metadata.AbstractTypeIntrospector;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.j_spaces.core.client.ClientUIDHandler;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

@InternalApi
public class VirtualEntryIntrospector<T extends VirtualEntry>
extends AbstractTypeIntrospector<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> _implClass;
    private final Constructor<T> _constructor;

    public VirtualEntryIntrospector() {
        throw new IllegalStateException("This constructor is required for Externalizable and should not be called directly.");
    }

    public VirtualEntryIntrospector(ITypeDesc typeDesc, Class<T> documentWrapperClass) {
        super(typeDesc);
        this._implClass = documentWrapperClass;
        try {
            this._constructor = this._implClass.getConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            throw new SpaceMetadataException("Failed to get constructor of document type " + this._implClass.getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new SpaceMetadataException("Failed to get constructor of document type " + this._implClass.getName(), e);
        }
    }

    @Override
    public Class<T> getType() {
        return this._implClass;
    }

    @Override
    public boolean hasUID(T target) {
        return this.getUID(target) != null;
    }

    @Override
    public String getUID(T target, boolean isTemplate, boolean ignoreIdIfNotExists) {
        String idPropertyName = this._typeDesc.getIdPropertyName();
        if (idPropertyName == null || idPropertyName.length() == 0) {
            if (ignoreIdIfNotExists) {
                return null;
            }
            throw new SpaceMetadataException("Cannot get uid - SpaceId property is not defined.");
        }
        Object id = target.getProperty(idPropertyName);
        if (this._typeDesc.isAutoGenerateId()) {
            if (id != null) {
                return id.toString();
            }
            if (ignoreIdIfNotExists) {
                return null;
            }
            throw new SpaceMetadataException("SpaceId(autogenerate=true) property value cannot be null.");
        }
        if (isTemplate) {
            return null;
        }
        if (id != null) {
            return ClientUIDHandler.createUIDFromName(id.toString(), this._typeDesc.getTypeName());
        }
        throw new SpaceMetadataException("SpaceId(autogenerate=false) property value cannot be null.");
    }

    @Override
    public boolean setUID(T target, String uid) {
        try {
            String idPropertyName = this._typeDesc.getIdPropertyName();
            if (idPropertyName == null || idPropertyName.length() == 0) {
                return false;
            }
            if (!this._typeDesc.isAutoGenerateId()) {
                return false;
            }
            String fieldValue = (String)target.getProperty(idPropertyName);
            if (fieldValue != null && fieldValue.length() != 0) {
                return false;
            }
            target.setProperty(idPropertyName, uid);
            return true;
        }
        catch (Exception e) {
            throw new SpaceMetadataException("Failed to set uid for type " + this.getType().getName(), e);
        }
    }

    @Override
    public boolean hasVersionProperty(T target) {
        return true;
    }

    @Override
    public int getVersion(T target) {
        return target.getVersion();
    }

    @Override
    public boolean setVersion(T target, int version) {
        target.setVersion(version);
        return true;
    }

    @Override
    public boolean hasTransientProperty(T target) {
        return true;
    }

    @Override
    public boolean isTransient(T target) {
        if (target == null) {
            return false;
        }
        return target.isTransient();
    }

    @Override
    public boolean setTransient(T target, boolean isTransient) {
        target.setTransient(isTransient);
        return true;
    }

    @Override
    public boolean hasTimeToLiveProperty(T target) {
        return false;
    }

    @Override
    public long getTimeToLive(T target) {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean setTimeToLive(T target, long ttl) {
        return false;
    }

    @Override
    public void setEntryInfo(T target, String uid, int version, long timeToLive) {
        this.setUID(target, uid);
        this.setVersion(target, version);
        this.setTimeToLive(target, timeToLive);
    }

    @Override
    public T newInstance() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        VirtualEntry instance = (VirtualEntry)this._constructor.newInstance(new Object[0]);
        instance.setTypeName(this._typeDesc.getTypeName());
        return (T)instance;
    }

    @Override
    protected Object[] processDocumentObjectInterop(Object[] values, EntryType entryType, boolean cloneOnChange) {
        return entryType.isConcrete() ? this.toDocumentIfNeeded(values, cloneOnChange) : values;
    }

    @Override
    public boolean hasDynamicProperties() {
        return true;
    }

    @Override
    public Map<String, Object> getDynamicProperties(T target) {
        DocumentProperties dynamicProperties = new DocumentProperties(target.getProperties().size());
        for (Map.Entry<String, Object> entry : target.getProperties().entrySet()) {
            if (this._typeDesc.getFixedPropertyPosition(entry.getKey()) != -1) continue;
            dynamicProperties.put(entry.getKey(), entry.getValue());
        }
        return dynamicProperties.size() != 0 ? dynamicProperties : null;
    }

    @Override
    public void setDynamicProperties(T target, Map<String, Object> dynamicProperties) {
        target.addProperties(dynamicProperties);
    }

    @Override
    public Object getValue(T target, int index) {
        return target.getProperty(this._typeDesc.getFixedProperty(index).getName());
    }

    @Override
    public void setValue(T target, Object value, int index) {
        target.setProperty(this._typeDesc.getFixedProperty(index).getName(), value);
    }

    @Override
    protected Object getDynamicProperty(T target, String name) {
        return target.getProperty(name);
    }

    @Override
    public void setDynamicProperty(T target, String name, Object value) {
        target.setProperty(name, value);
    }

    @Override
    public void unsetDynamicProperty(T target, String name) {
        target.removeProperty(name);
    }

    @Override
    public Object[] getValues(T target) {
        Object[] result = new Object[this._typeDesc.getNumOfFixedProperties()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this._typeDesc.isAutoGenerateId() && i == this._typeDesc.getIdentifierPropertyId() ? null : this.getValue(target, i);
        }
        return result;
    }

    @Override
    public void setValues(T target, Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.setValue(target, values[i], i);
        }
    }

    @Override
    public byte getExternalizableCode() {
        throw new IllegalStateException("This class does not support serialization.");
    }

    @Override
    public void readExternal(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        throw new IOException("This class does not support serialization.");
    }

    @Override
    public void writeExternal(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        throw new IOException("This class does not support serialization.");
    }
}

