/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata.pojo;

import com.gigaspaces.api.InternalApi;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@InternalApi
public class PojoPropertyInfo {
    private final String _name;
    private Class<?> _type;
    private Method _getterMethod;
    private Method _setterMethod;
    private final List<Method> _methods;

    public PojoPropertyInfo(String name) {
        this._name = name;
        this._methods = new ArrayList<Method>();
    }

    public String getName() {
        return this._name;
    }

    public Class<?> getType() {
        return this._type;
    }

    private void setType(Class<?> type) {
        this._type = type;
    }

    public Method getGetterMethod() {
        return this._getterMethod;
    }

    private void setGetterMethod(Method method) {
        this._getterMethod = method;
    }

    public Method getSetterMethod() {
        return this._setterMethod;
    }

    private void setSetterMethod(Method method) {
        this._setterMethod = method;
    }

    public List<Method> getMethods() {
        return this._methods;
    }

    public void calculateAccessors() {
        Method getMethod = null;
        Method isMethod = null;
        ArrayList<Method> setMethods = new ArrayList<Method>();
        for (Method method : this._methods) {
            if (method.getParameterTypes().length == 1) {
                setMethods.add(method);
                continue;
            }
            if (method.getName().startsWith("is")) {
                if (isMethod != null) continue;
                isMethod = method;
                continue;
            }
            if (getMethod != null) continue;
            getMethod = method;
        }
        if (isMethod != null && getMethod != null) {
            this.setSetterMethod(PojoPropertyInfo.findMatchingSetter(setMethods, isMethod));
            if (this._setterMethod != null) {
                this.setGetterMethod(isMethod);
            } else {
                this.setSetterMethod(PojoPropertyInfo.findMatchingSetter(setMethods, getMethod));
                if (this._setterMethod != null) {
                    this.setGetterMethod(getMethod);
                }
            }
        } else {
            this.setGetterMethod(isMethod != null ? isMethod : getMethod);
            if (this._getterMethod != null) {
                this.setSetterMethod(PojoPropertyInfo.findMatchingSetter(setMethods, this._getterMethod));
            } else if (setMethods.size() == 1) {
                this.setSetterMethod((Method)setMethods.get(0));
            } else {
                this._setterMethod = null;
            }
        }
        if (this._getterMethod != null) {
            this.setType(this._getterMethod.getReturnType());
        } else if (this._setterMethod != null) {
            this.setType(this._setterMethod.getParameterTypes()[0]);
        } else {
            this.setType(null);
        }
    }

    private static Method findMatchingSetter(List<Method> setters, Method getter) {
        Class<?> type = getter.getReturnType();
        for (Method method : setters) {
            if (!method.getParameterTypes()[0].equals(type)) continue;
            return method;
        }
        return null;
    }
}

