/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.metadata.pojo;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.pojo.PojoPropertyInfo;
import com.gigaspaces.internal.utils.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class PojoTypeInfo {
    private static final String PREFIX_GET = "get";
    private static final String PREFIX_SET = "set";
    public static final String PREFIX_IS = "is";
    private final Class<?> _type;
    private final PojoTypeInfo _superTypeInfo;
    private final String _name;
    private final Map<String, PojoPropertyInfo> _properties;

    public PojoTypeInfo(Class<?> type, PojoTypeInfo superTypeInfo) {
        this._type = type;
        this._superTypeInfo = superTypeInfo;
        this._name = type.getName();
        this._properties = PojoTypeInfo.initProperties(type, superTypeInfo);
    }

    public String getName() {
        return this._name;
    }

    public Class<?> getType() {
        return this._type;
    }

    public PojoTypeInfo getSuperTypeInfo() {
        return this._superTypeInfo;
    }

    public Map<String, PojoPropertyInfo> getProperties() {
        return this._properties;
    }

    public int getNumOfProperties() {
        return this._properties.size();
    }

    public PojoPropertyInfo getProperty(String propertyName) {
        return this._properties.get(propertyName);
    }

    private static Map<String, PojoPropertyInfo> initProperties(Class<?> type, PojoTypeInfo superTypeInfo) {
        HashMap<String, PojoPropertyInfo> properties = new HashMap<String, PojoPropertyInfo>();
        Method[] methods = type.getDeclaredMethods();
        for (Method method : methods) {
            String propertyName;
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) || method.isSynthetic() || method.isBridge() || (propertyName = PojoTypeInfo.getPropertyName(method)) == null) continue;
            PojoPropertyInfo property = (PojoPropertyInfo)properties.get(propertyName);
            if (property == null) {
                property = new PojoPropertyInfo(propertyName);
                properties.put(property.getName(), property);
            }
            property.getMethods().add(method);
        }
        if (superTypeInfo != null) {
            for (Map.Entry entry : superTypeInfo._properties.entrySet()) {
                PojoPropertyInfo superProperty = (PojoPropertyInfo)entry.getValue();
                PojoPropertyInfo property = (PojoPropertyInfo)properties.get(superProperty.getName());
                if (property == null) {
                    property = new PojoPropertyInfo(superProperty.getName());
                    properties.put(property.getName(), property);
                }
                property.getMethods().addAll(superProperty.getMethods());
            }
        }
        for (Map.Entry entry : properties.entrySet()) {
            ((PojoPropertyInfo)entry.getValue()).calculateAccessors();
        }
        return properties;
    }

    private static String getPropertyName(Method method) {
        String methodName = method.getName();
        int numOfParameters = method.getParameterTypes().length;
        if (numOfParameters == 0) {
            Class<?> returnType = method.getReturnType();
            if (returnType == Void.TYPE) {
                return null;
            }
            if (StringUtils.isStrictPrefix(methodName, PREFIX_GET)) {
                return PojoTypeInfo.extractPropertyName(methodName, PREFIX_GET);
            }
            if (StringUtils.isStrictPrefix(methodName, PREFIX_IS) && (returnType == Boolean.TYPE || returnType == Boolean.class)) {
                return PojoTypeInfo.extractPropertyName(methodName, PREFIX_IS);
            }
        } else if (numOfParameters == 1 && StringUtils.isStrictPrefix(methodName, PREFIX_SET)) {
            return PojoTypeInfo.extractPropertyName(methodName, PREFIX_SET);
        }
        return null;
    }

    private static String extractPropertyName(String methodName, String prefix) {
        int prefixLength = prefix.length();
        if (methodName.length() > prefixLength + 1 && Character.isUpperCase(methodName.charAt(prefixLength + 1)) && Character.isUpperCase(methodName.charAt(prefixLength))) {
            return methodName.substring(prefixLength);
        }
        return Character.toLowerCase(methodName.charAt(prefixLength)) + methodName.substring(prefixLength + 1);
    }
}

