/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.naming;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.naming.INamingService;
import com.j_spaces.core.client.LookupFinder;
import com.j_spaces.core.jini.SharedDiscoveryManagement;
import com.j_spaces.core.service.AbstractService;
import java.rmi.RemoteException;
import net.jini.admin.Administrable;
import net.jini.admin.JoinAdmin;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.ServiceDiscoveryManager;
import net.jini.lookup.ServiceItemFilter;

@InternalApi
public class LookupNamingService
implements INamingService {
    private ServiceDiscoveryManager _serviceDiscoveryManager;

    public LookupNamingService(LookupDiscoveryManager discoveryManager, LeaseRenewalManager renewalManager) throws RemoteException {
        try {
            this._serviceDiscoveryManager = SharedDiscoveryManagement.getBackwardsServiceDiscoveryManager(discoveryManager.getGroups(), discoveryManager.getLocators(), null);
        }
        catch (Exception ex) {
            throw new RemoteException("Failed to initialize LookupNamingService.", ex);
        }
    }

    @Override
    public ServiceItem[] lookup(ServiceTemplate srvTemplate, int maxMatches, ServiceItemFilter filter) {
        ServiceRegistrar[] registrars;
        LookupFinder.sortLookupAttributes(srvTemplate.attributeSetTemplates);
        ServiceItem[] serviceItems = this._serviceDiscoveryManager.lookup(srvTemplate, maxMatches, filter);
        if (serviceItems.length == 0 && (registrars = this._serviceDiscoveryManager.getDiscoveryManager().getRegistrars()).length == 0) {
            return null;
        }
        return serviceItems;
    }

    @Override
    public Entry[] getLookupAttributes(Object service) throws RemoteException {
        return this.getJoinAdmin(service).getLookupAttributes();
    }

    @Override
    public void modifyNamingAttributes(Object service, Entry[] attrSetTemplates, Entry[] attrSets) throws RemoteException {
        JoinAdmin joinAdmin = this.getJoinAdmin(service);
        if (joinAdmin instanceof AbstractService) {
            ((AbstractService)joinAdmin).modifyLookupAttributes(attrSetTemplates, attrSets);
        } else {
            joinAdmin.modifyLookupAttributes(attrSetTemplates, attrSets);
        }
    }

    @Override
    public void addNamingAttributes(Object service, Entry[] attrSets) throws RemoteException {
        JoinAdmin joinAdmin = this.getJoinAdmin(service);
        if (joinAdmin instanceof AbstractService) {
            ((AbstractService)joinAdmin).addLookupAttributes(attrSets);
        } else {
            joinAdmin.addLookupAttributes(attrSets);
        }
    }

    @Override
    public int getNumberOfRegistrars() {
        return this._serviceDiscoveryManager.getDiscoveryManager().getRegistrars().length;
    }

    @Override
    public String getName() {
        return "Jini Lookup Service";
    }

    @Override
    public void terminate() {
        this._serviceDiscoveryManager.terminate();
    }

    private JoinAdmin getJoinAdmin(Object service) throws RemoteException {
        Object joinObj;
        if (service instanceof Administrable) {
            joinObj = ((Administrable)service).getAdmin();
            if (!(joinObj instanceof JoinAdmin)) {
                throw new IllegalArgumentException("Failed to get JoinAdmin. Service: " + service.getClass().getName() + " must implement " + JoinAdmin.class.getName() + " interface.");
            }
        } else {
            throw new IllegalArgumentException("Failed to get Administrable. Service: " + service.getClass().getName() + " must implement " + Administrable.class.getName() + " interface.");
        }
        JoinAdmin joinAdmin = (JoinAdmin)joinObj;
        return joinAdmin;
    }

    @Override
    public LookupCache notify(ServiceTemplate tmpl, ServiceItemFilter filter, ServiceDiscoveryListener listener) throws RemoteException {
        LookupFinder.sortLookupAttributes(tmpl.attributeSetTemplates);
        return this._serviceDiscoveryManager.createLookupCache(tmpl, filter, listener);
    }

    public ServiceDiscoveryManager getServiceDiscoveryManager() {
        return this._serviceDiscoveryManager;
    }
}

