/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.internal.metadata.TypeDesc;
import com.gigaspaces.internal.query.ICustomQuery;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.serialization.IllegalSerializationVersionException;
import com.gigaspaces.server.ServerEntry;
import com.j_spaces.core.cache.CacheManager;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractCustomQuery
implements ICustomQuery,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final byte GigaspacesVersionID = 1;
    private List<IQueryIndexScanner> _customIndexes = new LinkedList<IQueryIndexScanner>();

    @Override
    public abstract boolean matches(CacheManager var1, ServerEntry var2, String var3);

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        if (version != 1) {
            switch (version) {
                default: 
            }
            throw new IllegalSerializationVersionException(TypeDesc.class, version);
        }
        this.readExternalV1(in);
    }

    public void addCustomIndex(IQueryIndexScanner customIndex) {
        this._customIndexes.add(customIndex);
    }

    @Override
    public List<IQueryIndexScanner> getCustomIndexes() {
        return this._customIndexes;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        this.writeExternalV1(out);
    }

    private void readExternalV1(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean hasCustomIndex = in.readBoolean();
        if (hasCustomIndex) {
            this._customIndexes = (List)in.readObject();
        }
    }

    private void writeExternalV1(ObjectOutput out) throws IOException {
        if (this._customIndexes != null) {
            out.writeBoolean(true);
            out.writeObject(this._customIndexes);
        } else {
            out.writeBoolean(false);
        }
    }
}

