/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.query.explainplan.ExplainPlanUtil;
import com.gigaspaces.internal.query.explainplan.IndexChoiceNode;
import com.gigaspaces.internal.query.explainplan.IndexInfo;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.list.IObjectsList;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class AbstractQueryIndex
implements IQueryIndexScanner {
    private static final long serialVersionUID = -4783385338736231377L;
    private String _indexName;

    public AbstractQueryIndex() {
    }

    public AbstractQueryIndex(String indexName) {
        if (indexName == null) {
            throw new IllegalArgumentException("Index name can not be null");
        }
        this._indexName = indexName;
    }

    @Override
    public String getIndexName() {
        return this._indexName;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._indexName = IOUtils.readString(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeString(out, this._indexName);
    }

    @Override
    public boolean supportsFifoOrder() {
        return false;
    }

    @Override
    public IObjectsList getIndexedEntriesByType(Context context, TypeData typeData, ITemplateHolder template, int latestIndexToConsider) {
        IQueryIndexScanner.ResultIndicator resultIndicator = null;
        TypeDataIndex<Object> index = typeData.getIndex(this.getIndexName());
        if (index == null) {
            resultIndicator = IQueryIndexScanner.RESULT_IGNORE_INDEX;
        } else if (latestIndexToConsider < index.getIndexCreationNumber()) {
            resultIndicator = IQueryIndexScanner.RESULT_IGNORE_INDEX;
        } else if (template.isFifoTemplate() && !this.supportsFifoOrder()) {
            resultIndicator = IQueryIndexScanner.RESULT_IGNORE_INDEX;
        } else if (this.requiresOrderedIndex() && index.getExtendedIndexForScanning() == null) {
            resultIndicator = IQueryIndexScanner.RESULT_IGNORE_INDEX;
        } else if (this.requiresValueForIndexSearch() && !this.hasIndexValue()) {
            resultIndicator = IQueryIndexScanner.RESULT_IGNORE_INDEX;
        } else if (template.isFifoGroupPoll() && !index.isFifoGroupsMainIndex() && (context.isFifoGroupQueryContainsOrCondition() || this.requiresOrderedIndex())) {
            resultIndicator = IQueryIndexScanner.RESULT_IGNORE_INDEX;
        }
        if (resultIndicator != null) {
            if (context.getExplainPlanContext() != null) {
                IndexChoiceNode choiceNode = context.getExplainPlanContext().getFatherNode();
                IndexInfo indexInfo = ExplainPlanUtil.createIndexInfo(this, index, typeData, -1, false);
                choiceNode.addOption(indexInfo);
            }
            return resultIndicator;
        }
        IObjectsList entriesByIndex = this.getEntriesByIndex(context, typeData, index, template.isFifoGroupPoll());
        if (context.getExplainPlanContext() != null) {
            IndexChoiceNode choiceNode = context.getExplainPlanContext().getFatherNode();
            if (choiceNode == null) {
                choiceNode = new IndexChoiceNode(this.inferIndexScannerName());
                context.getExplainPlanContext().getSingleExplainPlan().addScanIndexChoiceNode(typeData.getClassName(), choiceNode);
                context.getExplainPlanContext().setFatherNode(choiceNode);
            }
            int size = entriesByIndex == null ? 0 : (entriesByIndex instanceof IStoredList ? ((IStoredList)entriesByIndex).size() : -1);
            IndexInfo info = ExplainPlanUtil.createIndexInfo(this, index, typeData, size, true);
            choiceNode.addOption(info);
            choiceNode.setChosen(info);
        }
        return entriesByIndex;
    }

    private String inferIndexScannerName() {
        String simpleName = this.getClass().getSimpleName();
        return simpleName.substring(0, simpleName.indexOf("Index"));
    }

    public boolean requiresValueForIndexSearch() {
        return true;
    }

    protected abstract boolean hasIndexValue();

    protected abstract IObjectsList getEntriesByIndex(Context var1, TypeData var2, TypeDataIndex<Object> var3, boolean var4);

    @Override
    public boolean isUidsScanner() {
        return false;
    }
}

