/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.ICustomQuery;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.query.predicate.ISpacePredicate;
import com.gigaspaces.query.ISpaceQuery;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractSpaceQuery<T>
implements ISpaceQuery<T>,
ICustomQuery,
Externalizable {
    private static final long serialVersionUID = 537740993667475544L;
    private String _entryTypeName;
    private ISpacePredicate _predicate;
    private List<IQueryIndexScanner> _customIndexes = new LinkedList<IQueryIndexScanner>();

    protected AbstractSpaceQuery() {
    }

    protected AbstractSpaceQuery(String entryTypeName, ISpacePredicate predicate) {
        this._entryTypeName = entryTypeName;
        this._predicate = predicate;
    }

    protected AbstractSpaceQuery(Class<?> entryClass, ISpacePredicate predicate) {
        this._entryTypeName = entryClass.getName();
        this._predicate = predicate;
    }

    public String getEntryTypeName() {
        return this._entryTypeName;
    }

    public ISpacePredicate getPredicate() {
        return this._predicate;
    }

    public void addCustomIndex(IQueryIndexScanner customIndex) {
        this._customIndexes.add(customIndex);
    }

    @Override
    public List<IQueryIndexScanner> getCustomIndexes() {
        return this._customIndexes;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._entryTypeName = IOUtils.readString(in);
        this._predicate = (ISpacePredicate)in.readObject();
        boolean hasCustomIndex = in.readBoolean();
        if (hasCustomIndex) {
            this._customIndexes = (List)in.readObject();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeString(out, this._entryTypeName);
        out.writeObject(this._predicate);
        if (this._customIndexes != null) {
            out.writeBoolean(true);
            out.writeObject(this._customIndexes);
        } else {
            out.writeBoolean(false);
        }
    }
}

