/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.TypeDesc;
import com.gigaspaces.internal.query.AbstractCompundCustomQuery;
import com.gigaspaces.internal.query.ICustomQuery;
import com.gigaspaces.serialization.IllegalSerializationVersionException;
import com.gigaspaces.server.ServerEntry;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.client.SQLQuery;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;

@InternalApi
public class CompoundAndCustomQuery
extends AbstractCompundCustomQuery {
    private static final long serialVersionUID = 1L;
    private static final byte GigaspacesVersionID = 1;

    public CompoundAndCustomQuery() {
    }

    public CompoundAndCustomQuery(List<ICustomQuery> subQueries) {
        this._subQueries = subQueries;
    }

    @Override
    public boolean matches(CacheManager cacheManager, ServerEntry entry, String skipAlreadyMatchedIndexPath) {
        int length = this._subQueries.size();
        for (int i = 0; i < length; ++i) {
            if (((ICustomQuery)this._subQueries.get(i)).matches(cacheManager, entry, skipAlreadyMatchedIndexPath)) continue;
            return false;
        }
        return true;
    }

    @Override
    public SQLQuery toSQLQuery(ITypeDesc typeDesc) {
        LinkedList<Object> preparedValues = new LinkedList<Object>();
        StringBuilder b = new StringBuilder();
        for (ICustomQuery query : this._subQueries) {
            SQLQuery sqlQuery = query.toSQLQuery(typeDesc);
            if (b.length() > 0) {
                b.append(" and ");
            }
            b.append(sqlQuery.getQuery());
            if (sqlQuery.getParameters() == null) continue;
            for (int i = 0; i < sqlQuery.getParameters().length; ++i) {
                preparedValues.add(sqlQuery.getParameters()[i]);
            }
        }
        return new SQLQuery(typeDesc.getTypeName(), b.toString(), preparedValues.toArray());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte version = in.readByte();
        if (version != 1) {
            switch (version) {
                default: 
            }
            throw new IllegalSerializationVersionException(TypeDesc.class, version);
        }
        this.readExternalV1(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(1);
        this.writeExternalV1(out);
    }

    private void readExternalV1(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    private void writeExternalV1(ObjectOutput out) throws IOException {
    }
}

