/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.query.AbstractCompoundIndexScanner;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.query.explainplan.IndexChoiceNode;
import com.gigaspaces.internal.query.explainplan.IndexInfo;
import com.gigaspaces.internal.query.explainplan.UnionIndexInfo;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.kernel.ICollection;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.list.IObjectsList;
import com.j_spaces.kernel.list.IScanListIterator;
import com.j_spaces.kernel.list.MultiIntersectedStoredList;
import com.j_spaces.kernel.list.ScanUidsIterator;
import java.util.List;

@InternalApi
public class CompoundAndIndexScanner
extends AbstractCompoundIndexScanner {
    private static final long serialVersionUID = 1L;

    public CompoundAndIndexScanner() {
    }

    public CompoundAndIndexScanner(List<IQueryIndexScanner> indexScanners) {
        super(indexScanners);
    }

    @Override
    public String getIndexName() {
        return null;
    }

    @Override
    public Object getIndexValue() {
        return null;
    }

    @Override
    public boolean requiresOrderedIndex() {
        return false;
    }

    @Override
    public boolean supportsFifoOrder() {
        return false;
    }

    @Override
    public boolean supportsTemplateIndex() {
        return false;
    }

    @Override
    public IObjectsList getIndexedEntriesByType(Context context, TypeData typeData, ITemplateHolder template, int latestIndexToConsider) {
        boolean isExplainPlan;
        ICollection shortestPotentialMatchList = null;
        IScanListIterator shortestExtendedIndexMatch = null;
        MultiIntersectedStoredList<IEntryCacheInfo> intersectedList = null;
        ScanUidsIterator uidsIter = null;
        int uidsSize = Integer.MAX_VALUE;
        IndexChoiceNode fatherNode = null;
        IndexChoiceNode choiceNode = null;
        String shortestIndexName = "";
        boolean bl = isExplainPlan = context.getExplainPlanContext() != null;
        if (isExplainPlan) {
            fatherNode = context.getExplainPlanContext().getFatherNode();
            choiceNode = new IndexChoiceNode("AND");
            context.getExplainPlanContext().getSingleExplainPlan().addScanIndexChoiceNode(typeData.getClassName(), choiceNode);
        }
        for (IQueryIndexScanner queryIndex : this.indexScanners) {
            int potentialMatchListSize;
            IObjectsList result;
            if (isExplainPlan) {
                IndexChoiceNode prevFather = context.getExplainPlanContext().getFatherNode();
                context.getExplainPlanContext().setFatherNode(choiceNode);
                result = queryIndex.getIndexedEntriesByType(context, typeData, template, latestIndexToConsider);
                context.getExplainPlanContext().setFatherNode(prevFather);
            } else {
                result = queryIndex.getIndexedEntriesByType(context, typeData, template, latestIndexToConsider);
            }
            if (result == IQueryIndexScanner.RESULT_IGNORE_INDEX) {
                context.setBlobStoreUsePureIndexesAccess(false);
                continue;
            }
            if (result == IQueryIndexScanner.RESULT_NO_MATCH) {
                return null;
            }
            if (result != null && result.isIterator()) {
                boolean wasUids;
                boolean bl2 = wasUids = uidsIter != null;
                if (wasUids && !context.isIndicesIntersectionEnabled()) continue;
                if (!wasUids && queryIndex.isUidsScanner()) {
                    uidsIter = (ScanUidsIterator)result;
                    uidsSize = uidsIter.size();
                }
                if (context.isIndicesIntersectionEnabled()) {
                    intersectedList = this.addToIntersectedList(context, intersectedList, result, template.isFifoTemplate(), false, typeData);
                }
                if (wasUids) continue;
                shortestExtendedIndexMatch = (IScanListIterator)result;
                if (!isExplainPlan) continue;
                shortestIndexName = queryIndex.getIndexName();
                continue;
            }
            IStoredList potentialMatchList = (IStoredList)result;
            int n = potentialMatchListSize = potentialMatchList == null ? 0 : potentialMatchList.size();
            if (potentialMatchListSize == 0) {
                if (isExplainPlan) {
                    fatherNode.addOption(choiceNode.getChosen());
                }
                return IQueryIndexScanner.RESULT_NO_MATCH;
            }
            if (context.isIndicesIntersectionEnabled()) {
                intersectedList = this.addToIntersectedList(context, intersectedList, potentialMatchList, template.isFifoTemplate(), false, typeData);
            }
            if (shortestPotentialMatchList == null || potentialMatchListSize <= shortestPotentialMatchList.size()) {
                shortestPotentialMatchList = potentialMatchList;
                if (isExplainPlan) {
                    shortestIndexName = queryIndex.getIndexName();
                }
            }
            if (shortestPotentialMatchList.isMultiObjectCollection() || context.isIndicesIntersectionEnabled()) continue;
            break;
        }
        if (shortestPotentialMatchList != null && (uidsSize == Integer.MAX_VALUE || shortestPotentialMatchList.size() <= uidsSize)) {
            if (context.isIndicesIntersectionEnabled()) {
                intersectedList = this.addToIntersectedList(context, intersectedList, (IObjectsList)((Object)shortestPotentialMatchList), template.isFifoTemplate(), true, typeData);
                if (shortestExtendedIndexMatch != null) {
                    intersectedList = this.addToIntersectedList(context, intersectedList, shortestExtendedIndexMatch, template.isFifoTemplate(), false, typeData);
                }
                return intersectedList;
            }
            if (isExplainPlan) {
                this.addChosenIndex(context, typeData, fatherNode, choiceNode, shortestIndexName);
            }
            return shortestPotentialMatchList;
        }
        if (shortestExtendedIndexMatch != null) {
            if (context.isIndicesIntersectionEnabled()) {
                intersectedList = this.addToIntersectedList(context, intersectedList, shortestExtendedIndexMatch, template.isFifoTemplate(), true, typeData);
                return intersectedList;
            }
            if (isExplainPlan) {
                this.addChosenIndex(context, typeData, fatherNode, choiceNode, shortestIndexName);
            }
            return shortestExtendedIndexMatch;
        }
        if (isExplainPlan) {
            choiceNode.setChosen(choiceNode.getOptions().get(0));
            fatherNode.addOption(choiceNode.getOptions().get(0));
            fatherNode.setChosen(new UnionIndexInfo(fatherNode.getOptions()));
        }
        return IQueryIndexScanner.RESULT_IGNORE_INDEX;
    }

    private void addChosenIndex(Context context, TypeData typeData, IndexChoiceNode fatherNode, IndexChoiceNode choiceNode, String shortestIndexName) {
        IndexInfo chosen = context.getExplainPlanContext().getSingleExplainPlan().getLatestIndexChoiceNode(typeData.getClassName()).getOptionByName(shortestIndexName);
        choiceNode.setChosen(chosen);
        fatherNode.addOption(chosen);
    }

    private MultiIntersectedStoredList<IEntryCacheInfo> addToIntersectedList(Context context, MultiIntersectedStoredList<IEntryCacheInfo> intersectedList, IObjectsList list, boolean fifoScan, boolean shortest, TypeData typeData) {
        if (intersectedList == null) {
            intersectedList = new MultiIntersectedStoredList(context, list, fifoScan, typeData.getEntries(), !context.isBlobStoreUsePureIndexesAccess());
        } else {
            intersectedList.add(list, shortest);
        }
        return intersectedList;
    }

    public Object getEntriesByIndex(TypeDataIndex<Object> index) {
        throw new UnsupportedOperationException();
    }
}

