/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.ShortList;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.AbstractTypeIntrospector;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.SpacePropertyInfo;
import com.gigaspaces.internal.metadata.TypeDesc;
import com.gigaspaces.internal.query.AbstractCustomQuery;
import com.gigaspaces.internal.query.IContainsItemsCustomQuery;
import com.gigaspaces.serialization.IllegalSerializationVersionException;
import com.gigaspaces.server.ServerEntry;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.client.SQLQuery;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@InternalApi
public class CompoundContainsItemsCustomQuery
extends AbstractCustomQuery
implements IContainsItemsCustomQuery {
    private static final long serialVersionUID = 1L;
    private static final byte GigaspacesVersionID = 1;
    private List<IContainsItemsCustomQuery> _subQueries;
    String _rootPath;
    boolean _isTop;
    protected transient String[] _tokens = null;
    protected transient SpacePropertyInfo[] _propertyInfo = null;
    protected transient short[] _containsIndexes;

    public CompoundContainsItemsCustomQuery(String rootPath, String fullPath, List<IContainsItemsCustomQuery> subQueries) {
        this._rootPath = rootPath;
        this._isTop = rootPath.equals(fullPath);
        if (subQueries.isEmpty()) {
            throw new RuntimeException("no sub-queries for contains root " + fullPath);
        }
        this._subQueries = subQueries;
    }

    public CompoundContainsItemsCustomQuery() {
    }

    public List<IContainsItemsCustomQuery> getSubQueries() {
        return this._subQueries;
    }

    @Override
    public SQLQuery toSQLQuery(ITypeDesc typeDesc) {
        return new SQLQuery<String>(typeDesc.getTypeName(), "");
    }

    @Override
    public boolean matches(ServerEntry entry, Object collectionItem) {
        if (this._isTop) {
            throw new IllegalArgumentException("cannot call matches on top root with collection item");
        }
        if (this._tokens == null || this._containsIndexes == null || this._propertyInfo == null) {
            this.initialize();
        }
        return this.performMatching(collectionItem, 0, 0, entry);
    }

    @Override
    public boolean matches(CacheManager cacheManager, ServerEntry entry, String skipAlreadyMatchedIndexPath) {
        Object value;
        if (!this._isTop) {
            throw new IllegalArgumentException("cannot call matches on top root with collection item");
        }
        if (this._tokens == null || this._containsIndexes == null || this._propertyInfo == null) {
            this.initialize();
        }
        return (value = entry.getPropertyValue(this._tokens[0])) == null ? false : this.performMatching(value, 1, 0, entry);
    }

    private boolean performMatching(Object value, int tokenIndex, int currentContainsIndex, ServerEntry entry) {
        while (tokenIndex != this._containsIndexes[currentContainsIndex]) {
            if ((value = AbstractTypeIntrospector.getNestedValue(value, tokenIndex++, this._tokens, this._propertyInfo, this._rootPath)) != null) continue;
            return false;
        }
        if (value instanceof Object[]) {
            value = Arrays.asList((Object[])value);
        } else if (!(value instanceof Collection)) {
            throw new IllegalArgumentException("[*] can only follow a Collection or Object Array. '" + this._tokens[tokenIndex - 1] + "' is not a collection or array in '" + this._rootPath + "'");
        }
        if (this._containsIndexes.length == ++currentContainsIndex) {
            return this.matchValue((Collection)value, tokenIndex, entry);
        }
        for (Object item : (Collection)value) {
            if (item == null || !this.performMatching(item, tokenIndex, currentContainsIndex, entry)) continue;
            return true;
        }
        return false;
    }

    private boolean matchValue(Collection<?> collection, int tokenIndex, ServerEntry entry) {
        if (tokenIndex == this._tokens.length) {
            return this.matchOnRoot(collection, entry);
        }
        throw new RuntimeException("invalid root path: " + this._rootPath + " - should end with a collection");
    }

    private boolean matchOnRoot(Collection<?> collection, ServerEntry entry) {
        for (Object item : collection) {
            if (item == null) continue;
            boolean res = true;
            for (IContainsItemsCustomQuery q : this._subQueries) {
                if (q.matches(entry, item)) continue;
                res = false;
                break;
            }
            if (!res) continue;
            return true;
        }
        return false;
    }

    private void initialize() {
        String[] temp = this._rootPath.split("\\.|\\[\\*\\]", -1);
        ArrayList<String> tokens = new ArrayList<String>();
        ShortList containsIndexes = CollectionsFactory.getInstance().createShortList();
        short tokenIndex = 0;
        for (String token : temp) {
            if (token.length() == 0) {
                containsIndexes.add(tokenIndex);
                continue;
            }
            tokens.add(token);
            tokenIndex = (short)(tokenIndex + 1);
        }
        this._tokens = tokens.toArray(new String[tokens.size()]);
        this._containsIndexes = containsIndexes.toNativeArray();
        this._propertyInfo = new SpacePropertyInfo[this._tokens.length];
    }

    @Override
    public boolean isRootHandler() {
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte version = in.readByte();
        if (version != 1) {
            switch (version) {
                default: 
            }
            throw new IllegalSerializationVersionException(TypeDesc.class, version);
        }
        this.readExternalV1(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(1);
        this.writeExternalV1(out);
    }

    private void readExternalV1(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            this._rootPath = IOUtils.readString(in);
        }
        this._isTop = in.readBoolean();
        this._subQueries = (List)in.readObject();
    }

    private void writeExternalV1(ObjectOutput out) throws IOException {
        if (this._rootPath != null) {
            out.writeBoolean(true);
            IOUtils.writeString(out, this._rootPath);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this._isTop);
        out.writeObject(this._subQueries);
    }
}

