/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.ObjectConverter;
import com.j_spaces.core.cache.CompoundCustomTypeDataIndex;
import com.j_spaces.core.cache.CompoundIndexSegmentTypeData;
import com.j_spaces.core.cache.CompoundIndexValueHolder;
import com.j_spaces.core.cache.TypeDataIndex;
import java.sql.SQLException;
import net.jini.space.InternalSpaceException;

@InternalApi
public class CompoundConvertedObjectWrapper {
    Object _convertedObject;

    private CompoundConvertedObjectWrapper(Object value) {
        this._convertedObject = value;
    }

    public Object getValue() {
        return this._convertedObject;
    }

    public static CompoundConvertedObjectWrapper create(Object[] segmentValues, TypeDataIndex<Object> index) {
        try {
            if (segmentValues == null) {
                return new CompoundConvertedObjectWrapper(null);
            }
            Object[] convertedSegments = new Object[segmentValues.length];
            for (int i = 0; i < segmentValues.length; ++i) {
                convertedSegments[i] = CompoundConvertedObjectWrapper.convertSegmentValue(segmentValues[i], index.getCompoundIndexSegments()[i]);
                if (convertedSegments[i] != null) continue;
                return null;
            }
            return new CompoundConvertedObjectWrapper(new CompoundIndexValueHolder(convertedSegments));
        }
        catch (SQLException e) {
            throw new InternalSpaceException(e.getMessage(), e);
        }
    }

    public static CompoundConvertedObjectWrapper createForExtendedMatch(Object[] segmentValues, TypeDataIndex<Object> index, boolean isMin, boolean includeEdge, boolean includeEdgeFirstSegment) {
        try {
            Object convertedSeg1 = null;
            Object convertedSeg2 = null;
            if (segmentValues == null) {
                return new CompoundConvertedObjectWrapper(null);
            }
            Object[] convertedSegments = new Object[segmentValues.length];
            for (int i = 0; i < segmentValues.length; ++i) {
                if (i > 0 && !includeEdgeFirstSegment) {
                    convertedSegments[i] = isMin ? CompoundCustomTypeDataIndex._highEdge : CompoundCustomTypeDataIndex._lowEdge;
                    continue;
                }
                convertedSegments[i] = CompoundConvertedObjectWrapper.convertSegmentValue(segmentValues[i], index.getCompoundIndexSegments()[i]);
                if (convertedSegments[i] != null) continue;
                return null;
            }
            int matchCode = isMin ? (includeEdge ? 3 : 2) : (includeEdge ? 5 : 2);
            return new CompoundConvertedObjectWrapper(new CompoundIndexValueHolder(convertedSegments));
        }
        catch (SQLException e) {
            throw new InternalSpaceException(e.getMessage(), e);
        }
    }

    private static Object convertSegmentValue(Object value, CompoundIndexSegmentTypeData segment) throws SQLException {
        if (value == null || !(value instanceof String)) {
            return value;
        }
        Class<?> type = segment.getValueType();
        if (type == null) {
            return null;
        }
        return ObjectConverter.convert(value, type);
    }
}

