/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.AbstractCompundCustomQuery;
import com.gigaspaces.internal.query.ICustomQuery;
import com.gigaspaces.server.ServerEntry;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.client.SQLQuery;
import java.util.LinkedList;
import java.util.List;

@InternalApi
public class CompoundOrCustomQuery
extends AbstractCompundCustomQuery {
    private static final long serialVersionUID = 1L;

    public CompoundOrCustomQuery() {
    }

    public CompoundOrCustomQuery(List<ICustomQuery> subQueries) {
        this._subQueries = subQueries;
    }

    @Override
    public boolean matches(CacheManager cacheManager, ServerEntry entry, String skipAlreadyMatchedIndexPath) {
        int length = this._subQueries.size();
        for (int i = 0; i < length; ++i) {
            if (!((ICustomQuery)this._subQueries.get(i)).matches(cacheManager, entry, skipAlreadyMatchedIndexPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SQLQuery toSQLQuery(ITypeDesc typeDesc) {
        LinkedList<Object> preparedValues = new LinkedList<Object>();
        StringBuilder b = new StringBuilder();
        for (ICustomQuery query : this._subQueries) {
            SQLQuery sqlQuery = query.toSQLQuery(typeDesc);
            if (b.length() > 0) {
                b.append(" or ");
            }
            b.append(sqlQuery.getQuery());
            if (sqlQuery.getParameters() == null) continue;
            for (int i = 0; i < sqlQuery.getParameters().length; ++i) {
                preparedValues.add(sqlQuery.getParameters()[i]);
            }
        }
        return new SQLQuery(typeDesc.getTypeName(), b.toString(), preparedValues.toArray());
    }
}

