/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.query.AbstractCompoundIndexScanner;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.query.explainplan.ExplainPlanContext;
import com.gigaspaces.internal.query.explainplan.IndexChoiceNode;
import com.gigaspaces.internal.query.explainplan.UnionIndexInfo;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.kernel.list.IObjectsList;
import com.j_spaces.kernel.list.MultiStoredList;

@InternalApi
public class CompoundOrIndexScanner
extends AbstractCompoundIndexScanner {
    private static final long serialVersionUID = 1L;

    @Override
    public String getIndexName() {
        return null;
    }

    @Override
    public Object getIndexValue() {
        return null;
    }

    @Override
    public boolean requiresOrderedIndex() {
        return true;
    }

    @Override
    public boolean supportsFifoOrder() {
        return false;
    }

    @Override
    public boolean supportsTemplateIndex() {
        return false;
    }

    @Override
    public IObjectsList getIndexedEntriesByType(Context context, TypeData typeData, ITemplateHolder template, int latestIndexToConsider) {
        if (template.isFifoTemplate() && !this.supportsFifoOrder()) {
            return IQueryIndexScanner.RESULT_IGNORE_INDEX;
        }
        MultiStoredList unionList = new MultiStoredList();
        if (template.isFifoGroupPoll()) {
            context.setFifoGroupQueryContainsOrCondition(true);
        }
        IndexChoiceNode choiceNode = null;
        if (context.getExplainPlanContext() != null) {
            choiceNode = new IndexChoiceNode("OR");
            ExplainPlanContext explainPlanContext = context.getExplainPlanContext();
            explainPlanContext.getSingleExplainPlan().addScanIndexChoiceNode(typeData.getClassName(), choiceNode);
            explainPlanContext.setFatherNode(choiceNode);
        }
        for (IQueryIndexScanner indexScanner : this.indexScanners) {
            IObjectsList indexResult = indexScanner.getIndexedEntriesByType(context, typeData, template, latestIndexToConsider);
            if (indexResult == IQueryIndexScanner.RESULT_IGNORE_INDEX) {
                context.setBlobStoreUsePureIndexesAccess(false);
                return indexResult;
            }
            if (indexResult == IQueryIndexScanner.RESULT_NO_MATCH || indexResult == null) continue;
            unionList.add(indexResult);
        }
        if (context.getExplainPlanContext() != null) {
            choiceNode.setChosen(new UnionIndexInfo(choiceNode.getOptions()));
        }
        return unionList;
    }

    public void add(IQueryIndexScanner customIndex) {
        this.indexScanners.add(customIndex);
    }

    public Object getEntriesByIndex(TypeDataIndex<Object> index) {
        throw new UnsupportedOperationException();
    }
}

