/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.RawEntry;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.transport.EntryPacketFactory;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregator;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregatorContext;
import java.util.List;

@InternalApi
public class EntryHolderAggregatorContext
extends SpaceEntriesAggregatorContext {
    private final ITemplateHolder template;
    private final int partitionId;
    private IEntryData entryData;
    private String uid;
    private boolean isTransient;

    public EntryHolderAggregatorContext(List<SpaceEntriesAggregator> aggregators, ITemplateHolder template, int partitionId) {
        super(aggregators);
        this.template = template;
        this.partitionId = partitionId;
    }

    public void scan(IEntryData entryData, String uid, boolean isTransient) {
        this.entryData = entryData;
        this.uid = uid;
        this.isTransient = isTransient;
        this.aggregate();
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public String getEntryUid() {
        return this.uid;
    }

    @Override
    public RawEntry getRawEntry() {
        return EntryPacketFactory.createFullPacket(this.template, this.entryData, this.uid, this.isTransient);
    }

    @Override
    public void applyProjectionTemplate(RawEntry entry) {
        if (this.template.getProjectionTemplate() != null) {
            this.template.getProjectionTemplate().filterOutNonProjectionProperties((IEntryPacket)entry);
        }
    }

    @Override
    protected Object getPathValueImpl(String path) {
        ITypeDesc typeDesc = this.entryData.getEntryTypeDesc().getTypeDesc();
        if (typeDesc.isAutoGenerateId() && typeDesc.getIdPropertyName().equals(path)) {
            return this.uid;
        }
        return this.entryData.getPathValue(path);
    }
}

