/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.query.CompoundConvertedObjectWrapper;
import com.gigaspaces.internal.query.ExactValueIndexScanner;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.jdbc.builder.range.EqualValueRange;
import com.j_spaces.jdbc.builder.range.Range;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.list.IObjectsList;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.InvalidParameterException;
import java.util.List;

@InternalApi
public class ExacValueCompoundIndexScanner
extends ExactValueIndexScanner {
    private static final long serialVersionUID = 1L;
    private transient CompoundConvertedObjectWrapper _convertedValueWrapper;

    public ExacValueCompoundIndexScanner() {
    }

    public ExacValueCompoundIndexScanner(String indexName, Object[] segmentValues) {
        super(indexName, segmentValues);
        if (segmentValues.length <= 1) {
            throw new InvalidParameterException();
        }
    }

    @Override
    protected IObjectsList getEntriesByIndex(Context context, TypeData typeData, TypeDataIndex<Object> index, boolean fifoGroupsScan) {
        Object[] segmentValues = (Object[])this.getIndexValue();
        if (this._convertedValueWrapper == null) {
            this._convertedValueWrapper = CompoundConvertedObjectWrapper.create(segmentValues, index);
        }
        if (this._convertedValueWrapper == null) {
            return null;
        }
        IStoredList<IEntryCacheInfo> res = index.getIndexEntries(this._convertedValueWrapper.getValue());
        if (fifoGroupsScan && res != null) {
            context.setFifoGroupIndexUsedInFifoGroupScan(res, index);
        }
        return res;
    }

    @Override
    public boolean requiresOrderedIndex() {
        return false;
    }

    @Override
    protected boolean hasIndexValue() {
        return this.getIndexValue() != null;
    }

    @Override
    public boolean supportsFifoOrder() {
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    @Override
    public boolean supportsTemplateIndex() {
        return false;
    }

    public static ExacValueCompoundIndexScanner build(String name, List<Range> possibleSegments) {
        Object[] values = new Object[possibleSegments.size()];
        for (int i = 0; i < values.length; ++i) {
            if (!possibleSegments.get(i).isEqualValueRange()) {
                return null;
            }
            values[i] = ((EqualValueRange)possibleSegments.get(i)).getValue();
            if (values[i] != null) continue;
            return null;
        }
        return new ExacValueCompoundIndexScanner(name, values);
    }
}

