/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.query.AbstractQueryIndex;
import com.gigaspaces.internal.query.ConvertedObjectWrapper;
import com.gigaspaces.internal.query.explainplan.IndexChoiceNode;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.kernel.list.IObjectsList;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class ExactValueIndexScanner
extends AbstractQueryIndex {
    private static final long serialVersionUID = -2127730673864716510L;
    private Object _indexValue;
    private transient ConvertedObjectWrapper _convertedValueWrapper;

    public ExactValueIndexScanner() {
    }

    public ExactValueIndexScanner(String indexName, Object indexValue) {
        super(indexName);
        this._indexValue = indexValue;
    }

    @Override
    protected IObjectsList getEntriesByIndex(Context context, TypeData typeData, TypeDataIndex<Object> index, boolean fifoGroupsScan) {
        IndexChoiceNode fatherNode;
        if (!typeData.disableIdIndexForEntries(index) || this._indexValue == null) {
            if (this._convertedValueWrapper == null) {
                this._convertedValueWrapper = ConvertedObjectWrapper.create(this._indexValue, index.getValueType());
            }
            if (this._convertedValueWrapper == null) {
                return null;
            }
        }
        IEntryCacheInfo res = null;
        res = typeData.disableIdIndexForEntries(index) && this._indexValue != null ? typeData.getCacheManager().getPEntryByUid(typeData.generateUid(this._indexValue)) : index.getIndexEntries(this._convertedValueWrapper.getValue());
        if (fifoGroupsScan && res != null) {
            context.setFifoGroupIndexUsedInFifoGroupScan(res, index);
        }
        if (context.getExplainPlanContext() != null && context.getExplainPlanContext().getSingleExplainPlan() != null && (fatherNode = context.getExplainPlanContext().getFatherNode()) == null) {
            IndexChoiceNode choiceNode = new IndexChoiceNode("AND");
            context.getExplainPlanContext().getSingleExplainPlan().addScanIndexChoiceNode(typeData.getClassName(), choiceNode);
            context.getExplainPlanContext().setFatherNode(choiceNode);
        }
        return res;
    }

    @Override
    public boolean requiresOrderedIndex() {
        return false;
    }

    @Override
    protected boolean hasIndexValue() {
        return this._indexValue != null;
    }

    @Override
    public Object getIndexValue() {
        return this._indexValue;
    }

    protected void setIndexValue(Object indexValue) {
        this._indexValue = indexValue;
    }

    @Override
    public boolean supportsFifoOrder() {
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._indexValue = in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this._indexValue);
    }

    @Override
    public boolean supportsTemplateIndex() {
        return true;
    }
}

