/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.AbstractQueryIndex;
import com.gigaspaces.internal.query.ConvertedObjectWrapper;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.query.explainplan.IndexChoiceNode;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.kernel.list.IObjectsList;
import com.j_spaces.kernel.list.MultiStoredList;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;

@InternalApi
public class InValueIndexScanner
extends AbstractQueryIndex {
    private static final long serialVersionUID = 1L;
    private Set<Object> _indexInValueSet;
    private transient ConvertedObjectWrapper _convertedValueWrapper;

    public InValueIndexScanner() {
    }

    public InValueIndexScanner(String indexName, Set<Object> indexInValueSet) {
        super(indexName);
        this._indexInValueSet = indexInValueSet;
    }

    @Override
    public IObjectsList getIndexedEntriesByType(Context context, TypeData typeData, ITemplateHolder template, int latestIndexToConsider) {
        TypeDataIndex<?> index;
        if (template.isFifoGroupPoll() && ((index = typeData.getIndex(this.getIndexName())) == null || !index.isFifoGroupsMainIndex())) {
            return IQueryIndexScanner.RESULT_IGNORE_INDEX;
        }
        IndexChoiceNode fatherNode = null;
        IndexChoiceNode choiceNode = null;
        if (context.getExplainPlanContext() != null && context.getExplainPlanContext().getSingleExplainPlan() != null) {
            fatherNode = context.getExplainPlanContext().getFatherNode();
            choiceNode = new IndexChoiceNode("IN");
            context.getExplainPlanContext().getSingleExplainPlan().addScanIndexChoiceNode(typeData.getClassName(), choiceNode);
            context.getExplainPlanContext().setFatherNode(choiceNode);
        }
        IObjectsList indexedEntriesByType = super.getIndexedEntriesByType(context, typeData, template, latestIndexToConsider);
        if (context.getExplainPlanContext() != null && context.getExplainPlanContext().getSingleExplainPlan() != null && choiceNode.getOptions().size() != 0) {
            choiceNode.setChosen(choiceNode.getOptions().get(0));
            context.getExplainPlanContext().setFatherNode(fatherNode);
        }
        return indexedEntriesByType;
    }

    @Override
    protected IObjectsList getEntriesByIndex(Context context, TypeData typeData, TypeDataIndex<Object> index, boolean fifoGroupsScan) {
        MultiStoredList inMatchResult = new MultiStoredList();
        for (Object indexValue : this._indexInValueSet) {
            if (!typeData.disableIdIndexForEntries(index) || indexValue == null) {
                this._convertedValueWrapper = ConvertedObjectWrapper.create(indexValue, index.getValueType());
                if (this._convertedValueWrapper == null) {
                    return null;
                }
            }
            IEntryCacheInfo matchingEntries = null;
            matchingEntries = typeData.disableIdIndexForEntries(index) && indexValue != null ? typeData.getCacheManager().getPEntryByUid(typeData.generateUid(indexValue)) : index.getIndexEntries(this._convertedValueWrapper.getValue());
            if (matchingEntries == null) continue;
            inMatchResult.add(matchingEntries);
            if (!fifoGroupsScan) continue;
            context.setFifoGroupIndexUsedInFifoGroupScan(matchingEntries, index);
        }
        return inMatchResult;
    }

    @Override
    public boolean requiresOrderedIndex() {
        return false;
    }

    @Override
    protected boolean hasIndexValue() {
        return !this._indexInValueSet.isEmpty();
    }

    @Override
    public Object getIndexValue() {
        return null;
    }

    public Set<Object> get_indexInValueSet() {
        return this._indexInValueSet;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._indexInValueSet = (Set)IOUtils.readObject(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeObject(out, this._indexInValueSet);
    }

    @Override
    public boolean supportsTemplateIndex() {
        return false;
    }
}

