/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.AbstractQueryIndex;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.list.IObjectsList;
import com.j_spaces.kernel.list.MultiStoredList;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@InternalApi
public class NotRegexIndexScanner
extends AbstractQueryIndex {
    private static final long serialVersionUID = 1L;
    private String _regex;

    public NotRegexIndexScanner() {
    }

    public NotRegexIndexScanner(String indexName, String regex) {
        super(indexName);
        this._regex = regex;
    }

    @Override
    public IObjectsList getIndexedEntriesByType(Context context, TypeData typeData, ITemplateHolder template, int latestIndexToConsider) {
        TypeDataIndex<?> index;
        if (template.isFifoGroupPoll() && ((index = typeData.getIndex(this.getIndexName())) == null || !index.isFifoGroupsMainIndex())) {
            return IQueryIndexScanner.RESULT_IGNORE_INDEX;
        }
        return super.getIndexedEntriesByType(context, typeData, template, latestIndexToConsider);
    }

    @Override
    protected IObjectsList getEntriesByIndex(Context context, TypeData typeData, TypeDataIndex<Object> index, boolean fifoGroupsScan) {
        if (index.isUniqueIndex()) {
            return IQueryIndexScanner.RESULT_IGNORE_INDEX;
        }
        if (index.getNonUniqueEntriesStore().size() == 0 || typeData.getEntries().size() / index.getNonUniqueEntriesStore().size() < 2) {
            return IQueryIndexScanner.RESULT_IGNORE_INDEX;
        }
        MultiStoredList matchResult = new MultiStoredList();
        Pattern pattern = index.getCacheManager().getEngine().getTemplateScanner().getRegexCache().getPattern(this._regex);
        Set indexes = index.getNonUniqueEntriesStore().keySet();
        for (Object indexValue : indexes) {
            IStoredList<IEntryCacheInfo> matchingEntries = null;
            Matcher m = pattern.matcher((String)indexValue);
            if (m.matches() || (matchingEntries = index.getIndexEntries(indexValue)) == null) continue;
            matchResult.add(matchingEntries);
            if (!fifoGroupsScan) continue;
            context.setFifoGroupIndexUsedInFifoGroupScan(matchingEntries, index);
        }
        return matchResult;
    }

    @Override
    public boolean requiresOrderedIndex() {
        return false;
    }

    @Override
    protected boolean hasIndexValue() {
        return true;
    }

    @Override
    public Object getIndexValue() {
        return null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._regex = IOUtils.readString(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeString(out, this._regex);
    }

    @Override
    public boolean supportsTemplateIndex() {
        return false;
    }
}

