/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.AbstractCustomQuery;
import com.gigaspaces.internal.query.ExactValueIndexScanner;
import com.gigaspaces.server.ServerEntry;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.client.SQLQuery;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

@InternalApi
public class PropertiesQuery
extends AbstractCustomQuery {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> _properties;

    public PropertiesQuery() {
    }

    public PropertiesQuery(Map<String, Object> properties, ITypeDesc typeDesc) {
        this._properties = properties;
        Iterator<Map.Entry<String, Object>> iter = this._properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            String propertyName = entry.getKey();
            Object indexValue = entry.getValue();
            if (indexValue == null) {
                iter.remove();
                continue;
            }
            if (!typeDesc.getIndexes().containsKey(propertyName)) continue;
            this.addCustomIndex(new ExactValueIndexScanner(propertyName, indexValue));
        }
    }

    @Override
    public boolean matches(CacheManager cacheManager, ServerEntry entry, String skipAlreadyMatchedIndexPath) {
        for (Map.Entry<String, Object> property : this._properties.entrySet()) {
            Object entryPropertyValue;
            String propertyName = property.getKey();
            Object propertyValue = property.getValue();
            if (this.match(propertyValue, entryPropertyValue = entry.getPropertyValue(propertyName))) continue;
            return false;
        }
        return true;
    }

    protected boolean match(Object actual, Object expected) {
        if (actual == expected) {
            return true;
        }
        if (actual == null || expected == null) {
            return false;
        }
        return actual.equals(expected);
    }

    @Override
    public SQLQuery toSQLQuery(ITypeDesc typeDesc) {
        LinkedList<Object> preparedValues = new LinkedList<Object>();
        StringBuilder b = new StringBuilder();
        for (Map.Entry<String, Object> property : this._properties.entrySet()) {
            String propertyName = property.getKey();
            Object propertyValue = property.getValue();
            if (b.length() > 0) {
                b.append(" and ");
            }
            b.append(propertyName + " = ? ");
            preparedValues.add(propertyValue);
        }
        return new SQLQuery(typeDesc.getTypeName(), b.toString(), preparedValues.toArray());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int length = in.readInt();
        if (length >= 0) {
            this._properties = new HashMap<String, Object>(length);
            for (int i = 0; i < length; ++i) {
                String key = IOUtils.readRepetitiveString(in);
                Object value = IOUtils.readObject(in);
                this._properties.put(key, value);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this._properties == null) {
            out.writeInt(-1);
        } else {
            int length = this._properties.size();
            out.writeInt(length);
            for (Map.Entry<String, Object> entry : this._properties.entrySet()) {
                IOUtils.writeRepetitiveString(out, entry.getKey());
                IOUtils.writeObject(out, entry.getValue());
            }
        }
    }
}

