/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.query.ExactValueIndexScanner;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.query.NullValueIndexScanner;
import com.gigaspaces.internal.query.RangeIndexScanner;

@InternalApi
public class QueryIndexes {
    public static IQueryIndexScanner newNullValueIndexScanner(String indexName) {
        return new NullValueIndexScanner(indexName);
    }

    public static IQueryIndexScanner newIndexScanner(String indexName, Object indexValue) {
        if (indexValue == null) {
            return new NullValueIndexScanner(indexName);
        }
        return new ExactValueIndexScanner(indexName, indexValue);
    }

    public static IQueryIndexScanner newRangeIndexScanner(String indexName, Comparable min, boolean includeMin, Comparable max, boolean includeMax) {
        return new RangeIndexScanner(indexName, min, includeMin, max, includeMax);
    }

    public static IQueryIndexScanner newAscendingIndexScanner(String indexName, Comparable from) {
        if (from == null) {
            throw new IllegalArgumentException("Illegal index - 'from' parameter can not be null");
        }
        return new RangeIndexScanner(indexName, from, true, null, true);
    }

    public static IQueryIndexScanner newDescendingIndexScanner(String indexName, Comparable from) {
        if (from == null) {
            throw new IllegalArgumentException("Illegal index - 'from' parameter can not be null");
        }
        return new RangeIndexScanner(indexName, null, true, from, true);
    }
}

