/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.metadata.SpacePropertyInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfoRepository;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.query.ISpaceQuery;
import com.gigaspaces.query.IdQuery;
import com.gigaspaces.query.IdsQuery;
import com.gigaspaces.query.QueryResultType;
import com.j_spaces.core.client.SQLQuery;
import java.util.Map;

@InternalApi
public class QueryUtils {
    public static String getQueryDescription(Object query) {
        StringBuilder sb = new StringBuilder();
        QueryUtils.getQueryDescription(query, sb);
        return sb.toString();
    }

    public static void getQueryDescription(Object query, StringBuilder sb) {
        if (query == null) {
            return;
        }
        if (query instanceof String) {
            sb.append(query);
        } else if (query instanceof ISpaceQuery) {
            if (query instanceof SQLQuery) {
                QueryUtils.getSqlQueryDescription((SQLQuery)query, sb);
            } else if (query instanceof IdQuery) {
                QueryUtils.getIdQueryDescription((IdQuery)query, sb);
            } else if (query instanceof IdsQuery) {
                QueryUtils.getIdsQueryDescription((IdsQuery)query, sb);
            } else {
                sb.append("Unrecognized space query class: " + query.getClass());
            }
        } else if (query instanceof SpaceDocument) {
            QueryUtils.getDocumentTemplateDescription((SpaceDocument)query, sb);
        } else {
            QueryUtils.getObjectTemplateDescription(query, sb);
        }
    }

    private static void getDocumentTemplateDescription(SpaceDocument template, StringBuilder sb) {
        sb.append("Document Template").append(StringUtils.NEW_LINE);
        QueryUtils.appendTypeName(sb, template.getTypeName());
        for (Map.Entry<String, Object> property : template.getProperties().entrySet()) {
            Object propertyValue = property.getValue();
            if (propertyValue == null) continue;
            QueryUtils.appendValueWithType(sb, "\t" + property.getKey(), propertyValue);
        }
    }

    private static void getObjectTemplateDescription(Object template, StringBuilder sb) {
        sb.append("Object Template").append(StringUtils.NEW_LINE);
        SpaceTypeInfo typeInfo = SpaceTypeInfoRepository.getTypeInfo(template.getClass());
        QueryUtils.appendTypeName(sb, typeInfo.getName());
        int numOfProperties = typeInfo.getNumOfSpaceProperties();
        for (int i = 0; i < numOfProperties; ++i) {
            SpacePropertyInfo property = typeInfo.getProperty(i);
            Object propertyValue = property.getValue(template);
            if (propertyValue == null) continue;
            QueryUtils.appendValueWithType(sb, "\t" + property.getName(), propertyValue);
        }
    }

    private static void getSqlQueryDescription(SQLQuery<?> query, StringBuilder sb) {
        sb.append("SQL Query").append(StringUtils.NEW_LINE);
        QueryUtils.appendTypeName(sb, query.getTypeName());
        QueryUtils.appendValue(sb, "Criteria", query.getQuery());
        Object[] parameters = query.getParameters();
        QueryUtils.appendValue(sb, "Parameters", parameters == null ? 0 : parameters.length);
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                QueryUtils.appendValueWithType(sb, "\t#" + (i + 1), parameters[i]);
            }
        }
        QueryUtils.appendValueWithTypeIfNotNull(sb, "Template", query.getObject());
        QueryUtils.appendRouting(sb, query.getRouting());
        QueryUtils.appendQueryResultType(sb, query.getQueryResultType());
        QueryUtils.appendProjections(sb, query.getProjections());
    }

    private static void getIdQueryDescription(IdQuery<?> query, StringBuilder sb) {
        sb.append("ID Query").append(StringUtils.NEW_LINE);
        QueryUtils.appendTypeName(sb, query.getTypeName());
        QueryUtils.appendValueWithType(sb, "Id", query.getId());
        QueryUtils.appendRouting(sb, query.getRouting());
        QueryUtils.appendVersion(sb, query.getVersion());
        QueryUtils.appendQueryResultType(sb, query.getQueryResultType());
        QueryUtils.appendProjections(sb, query.getProjections());
    }

    private static void getIdsQueryDescription(IdsQuery<?> query, StringBuilder sb) {
        sb.append("IDs Query").append(StringUtils.NEW_LINE);
        QueryUtils.appendTypeName(sb, query.getTypeName());
        if (query.getRoutings() != null) {
            QueryUtils.appendIdsWithMultipleRoutings(sb, query.getIds(), query.getRoutings());
        } else {
            QueryUtils.appendValueWithTypeIfNotNull(sb, "Routing", query.getRouting());
            QueryUtils.appendIds(sb, query.getIds());
        }
        QueryUtils.appendQueryResultType(sb, query.getQueryResultType());
        QueryUtils.appendProjections(sb, query.getProjections());
    }

    private static void appendIdsWithMultipleRoutings(StringBuilder sb, Object[] ids, Object[] routings) {
        QueryUtils.appendValue(sb, "ID-Routing pairs", ids.length);
        for (int i = 0; i < ids.length; ++i) {
            sb.append("\t#" + (i + 1) + " ");
            QueryUtils.appendValueWithType(sb, "ID", ids[i], false);
            QueryUtils.appendValueWithType(sb, ", routing", routings[i]);
        }
    }

    private static void appendIds(StringBuilder sb, Object[] ids) {
        QueryUtils.appendValue(sb, "IDs", ids.length);
        for (int i = 0; i < ids.length; ++i) {
            QueryUtils.appendValueWithType(sb, "\t#" + (i + 1), ids[i]);
        }
    }

    private static void appendTypeName(StringBuilder sb, String typeName) {
        QueryUtils.appendValue(sb, "Entry type", typeName);
    }

    private static void appendRouting(StringBuilder sb, Object routing) {
        if (routing != null) {
            QueryUtils.appendValueWithType(sb, "Routing", routing);
        }
    }

    private static void appendQueryResultType(StringBuilder sb, QueryResultType queryResultType) {
        if (queryResultType != QueryResultType.DEFAULT && queryResultType != QueryResultType.NOT_SET) {
            QueryUtils.appendValue(sb, "Query result type", (Object)queryResultType);
        }
    }

    private static void appendVersion(StringBuilder sb, int version) {
        if (version != 0) {
            QueryUtils.appendValue(sb, "Version", version);
        }
    }

    private static void appendProjections(StringBuilder sb, String[] projections) {
        if (projections == null || projections.length == 0) {
            return;
        }
        sb.append("Projections: ");
        sb.append(projections[0]);
        for (int i = 1; i < projections.length; ++i) {
            sb.append(", ").append(projections[i]);
        }
        sb.append(StringUtils.NEW_LINE);
    }

    private static void appendValue(StringBuilder sb, String name, Object value) {
        QueryUtils.append(sb, name, value, false, true);
    }

    private static void appendValueWithType(StringBuilder sb, String name, Object value) {
        QueryUtils.append(sb, name, value, true, true);
    }

    private static void appendValueWithType(StringBuilder sb, String name, Object value, boolean appendNewLine) {
        QueryUtils.append(sb, name, value, true, appendNewLine);
    }

    private static void appendValueWithTypeIfNotNull(StringBuilder sb, String name, Object value) {
        if (value != null) {
            QueryUtils.append(sb, name, value, true, true);
        }
    }

    private static void append(StringBuilder sb, String name, Object value, boolean includeType, boolean appendNewLine) {
        sb.append(name);
        sb.append(": ");
        if (value == null) {
            sb.append("NULL");
        } else {
            sb.append(value);
            if (includeType) {
                QueryUtils.appendType(sb, value.getClass());
            }
        }
        if (appendNewLine) {
            sb.append(StringUtils.NEW_LINE);
        }
    }

    private static void appendType(StringBuilder sb, Class<?> type) {
        sb.append(" [").append(type.getName()).append("]");
    }

    private static Class<?> getCommonTypeIfExists(Object[] values) {
        if (values == null || values.length == 0 || values[0] == null) {
            return null;
        }
        Class<?> commonType = values[0].getClass();
        for (int i = 1; i < values.length; ++i) {
            if (values[i] != null && values[i].getClass().equals(commonType)) continue;
            return null;
        }
        return commonType;
    }
}

