/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.query.AbstractQueryIndex;
import com.gigaspaces.internal.query.CompoundConvertedObjectWrapper;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.jdbc.builder.range.Range;
import com.j_spaces.jdbc.builder.range.SegmentRange;
import com.j_spaces.kernel.list.IObjectsList;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

@InternalApi
public class RangeCompoundIndexScanner
extends AbstractQueryIndex {
    private static final long serialVersionUID = 1L;
    private Comparable<?>[] _min;
    private boolean _includeMin;
    private boolean _includeMinFirstSegment;
    private Comparable<?>[] _max;
    private boolean _includeMax;
    private boolean _includeMaxFirstSegment;
    private transient short _minMatchCode;
    private transient CompoundConvertedObjectWrapper _convertedMinWrapper;
    private transient CompoundConvertedObjectWrapper _convertedMaxWrapper;

    public RangeCompoundIndexScanner() {
    }

    public RangeCompoundIndexScanner(String indexName, Comparable<?>[] min, boolean includeMin, boolean includeMinFirstSegment, Comparable<?>[] max, boolean includeMax, boolean includeMaxFirstSegment) {
        super(indexName);
        this._min = min;
        this._includeMin = includeMin;
        this._max = max;
        this._includeMax = includeMax;
        this._minMatchCode = this.initialize();
    }

    private short initialize() {
        return this._includeMin ? (short)3 : 2;
    }

    @Override
    protected IObjectsList getEntriesByIndex(Context context, TypeData typeData, TypeDataIndex<Object> index, boolean fifoGroupsScan) {
        if (this._convertedMinWrapper == null) {
            this._convertedMinWrapper = CompoundConvertedObjectWrapper.createForExtendedMatch(this._min, index, true, this._includeMin, this._includeMinFirstSegment);
        }
        if (this._convertedMinWrapper == null) {
            return null;
        }
        if (this._convertedMaxWrapper == null) {
            this._convertedMaxWrapper = CompoundConvertedObjectWrapper.createForExtendedMatch(this._max, index, false, this._includeMax, this._includeMaxFirstSegment);
        }
        if (this._convertedMaxWrapper == null) {
            return null;
        }
        return !fifoGroupsScan ? index.getExtendedIndexForScanning().establishScan(this._convertedMinWrapper.getValue(), this._minMatchCode, this._convertedMaxWrapper.getValue(), this._includeMax) : index.getExtendedFifoGroupsIndexForScanning().establishScan(this._convertedMinWrapper.getValue(), this._minMatchCode, this._convertedMaxWrapper.getValue(), this._includeMax);
    }

    @Override
    protected boolean hasIndexValue() {
        return this._min != null || this._max != null;
    }

    @Override
    public Object getIndexValue() {
        return this._min;
    }

    @Override
    public boolean requiresOrderedIndex() {
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._min = (Comparable[])in.readObject();
        this._includeMin = in.readBoolean();
        this._includeMinFirstSegment = in.readBoolean();
        this._max = (Comparable[])in.readObject();
        this._includeMax = in.readBoolean();
        this._includeMaxFirstSegment = in.readBoolean();
        this._minMatchCode = this.initialize();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this._min);
        out.writeBoolean(this._includeMin);
        out.writeBoolean(this._includeMinFirstSegment);
        out.writeObject(this._max);
        out.writeBoolean(this._includeMax);
        out.writeBoolean(this._includeMaxFirstSegment);
    }

    @Override
    public boolean supportsTemplateIndex() {
        return false;
    }

    public static RangeCompoundIndexScanner build(String name, List<Range> possibleSegments, boolean isFirstSegmentIndexed) {
        Comparable[] min = null;
        Comparable[] max = null;
        boolean includeMin = false;
        boolean includeMax = false;
        boolean includeMinFirstSegment = false;
        boolean includeMaxFirstSegment = false;
        for (int i = 0; i < possibleSegments.size(); ++i) {
            if (!possibleSegments.get(i).isSegmentRange()) {
                return null;
            }
            SegmentRange r = (SegmentRange)possibleSegments.get(i);
            if (r.getMin() != null) {
                if (min == null) {
                    if (i > 0) {
                        return null;
                    }
                    min = new Comparable[possibleSegments.size()];
                }
                if (i == 0) {
                    if (!r.isIncludeMin() && isFirstSegmentIndexed) {
                        return null;
                    }
                    includeMinFirstSegment = r.isIncludeMin();
                }
                min[i] = r.getMin();
                if (r.isIncludeMin()) {
                    includeMin = true;
                }
            }
            if (r.getMax() == null) continue;
            if (max == null) {
                if (i > 0) {
                    return null;
                }
                max = new Comparable[possibleSegments.size()];
            }
            if (i == 0) {
                if (!r.isIncludeMax() && isFirstSegmentIndexed) {
                    return null;
                }
                includeMaxFirstSegment = r.isIncludeMax();
            }
            max[i] = r.getMax();
            if (!r.isIncludeMax()) continue;
            includeMax = true;
        }
        if (min == null && max == null) {
            return null;
        }
        return new RangeCompoundIndexScanner(name, min, includeMin, includeMinFirstSegment, max, includeMax, includeMaxFirstSegment);
    }
}

