/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.query.AbstractQueryIndex;
import com.gigaspaces.internal.query.ConvertedObjectWrapper;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.kernel.list.IObjectsList;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class RangeIndexScanner
extends AbstractQueryIndex {
    private static final long serialVersionUID = -5025380388944017192L;
    private Comparable<?> _min;
    private boolean _includeMin;
    private Comparable<?> _max;
    private boolean _includeMax;
    private transient short _minMatchCode;
    private transient ConvertedObjectWrapper _convertedMinWrapper;
    private transient ConvertedObjectWrapper _convertedMaxWrapper;

    public RangeIndexScanner() {
    }

    public RangeIndexScanner(String indexName, Comparable<?> min, boolean includeMin, Comparable<?> max, boolean includeMax) {
        super(indexName);
        this._min = min;
        this._includeMin = includeMin;
        this._max = max;
        this._includeMax = includeMax;
        this._minMatchCode = this.initialize();
    }

    private short initialize() {
        return this._includeMin ? (short)3 : 2;
    }

    @Override
    protected IObjectsList getEntriesByIndex(Context context, TypeData typeData, TypeDataIndex<Object> index, boolean fifoGroupsScan) {
        if (this._convertedMinWrapper == null) {
            this._convertedMinWrapper = ConvertedObjectWrapper.create(this._min, index.getValueType());
        }
        if (this._convertedMinWrapper == null) {
            return null;
        }
        if (this._convertedMaxWrapper == null) {
            this._convertedMaxWrapper = ConvertedObjectWrapper.create(this._max, index.getValueType());
        }
        if (this._convertedMaxWrapper == null) {
            return null;
        }
        return !fifoGroupsScan ? index.getExtendedIndexForScanning().establishScan(this._convertedMinWrapper.getValue(), this._minMatchCode, this._convertedMaxWrapper.getValue(), this._includeMax) : index.getExtendedFifoGroupsIndexForScanning().establishScan(this._convertedMinWrapper.getValue(), this._minMatchCode, this._convertedMaxWrapper.getValue(), this._includeMax);
    }

    @Override
    protected boolean hasIndexValue() {
        return this._min != null || this._max != null;
    }

    @Override
    public Object getIndexValue() {
        return this._min;
    }

    public Comparable<?> getMin() {
        return this._min;
    }

    public Comparable<?> getMax() {
        return this._max;
    }

    public boolean isIncludeMin() {
        return this._includeMin;
    }

    public boolean isIncludeMax() {
        return this._includeMax;
    }

    @Override
    public boolean requiresOrderedIndex() {
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._min = (Comparable)in.readObject();
        this._includeMin = in.readBoolean();
        this._max = (Comparable)in.readObject();
        this._includeMax = in.readBoolean();
        this._minMatchCode = this.initialize();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this._min);
        out.writeBoolean(this._includeMin);
        out.writeObject(this._max);
        out.writeBoolean(this._includeMax);
    }

    @Override
    public boolean supportsTemplateIndex() {
        return false;
    }
}

