/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@InternalApi
public class RegexCache {
    private final int _cacheSize;
    private final ConcurrentHashMap<String, Pattern> _regexCache = new ConcurrentHashMap();
    private final LinkedList<String> _regexItems = new LinkedList();

    public RegexCache(SpaceConfigReader configReader) {
        int size = configReader.getIntSpaceProperty("engine.extended-match.regular-expressions-cache-size", "300");
        if (size < 0) {
            throw new IllegalArgumentException("Invalid regular-expressions cache size value specified: " + size);
        }
        this._cacheSize = size;
    }

    public RegexCache() {
        this._cacheSize = Integer.parseInt("300");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pattern getPattern(String string_exp) throws PatternSyntaxException {
        Pattern p = this._regexCache.get(string_exp);
        if (p == null) {
            LinkedList<String> linkedList = this._regexItems;
            synchronized (linkedList) {
                p = this._regexCache.get(string_exp);
                if (p == null) {
                    Pattern new_p = Pattern.compile(string_exp);
                    if (this._regexItems.size() > this._cacheSize) {
                        String del = this._regexItems.removeFirst();
                        this._regexCache.remove(del);
                    }
                    this._regexCache.put(string_exp, new_p);
                    this._regexItems.addLast(string_exp);
                    p = new_p;
                }
            }
        }
        return p;
    }
}

