/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.AbstractQueryIndex;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.j_spaces.core.cache.QueryExtensionIndexManagerWrapper;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.kernel.list.IObjectsList;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class RelationIndexScanner
extends AbstractQueryIndex {
    private static final long serialVersionUID = 1L;
    private String typeName;
    private String path;
    private String namespace;
    private String relation;
    private Object subject;

    public RelationIndexScanner() {
    }

    public RelationIndexScanner(String typeName, String path, String namespace, String relation, Object subject) {
        super(path);
        this.typeName = typeName;
        this.path = path;
        this.namespace = namespace;
        this.relation = relation;
        this.subject = subject;
    }

    @Override
    public IObjectsList getIndexedEntriesByType(Context context, TypeData typeData, ITemplateHolder template, int latestIndexToConsider) {
        return this.getEntriesByIndex(context, typeData, null, false);
    }

    @Override
    protected IObjectsList getEntriesByIndex(Context context, TypeData typeData, TypeDataIndex<Object> index, boolean fifoGroupsScan) {
        QueryExtensionIndexManagerWrapper handler = typeData.getCacheManager().getQueryExtensionManager(this.namespace);
        if (handler != null) {
            return handler.scanIndex(typeData.getClassName(), this.path, this.relation, this.subject);
        }
        return IQueryIndexScanner.RESULT_IGNORE_INDEX;
    }

    @Override
    public boolean requiresOrderedIndex() {
        return false;
    }

    @Override
    protected boolean hasIndexValue() {
        return true;
    }

    @Override
    public Object getIndexValue() {
        return null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.typeName = IOUtils.readString(in);
        this.path = IOUtils.readString(in);
        this.namespace = IOUtils.readString(in);
        this.relation = IOUtils.readString(in);
        this.subject = IOUtils.readObject(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeString(out, this.typeName);
        IOUtils.writeString(out, this.path);
        IOUtils.writeString(out, this.namespace);
        IOUtils.writeString(out, this.relation);
        IOUtils.writeObject(out, this.subject);
    }

    @Override
    public boolean supportsTemplateIndex() {
        return false;
    }
}

