/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.query.AbstractQueryIndex;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.query.explainplan.IndexChoiceNode;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.kernel.list.IObjectsList;
import com.j_spaces.kernel.list.ScanUidsIterator;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;

@InternalApi
public class UidsIndexScanner
extends AbstractQueryIndex {
    private static final long serialVersionUID = 1L;
    private Set<String> _uids;

    public UidsIndexScanner() {
    }

    public UidsIndexScanner(String indexName, Set<String> indexInValueSet) {
        super(indexName);
        this._uids = indexInValueSet;
    }

    @Override
    public IObjectsList getIndexedEntriesByType(Context context, TypeData typeData, ITemplateHolder template, int latestIndexToConsider) {
        if (template.isFifoGroupPoll()) {
            return IQueryIndexScanner.RESULT_IGNORE_INDEX;
        }
        IndexChoiceNode fatherNode = null;
        IndexChoiceNode choiceNode = null;
        if (context.getExplainPlanContext() != null && context.getExplainPlanContext().getSingleExplainPlan() != null) {
            fatherNode = context.getExplainPlanContext().getFatherNode();
            choiceNode = new IndexChoiceNode("UIDS");
            context.getExplainPlanContext().getSingleExplainPlan().addScanIndexChoiceNode(typeData.getClassName(), choiceNode);
            context.getExplainPlanContext().setFatherNode(choiceNode);
        }
        ScanUidsIterator iter = new ScanUidsIterator(typeData.getCacheManager(), this._uids);
        if (context.getExplainPlanContext() != null && context.getExplainPlanContext().getSingleExplainPlan() != null && choiceNode.getOptions().size() != 0) {
            choiceNode.setChosen(choiceNode.getOptions().get(0));
            context.getExplainPlanContext().setFatherNode(fatherNode);
        }
        return iter;
    }

    @Override
    protected IObjectsList getEntriesByIndex(Context context, TypeData typeData, TypeDataIndex<Object> index, boolean fifoGroupsScan) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean requiresOrderedIndex() {
        return false;
    }

    @Override
    protected boolean hasIndexValue() {
        return !this._uids.isEmpty();
    }

    @Override
    public Object getIndexValue() {
        return null;
    }

    public Set<Object> get_indexInValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._uids = new HashSet<String>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this._uids.add(in.readUTF());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this._uids.size());
        if (this._uids.size() > 0) {
            for (String s : this._uids) {
                out.writeUTF(s);
            }
        }
    }

    @Override
    public boolean supportsTemplateIndex() {
        return false;
    }

    @Override
    public boolean isUidsScanner() {
        return true;
    }
}

