/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.continous;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.AbstractDataEventSession;
import com.gigaspaces.events.DataEventSession;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.events.batching.BatchRemoteEvent;
import com.gigaspaces.events.batching.BatchRemoteEventListener;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.query.continous.ContinousQueryConfig;
import com.gigaspaces.internal.query.continous.ContinousQueryListener;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import com.j_spaces.core.exception.internal.ProxyInternalSpaceException;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.Queue;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class ContinousQuery
implements RemoteEventListener,
BatchRemoteEventListener {
    private final IJSpace _spaceProxy;
    private final Object _query;
    private final ContinousQueryListener _listener;
    private final ContinousQueryConfig _config;
    private final AbstractDataEventSession _eventSession;
    private final Queue<EntryArrivedRemoteEvent> _pendingEvents;
    private final EventRegistration _eventRegistration;
    private Thread _eventsProcessorThread;
    private boolean _doneFirstStage;
    private boolean _closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContinousQuery(ISpaceProxy spaceProxy, ITemplatePacket query, ContinousQueryListener listener, ContinousQueryConfig config, DataEventSession eventSession) throws RemoteException {
        this._spaceProxy = spaceProxy;
        this._query = query;
        this._listener = listener;
        this._config = config;
        this._eventSession = (AbstractDataEventSession)eventSession;
        this._pendingEvents = new LinkedList<EntryArrivedRemoteEvent>();
        NotifyInfo notifyInfo = this._eventSession.createNotifyInfo(this, this._config.getNotifyActionType());
        notifyInfo.setReturnOnlyUids(this._config.isReturnOnlyUid());
        try {
            this._eventRegistration = this._eventSession.addListener(this._query, Long.MAX_VALUE, notifyInfo);
            this.readExistingEntries();
        }
        catch (TransactionException e) {
            throw new IllegalStateException("Transaction exception occurred but transactions are not used.");
        }
        catch (UnusableEntryException e) {
            throw new ProxyInternalSpaceException("Failed to read existing entries", e);
        }
        Queue<EntryArrivedRemoteEvent> queue = this._pendingEvents;
        synchronized (queue) {
            if (!this._pendingEvents.isEmpty()) {
                this._eventsProcessorThread = new GSThread((Runnable)new PendingEventsProcessor(), "ContinuousQueryEventsProcessor");
                this._eventsProcessorThread.setDaemon(true);
                this._eventsProcessorThread.start();
            } else {
                this._doneFirstStage = true;
            }
        }
    }

    private void readExistingEntries() throws RemoteException, UnusableEntryException, TransactionException {
        Object[] results;
        for (Object result : results = this._spaceProxy.readMultiple(this._query, null, Integer.MAX_VALUE, this._config.getReadModifiers())) {
            this._listener.onExisting((IEntryPacket)result);
        }
    }

    public synchronized void close() throws RemoteException {
        if (this._closed) {
            return;
        }
        this._closed = true;
        this._eventSession.removeListener(this._eventRegistration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(RemoteEvent remoteEvent) throws UnknownEventException, RemoteException {
        if (!this._doneFirstStage) {
            Queue<EntryArrivedRemoteEvent> queue = this._pendingEvents;
            synchronized (queue) {
                if (!this._doneFirstStage) {
                    this._pendingEvents.add((EntryArrivedRemoteEvent)remoteEvent);
                    return;
                }
            }
        }
        this._listener.onEvent((EntryArrivedRemoteEvent)remoteEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyBatch(BatchRemoteEvent theEvents) throws UnknownEventException, RemoteException {
        if (!this._doneFirstStage) {
            Queue<EntryArrivedRemoteEvent> object = this._pendingEvents;
            synchronized (object) {
                if (!this._doneFirstStage) {
                    for (RemoteEvent remoteEvent : theEvents.getEvents()) {
                        this._pendingEvents.add((EntryArrivedRemoteEvent)remoteEvent);
                    }
                    return;
                }
            }
        }
        for (RemoteEvent remoteEvent : theEvents.getEvents()) {
            this._listener.onEvent((EntryArrivedRemoteEvent)remoteEvent);
        }
    }

    private class PendingEventsProcessor
    implements Runnable {
        private PendingEventsProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!ContinousQuery.this._closed) {
                Queue queue = ContinousQuery.this._pendingEvents;
                synchronized (queue) {
                    EntryArrivedRemoteEvent event = (EntryArrivedRemoteEvent)ContinousQuery.this._pendingEvents.poll();
                    if (event == null) {
                        ContinousQuery.this._doneFirstStage = true;
                        return;
                    }
                    ContinousQuery.this._listener.onEvent(event);
                }
            }
        }
    }
}

