/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.explainplan;

import com.gigaspaces.api.ExperimentalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.explainplan.IndexInfo;
import com.gigaspaces.internal.query.explainplan.QueryOperator;
import com.gigaspaces.metadata.index.SpaceIndexType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@ExperimentalApi
public class BetweenIndexInfo
extends IndexInfo {
    private Comparable min;
    private Comparable max;
    private boolean includeMin;
    private boolean includeMax;

    public BetweenIndexInfo() {
    }

    public BetweenIndexInfo(String name, Integer size, SpaceIndexType type, Comparable min, boolean includeMin, Comparable max, boolean includeMax, QueryOperator operator, boolean b) {
        super(name, size, type, null, operator);
        this.max = max;
        this.min = min;
        this.includeMax = includeMax;
        this.includeMin = includeMin;
        this.setUsable(b);
    }

    public Comparable getMin() {
        return this.min;
    }

    public void setMin(Comparable min) {
        this.min = min;
    }

    public Comparable getMax() {
        return this.max;
    }

    public void setMax(Comparable max) {
        this.max = max;
    }

    public boolean isIncludeMin() {
        return this.includeMin;
    }

    public void setIncludeMin(boolean includeMin) {
        this.includeMin = includeMin;
    }

    public boolean isIncludeMax() {
        return this.includeMax;
    }

    public void setIncludeMax(boolean includeMax) {
        this.includeMax = includeMax;
    }

    @Override
    protected String getCriteriaDesc() {
        return this.getName() + " BETWEEN " + this.min + " AND " + this.max;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        IOUtils.writeString(objectOutput, this.getName());
        objectOutput.writeInt(this.getSize());
        objectOutput.writeObject((Object)this.getType());
        objectOutput.writeObject((Object)this.getOperator());
        objectOutput.writeObject(this.min);
        objectOutput.writeBoolean(this.includeMin);
        objectOutput.writeObject(this.max);
        objectOutput.writeBoolean(this.includeMax);
        objectOutput.writeBoolean(this.isUsable());
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setName(IOUtils.readString(objectInput));
        this.setSize(objectInput.readInt());
        this.setType((SpaceIndexType)((Object)objectInput.readObject()));
        this.setOperator((QueryOperator)((Object)objectInput.readObject()));
        this.min = (Comparable)objectInput.readObject();
        this.includeMin = objectInput.readBoolean();
        this.max = (Comparable)objectInput.readObject();
        this.includeMax = objectInput.readBoolean();
        this.setUsable(objectInput.readBoolean());
    }
}

