/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.explainplan;

import com.gigaspaces.api.ExperimentalApi;
import com.gigaspaces.internal.query.explainplan.QueryOperator;
import com.gigaspaces.internal.query.explainplan.RangeNode;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@ExperimentalApi
public class BetweenRangeNode
extends RangeNode {
    private Comparable minValue;
    private Comparable maxValue;
    private boolean includeMin;
    private boolean includeMax;

    public BetweenRangeNode() {
    }

    public BetweenRangeNode(String fieldName, QueryOperator operator, String functionName, Comparable minValue, boolean includeMin, Comparable maxValue, boolean includeMax) {
        this.setFieldName(fieldName);
        this.setOperator(operator);
        this.setFunctionName(functionName);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.includeMax = includeMax;
        this.includeMin = includeMin;
    }

    public Comparable getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Comparable minValue) {
        this.minValue = minValue;
    }

    public Comparable getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Comparable maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public String toString() {
        return this.getOperator().toString() + '(' + (this.getFunctionName() != null ? this.getFunctionName() : this.getFieldName()) + ", [" + this.minValue + ',' + this.maxValue + "])";
    }

    public boolean isIncludeMin() {
        return this.includeMin;
    }

    public void setIncludeMin(boolean includeMin) {
        this.includeMin = includeMin;
    }

    public boolean isIncludeMax() {
        return this.includeMax;
    }

    public void setIncludeMax(boolean includeMax) {
        this.includeMax = includeMax;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getFieldName());
        out.writeObject((Object)this.getOperator());
        out.writeObject(this.getFunctionName());
        out.writeObject(this.minValue);
        out.writeBoolean(this.includeMin);
        out.writeObject(this.maxValue);
        out.writeBoolean(this.includeMax);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setFieldName((String)in.readObject());
        this.setOperator((QueryOperator)((Object)in.readObject()));
        this.setFunctionName((String)in.readObject());
        this.minValue = (Comparable)in.readObject();
        this.includeMin = in.readBoolean();
        this.maxValue = (Comparable)in.readObject();
        this.includeMax = in.readBoolean();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BetweenRangeNode that = (BetweenRangeNode)o;
        if (this.minValue != null ? !this.minValue.equals(that.minValue) : that.minValue != null) {
            return false;
        }
        return this.maxValue != null ? this.maxValue.equals(that.maxValue) : that.maxValue == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.minValue != null ? this.minValue.hashCode() : 0);
        result = 31 * result + (this.maxValue != null ? this.maxValue.hashCode() : 0);
        return result;
    }
}

